/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.Ser;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.time.zone.ZoneOffsetTransition;
import java.time.zone.ZoneRules;
import java.util.List;
import java.util.Objects;

public final class ZonedDateTime
implements Temporal,
ChronoZonedDateTime<LocalDate>,
Serializable {
    private static final long serialVersionUID = -6260982410461394882L;
    private final LocalDateTime dateTime;
    private final ZoneOffset offset;
    private final ZoneId zone;

    public static ZonedDateTime now() {
        return ZonedDateTime.now(Clock.systemDefaultZone());
    }

    public static ZonedDateTime now(ZoneId zoneId) {
        return ZonedDateTime.now(Clock.system(zoneId));
    }

    public static ZonedDateTime now(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        Instant instant = clock.instant();
        return ZonedDateTime.ofInstant(instant, clock.getZone());
    }

    public static ZonedDateTime of(LocalDate localDate, LocalTime localTime, ZoneId zoneId) {
        return ZonedDateTime.of(LocalDateTime.of(localDate, localTime), zoneId);
    }

    public static ZonedDateTime of(LocalDateTime localDateTime, ZoneId zoneId) {
        return ZonedDateTime.ofLocal(localDateTime, zoneId, null);
    }

    public static ZonedDateTime of(int n, int n2, int n3, int n4, int n5, int n6, int n7, ZoneId zoneId) {
        LocalDateTime localDateTime = LocalDateTime.of(n, n2, n3, n4, n5, n6, n7);
        return ZonedDateTime.ofLocal(localDateTime, zoneId, null);
    }

    public static ZonedDateTime ofLocal(LocalDateTime localDateTime, ZoneId zoneId, ZoneOffset zoneOffset) {
        ZoneOffset zoneOffset2;
        Objects.requireNonNull(localDateTime, "localDateTime");
        Objects.requireNonNull(zoneId, "zone");
        if (zoneId instanceof ZoneOffset) {
            return new ZonedDateTime(localDateTime, (ZoneOffset)zoneId, zoneId);
        }
        ZoneRules zoneRules = zoneId.getRules();
        List<ZoneOffset> list = zoneRules.getValidOffsets(localDateTime);
        if (list.size() == 1) {
            zoneOffset2 = list.get(0);
        } else if (list.size() == 0) {
            ZoneOffsetTransition zoneOffsetTransition = zoneRules.getTransition(localDateTime);
            localDateTime = localDateTime.plusSeconds(zoneOffsetTransition.getDuration().getSeconds());
            zoneOffset2 = zoneOffsetTransition.getOffsetAfter();
        } else {
            zoneOffset2 = zoneOffset != null && list.contains(zoneOffset) ? zoneOffset : Objects.requireNonNull(list.get(0), "offset");
        }
        return new ZonedDateTime(localDateTime, zoneOffset2, zoneId);
    }

    public static ZonedDateTime ofInstant(Instant instant, ZoneId zoneId) {
        Objects.requireNonNull(instant, "instant");
        Objects.requireNonNull(zoneId, "zone");
        return ZonedDateTime.create(instant.getEpochSecond(), instant.getNano(), zoneId);
    }

    public static ZonedDateTime ofInstant(LocalDateTime localDateTime, ZoneOffset zoneOffset, ZoneId zoneId) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        Objects.requireNonNull(zoneOffset, "offset");
        Objects.requireNonNull(zoneId, "zone");
        if (zoneId.getRules().isValidOffset(localDateTime, zoneOffset)) {
            return new ZonedDateTime(localDateTime, zoneOffset, zoneId);
        }
        return ZonedDateTime.create(localDateTime.toEpochSecond(zoneOffset), localDateTime.getNano(), zoneId);
    }

    private static ZonedDateTime create(long l, int n, ZoneId zoneId) {
        ZoneRules zoneRules = zoneId.getRules();
        Instant instant = Instant.ofEpochSecond(l, n);
        ZoneOffset zoneOffset = zoneRules.getOffset(instant);
        LocalDateTime localDateTime = LocalDateTime.ofEpochSecond(l, n, zoneOffset);
        return new ZonedDateTime(localDateTime, zoneOffset, zoneId);
    }

    public static ZonedDateTime ofStrict(LocalDateTime localDateTime, ZoneOffset zoneOffset, ZoneId zoneId) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        Objects.requireNonNull(zoneOffset, "offset");
        Objects.requireNonNull(zoneId, "zone");
        ZoneRules zoneRules = zoneId.getRules();
        if (!zoneRules.isValidOffset(localDateTime, zoneOffset)) {
            ZoneOffsetTransition zoneOffsetTransition = zoneRules.getTransition(localDateTime);
            if (zoneOffsetTransition != null && zoneOffsetTransition.isGap()) {
                throw new DateTimeException("LocalDateTime '" + localDateTime + "' does not exist in zone '" + zoneId + "' due to a gap in the local time-line, typically caused by daylight savings");
            }
            throw new DateTimeException("ZoneOffset '" + zoneOffset + "' is not valid for LocalDateTime '" + localDateTime + "' in zone '" + zoneId + "'");
        }
        return new ZonedDateTime(localDateTime, zoneOffset, zoneId);
    }

    private static ZonedDateTime ofLenient(LocalDateTime localDateTime, ZoneOffset zoneOffset, ZoneId zoneId) {
        Objects.requireNonNull(localDateTime, "localDateTime");
        Objects.requireNonNull(zoneOffset, "offset");
        Objects.requireNonNull(zoneId, "zone");
        if (zoneId instanceof ZoneOffset && !zoneOffset.equals(zoneId)) {
            throw new IllegalArgumentException("ZoneId must match ZoneOffset");
        }
        return new ZonedDateTime(localDateTime, zoneOffset, zoneId);
    }

    public static ZonedDateTime from(TemporalAccessor temporalAccessor) {
        if (temporalAccessor instanceof ZonedDateTime) {
            return (ZonedDateTime)temporalAccessor;
        }
        try {
            ZoneId zoneId = ZoneId.from(temporalAccessor);
            if (temporalAccessor.isSupported(ChronoField.INSTANT_SECONDS)) {
                long l = temporalAccessor.getLong(ChronoField.INSTANT_SECONDS);
                int n = temporalAccessor.get(ChronoField.NANO_OF_SECOND);
                return ZonedDateTime.create(l, n, zoneId);
            }
            LocalDate localDate = LocalDate.from(temporalAccessor);
            LocalTime localTime = LocalTime.from(temporalAccessor);
            return ZonedDateTime.of(localDate, localTime, zoneId);
        }
        catch (DateTimeException dateTimeException) {
            throw new DateTimeException("Unable to obtain ZonedDateTime from TemporalAccessor: " + temporalAccessor + " of type " + temporalAccessor.getClass().getName(), dateTimeException);
        }
    }

    public static ZonedDateTime parse(CharSequence charSequence) {
        return ZonedDateTime.parse(charSequence, DateTimeFormatter.ISO_ZONED_DATE_TIME);
    }

    public static ZonedDateTime parse(CharSequence charSequence, DateTimeFormatter dateTimeFormatter) {
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        return dateTimeFormatter.parse(charSequence, ZonedDateTime::from);
    }

    private ZonedDateTime(LocalDateTime localDateTime, ZoneOffset zoneOffset, ZoneId zoneId) {
        this.dateTime = localDateTime;
        this.offset = zoneOffset;
        this.zone = zoneId;
    }

    private ZonedDateTime resolveLocal(LocalDateTime localDateTime) {
        return ZonedDateTime.ofLocal(localDateTime, this.zone, this.offset);
    }

    private ZonedDateTime resolveInstant(LocalDateTime localDateTime) {
        return ZonedDateTime.ofInstant(localDateTime, this.offset, this.zone);
    }

    private ZonedDateTime resolveOffset(ZoneOffset zoneOffset) {
        if (!zoneOffset.equals(this.offset) && this.zone.getRules().isValidOffset(this.dateTime, zoneOffset)) {
            return new ZonedDateTime(this.dateTime, zoneOffset, this.zone);
        }
        return this;
    }

    @Override
    public boolean isSupported(TemporalField temporalField) {
        return temporalField instanceof ChronoField || temporalField != null && temporalField.isSupportedBy(this);
    }

    @Override
    public boolean isSupported(TemporalUnit temporalUnit) {
        return ChronoZonedDateTime.super.isSupported(temporalUnit);
    }

    @Override
    public ValueRange range(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            if (temporalField == ChronoField.INSTANT_SECONDS || temporalField == ChronoField.OFFSET_SECONDS) {
                return temporalField.range();
            }
            return this.dateTime.range(temporalField);
        }
        return temporalField.rangeRefinedBy(this);
    }

    @Override
    public int get(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            switch ((ChronoField)temporalField) {
                case INSTANT_SECONDS: {
                    throw new UnsupportedTemporalTypeException("Invalid field 'InstantSeconds' for get() method, use getLong() instead");
                }
                case OFFSET_SECONDS: {
                    return this.getOffset().getTotalSeconds();
                }
            }
            return this.dateTime.get(temporalField);
        }
        return ChronoZonedDateTime.super.get(temporalField);
    }

    @Override
    public long getLong(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            switch ((ChronoField)temporalField) {
                case INSTANT_SECONDS: {
                    return this.toEpochSecond();
                }
                case OFFSET_SECONDS: {
                    return this.getOffset().getTotalSeconds();
                }
            }
            return this.dateTime.getLong(temporalField);
        }
        return temporalField.getFrom(this);
    }

    @Override
    public ZoneOffset getOffset() {
        return this.offset;
    }

    public ZonedDateTime withEarlierOffsetAtOverlap() {
        ZoneOffset zoneOffset;
        ZoneOffsetTransition zoneOffsetTransition = this.getZone().getRules().getTransition(this.dateTime);
        if (zoneOffsetTransition != null && zoneOffsetTransition.isOverlap() && !(zoneOffset = zoneOffsetTransition.getOffsetBefore()).equals(this.offset)) {
            return new ZonedDateTime(this.dateTime, zoneOffset, this.zone);
        }
        return this;
    }

    public ZonedDateTime withLaterOffsetAtOverlap() {
        ZoneOffset zoneOffset;
        ZoneOffsetTransition zoneOffsetTransition = this.getZone().getRules().getTransition(this.toLocalDateTime());
        if (zoneOffsetTransition != null && !(zoneOffset = zoneOffsetTransition.getOffsetAfter()).equals(this.offset)) {
            return new ZonedDateTime(this.dateTime, zoneOffset, this.zone);
        }
        return this;
    }

    @Override
    public ZoneId getZone() {
        return this.zone;
    }

    public ZonedDateTime withZoneSameLocal(ZoneId zoneId) {
        Objects.requireNonNull(zoneId, "zone");
        return this.zone.equals(zoneId) ? this : ZonedDateTime.ofLocal(this.dateTime, zoneId, this.offset);
    }

    public ZonedDateTime withZoneSameInstant(ZoneId zoneId) {
        Objects.requireNonNull(zoneId, "zone");
        return this.zone.equals(zoneId) ? this : ZonedDateTime.create(this.dateTime.toEpochSecond(this.offset), this.dateTime.getNano(), zoneId);
    }

    public ZonedDateTime withFixedOffsetZone() {
        return this.zone.equals(this.offset) ? this : new ZonedDateTime(this.dateTime, this.offset, this.offset);
    }

    public LocalDateTime toLocalDateTime() {
        return this.dateTime;
    }

    @Override
    public LocalDate toLocalDate() {
        return this.dateTime.toLocalDate();
    }

    public int getYear() {
        return this.dateTime.getYear();
    }

    public int getMonthValue() {
        return this.dateTime.getMonthValue();
    }

    public Month getMonth() {
        return this.dateTime.getMonth();
    }

    public int getDayOfMonth() {
        return this.dateTime.getDayOfMonth();
    }

    public int getDayOfYear() {
        return this.dateTime.getDayOfYear();
    }

    public DayOfWeek getDayOfWeek() {
        return this.dateTime.getDayOfWeek();
    }

    @Override
    public LocalTime toLocalTime() {
        return this.dateTime.toLocalTime();
    }

    public int getHour() {
        return this.dateTime.getHour();
    }

    public int getMinute() {
        return this.dateTime.getMinute();
    }

    public int getSecond() {
        return this.dateTime.getSecond();
    }

    public int getNano() {
        return this.dateTime.getNano();
    }

    @Override
    public ZonedDateTime with(TemporalAdjuster temporalAdjuster) {
        if (temporalAdjuster instanceof LocalDate) {
            return this.resolveLocal(LocalDateTime.of((LocalDate)temporalAdjuster, this.dateTime.toLocalTime()));
        }
        if (temporalAdjuster instanceof LocalTime) {
            return this.resolveLocal(LocalDateTime.of(this.dateTime.toLocalDate(), (LocalTime)temporalAdjuster));
        }
        if (temporalAdjuster instanceof LocalDateTime) {
            return this.resolveLocal((LocalDateTime)temporalAdjuster);
        }
        if (temporalAdjuster instanceof OffsetDateTime) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)temporalAdjuster;
            return ZonedDateTime.ofLocal(offsetDateTime.toLocalDateTime(), this.zone, offsetDateTime.getOffset());
        }
        if (temporalAdjuster instanceof Instant) {
            Instant instant = (Instant)temporalAdjuster;
            return ZonedDateTime.create(instant.getEpochSecond(), instant.getNano(), this.zone);
        }
        if (temporalAdjuster instanceof ZoneOffset) {
            return this.resolveOffset((ZoneOffset)temporalAdjuster);
        }
        return (ZonedDateTime)temporalAdjuster.adjustInto(this);
    }

    @Override
    public ZonedDateTime with(TemporalField temporalField, long l) {
        if (temporalField instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)temporalField;
            switch (chronoField) {
                case INSTANT_SECONDS: {
                    return ZonedDateTime.create(l, this.getNano(), this.zone);
                }
                case OFFSET_SECONDS: {
                    ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(chronoField.checkValidIntValue(l));
                    return this.resolveOffset(zoneOffset);
                }
            }
            return this.resolveLocal(this.dateTime.with(temporalField, l));
        }
        return temporalField.adjustInto(this, l);
    }

    public ZonedDateTime withYear(int n) {
        return this.resolveLocal(this.dateTime.withYear(n));
    }

    public ZonedDateTime withMonth(int n) {
        return this.resolveLocal(this.dateTime.withMonth(n));
    }

    public ZonedDateTime withDayOfMonth(int n) {
        return this.resolveLocal(this.dateTime.withDayOfMonth(n));
    }

    public ZonedDateTime withDayOfYear(int n) {
        return this.resolveLocal(this.dateTime.withDayOfYear(n));
    }

    public ZonedDateTime withHour(int n) {
        return this.resolveLocal(this.dateTime.withHour(n));
    }

    public ZonedDateTime withMinute(int n) {
        return this.resolveLocal(this.dateTime.withMinute(n));
    }

    public ZonedDateTime withSecond(int n) {
        return this.resolveLocal(this.dateTime.withSecond(n));
    }

    public ZonedDateTime withNano(int n) {
        return this.resolveLocal(this.dateTime.withNano(n));
    }

    public ZonedDateTime truncatedTo(TemporalUnit temporalUnit) {
        return this.resolveLocal(this.dateTime.truncatedTo(temporalUnit));
    }

    @Override
    public ZonedDateTime plus(TemporalAmount temporalAmount) {
        if (temporalAmount instanceof Period) {
            Period period = (Period)temporalAmount;
            return this.resolveLocal(this.dateTime.plus(period));
        }
        Objects.requireNonNull(temporalAmount, "amountToAdd");
        return (ZonedDateTime)temporalAmount.addTo(this);
    }

    @Override
    public ZonedDateTime plus(long l, TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            if (temporalUnit.isDateBased()) {
                return this.resolveLocal(this.dateTime.plus(l, temporalUnit));
            }
            return this.resolveInstant(this.dateTime.plus(l, temporalUnit));
        }
        return temporalUnit.addTo(this, l);
    }

    public ZonedDateTime plusYears(long l) {
        return this.resolveLocal(this.dateTime.plusYears(l));
    }

    public ZonedDateTime plusMonths(long l) {
        return this.resolveLocal(this.dateTime.plusMonths(l));
    }

    public ZonedDateTime plusWeeks(long l) {
        return this.resolveLocal(this.dateTime.plusWeeks(l));
    }

    public ZonedDateTime plusDays(long l) {
        return this.resolveLocal(this.dateTime.plusDays(l));
    }

    public ZonedDateTime plusHours(long l) {
        return this.resolveInstant(this.dateTime.plusHours(l));
    }

    public ZonedDateTime plusMinutes(long l) {
        return this.resolveInstant(this.dateTime.plusMinutes(l));
    }

    public ZonedDateTime plusSeconds(long l) {
        return this.resolveInstant(this.dateTime.plusSeconds(l));
    }

    public ZonedDateTime plusNanos(long l) {
        return this.resolveInstant(this.dateTime.plusNanos(l));
    }

    @Override
    public ZonedDateTime minus(TemporalAmount temporalAmount) {
        if (temporalAmount instanceof Period) {
            Period period = (Period)temporalAmount;
            return this.resolveLocal(this.dateTime.minus(period));
        }
        Objects.requireNonNull(temporalAmount, "amountToSubtract");
        return (ZonedDateTime)temporalAmount.subtractFrom(this);
    }

    @Override
    public ZonedDateTime minus(long l, TemporalUnit temporalUnit) {
        return l == Long.MIN_VALUE ? this.plus(Long.MAX_VALUE, temporalUnit).plus(1L, temporalUnit) : this.plus(-l, temporalUnit);
    }

    public ZonedDateTime minusYears(long l) {
        return l == Long.MIN_VALUE ? this.plusYears(Long.MAX_VALUE).plusYears(1L) : this.plusYears(-l);
    }

    public ZonedDateTime minusMonths(long l) {
        return l == Long.MIN_VALUE ? this.plusMonths(Long.MAX_VALUE).plusMonths(1L) : this.plusMonths(-l);
    }

    public ZonedDateTime minusWeeks(long l) {
        return l == Long.MIN_VALUE ? this.plusWeeks(Long.MAX_VALUE).plusWeeks(1L) : this.plusWeeks(-l);
    }

    public ZonedDateTime minusDays(long l) {
        return l == Long.MIN_VALUE ? this.plusDays(Long.MAX_VALUE).plusDays(1L) : this.plusDays(-l);
    }

    public ZonedDateTime minusHours(long l) {
        return l == Long.MIN_VALUE ? this.plusHours(Long.MAX_VALUE).plusHours(1L) : this.plusHours(-l);
    }

    public ZonedDateTime minusMinutes(long l) {
        return l == Long.MIN_VALUE ? this.plusMinutes(Long.MAX_VALUE).plusMinutes(1L) : this.plusMinutes(-l);
    }

    public ZonedDateTime minusSeconds(long l) {
        return l == Long.MIN_VALUE ? this.plusSeconds(Long.MAX_VALUE).plusSeconds(1L) : this.plusSeconds(-l);
    }

    public ZonedDateTime minusNanos(long l) {
        return l == Long.MIN_VALUE ? this.plusNanos(Long.MAX_VALUE).plusNanos(1L) : this.plusNanos(-l);
    }

    @Override
    public <R> R query(TemporalQuery<R> temporalQuery) {
        if (temporalQuery == TemporalQueries.localDate()) {
            return (R)this.toLocalDate();
        }
        return ChronoZonedDateTime.super.query(temporalQuery);
    }

    @Override
    public long until(Temporal temporal, TemporalUnit temporalUnit) {
        ZonedDateTime zonedDateTime = ZonedDateTime.from(temporal);
        if (temporalUnit instanceof ChronoUnit) {
            zonedDateTime = zonedDateTime.withZoneSameInstant(this.zone);
            if (temporalUnit.isDateBased()) {
                return this.dateTime.until(zonedDateTime.dateTime, temporalUnit);
            }
            return this.toOffsetDateTime().until(zonedDateTime.toOffsetDateTime(), temporalUnit);
        }
        return temporalUnit.between(this, zonedDateTime);
    }

    @Override
    public String format(DateTimeFormatter dateTimeFormatter) {
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        return dateTimeFormatter.format(this);
    }

    public OffsetDateTime toOffsetDateTime() {
        return OffsetDateTime.of(this.dateTime, this.offset);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)object;
            return this.dateTime.equals(zonedDateTime.dateTime) && this.offset.equals(zonedDateTime.offset) && this.zone.equals(zonedDateTime.zone);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.dateTime.hashCode() ^ this.offset.hashCode() ^ Integer.rotateLeft(this.zone.hashCode(), 3);
    }

    @Override
    public String toString() {
        String string = this.dateTime.toString() + this.offset.toString();
        if (this.offset != this.zone) {
            string = string + '[' + this.zone.toString() + ']';
        }
        return string;
    }

    private Object writeReplace() {
        return new Ser(6, this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    void writeExternal(DataOutput dataOutput) throws IOException {
        this.dateTime.writeExternal(dataOutput);
        this.offset.writeExternal(dataOutput);
        this.zone.write(dataOutput);
    }

    static ZonedDateTime readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        LocalDateTime localDateTime = LocalDateTime.readExternal(objectInput);
        ZoneOffset zoneOffset = ZoneOffset.readExternal(objectInput);
        ZoneId zoneId = (ZoneId)Ser.read(objectInput);
        return ZonedDateTime.ofLenient(localDateTime, zoneOffset, zoneId);
    }
}

