/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.AWTEvent;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.TrayIcon;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.WritableRaster;
import java.awt.peer.TrayIconPeer;
import sun.awt.SunToolkit;
import sun.awt.image.IntegerComponentRaster;
import sun.awt.windows.WObjectPeer;
import sun.awt.windows.WPopupMenuPeer;
import sun.awt.windows.WToolkit;

final class WTrayIconPeer
extends WObjectPeer
implements TrayIconPeer {
    static final int TRAY_ICON_WIDTH = 16;
    static final int TRAY_ICON_HEIGHT = 16;
    static final int TRAY_ICON_MASK_SIZE = 32;
    IconObserver observer = new IconObserver();
    boolean firstUpdate = true;
    Frame popupParent = new Frame("PopupMessageWindow");
    PopupMenu popup;

    @Override
    protected void disposeImpl() {
        if (this.popupParent != null) {
            this.popupParent.dispose();
        }
        this.popupParent.dispose();
        this._dispose();
        WToolkit.targetDisposedPeer(this.target, this);
    }

    WTrayIconPeer(TrayIcon trayIcon) {
        this.target = trayIcon;
        this.popupParent.addNotify();
        this.create();
        this.updateImage();
    }

    @Override
    public void updateImage() {
        Image image = ((TrayIcon)this.target).getImage();
        if (image != null) {
            this.updateNativeImage(image);
        }
    }

    @Override
    public native void setToolTip(String var1);

    @Override
    public synchronized void showPopupMenu(final int n, final int n2) {
        if (this.isDisposed()) {
            return;
        }
        SunToolkit.executeOnEventHandlerThread(this.target, new Runnable(){

            @Override
            public void run() {
                PopupMenu popupMenu = ((TrayIcon)WTrayIconPeer.this.target).getPopupMenu();
                if (WTrayIconPeer.this.popup != popupMenu) {
                    if (WTrayIconPeer.this.popup != null) {
                        WTrayIconPeer.this.popupParent.remove(WTrayIconPeer.this.popup);
                    }
                    if (popupMenu != null) {
                        WTrayIconPeer.this.popupParent.add(popupMenu);
                    }
                    WTrayIconPeer.this.popup = popupMenu;
                }
                if (WTrayIconPeer.this.popup != null) {
                    ((WPopupMenuPeer)WTrayIconPeer.this.popup.getPeer()).show(WTrayIconPeer.this.popupParent, new Point(n, n2));
                }
            }
        });
    }

    @Override
    public void displayMessage(String string, String string2, String string3) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        this._displayMessage(string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void updateNativeImage(Image image) {
        if (this.isDisposed()) {
            return;
        }
        boolean bl = ((TrayIcon)this.target).isImageAutoSize();
        BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (graphics2D != null) {
            try {
                graphics2D.setPaintMode();
                graphics2D.drawImage(image, 0, 0, bl ? 16 : image.getWidth(this.observer), bl ? 16 : image.getHeight(this.observer), this.observer);
                this.createNativeImage(bufferedImage);
                this.updateNativeIcon(!this.firstUpdate);
                if (this.firstUpdate) {
                    this.firstUpdate = false;
                }
            }
            finally {
                graphics2D.dispose();
            }
        }
    }

    void createNativeImage(BufferedImage bufferedImage) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        byte[] byArray = new byte[32];
        int[] nArray = ((DataBufferInt)writableRaster.getDataBuffer()).getData();
        int n = nArray.length;
        int n2 = writableRaster.getWidth();
        for (int i = 0; i < n; ++i) {
            int n3 = i / 8;
            int n4 = 1 << 7 - i % 8;
            if ((nArray[i] & 0xFF000000) != 0 || n3 >= byArray.length) continue;
            int n5 = n3;
            byArray[n5] = (byte)(byArray[n5] | n4);
        }
        if (writableRaster instanceof IntegerComponentRaster) {
            n2 = ((IntegerComponentRaster)writableRaster).getScanlineStride();
        }
        this.setNativeIcon(((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData(), byArray, n2, writableRaster.getWidth(), writableRaster.getHeight());
    }

    void postEvent(AWTEvent aWTEvent) {
        WToolkit.postEvent(WToolkit.targetToAppContext(this.target), aWTEvent);
    }

    native void create();

    synchronized native void _dispose();

    native void updateNativeIcon(boolean var1);

    native void setNativeIcon(int[] var1, byte[] var2, int var3, int var4, int var5);

    native void _displayMessage(String var1, String var2, String var3);

    class IconObserver
    implements ImageObserver {
        IconObserver() {
        }

        @Override
        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            if (image != ((TrayIcon)WTrayIconPeer.this.target).getImage() || WTrayIconPeer.this.isDisposed()) {
                return false;
            }
            if ((n & 0x33) != 0) {
                WTrayIconPeer.this.updateNativeImage(image);
            }
            return (n & 0x20) == 0;
        }
    }
}

