/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.controlpanel;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.controlpanel.CachePane;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.ImageResources;
import net.sourceforge.jnlp.util.ScreenFinder;
import net.sourceforge.swing.SwingUtils;

public class CacheViewer
extends JDialog {
    private boolean initialized = false;
    private static final String dialogTitle = Translator.R("CVCPDialogTitle");
    private final DeploymentConfiguration config;
    CachePane topPanel;

    public CacheViewer(DeploymentConfiguration config) {
        super((Frame)null, dialogTitle, true);
        this.setName("CacheViewer");
        SwingUtils.info(this);
        this.config = config;
        if (config == null) {
            throw new IllegalArgumentException("config: " + config);
        }
        this.setIconImages(ImageResources.INSTANCE.getApplicationImages());
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        this.topPanel = new CachePane(this, this.config);
        contentPane.add((Component)this.topPanel, c);
        this.pack();
        this.topPanel.invokeLaterPopulateTable();
        WindowAdapter adapter = new WindowAdapter(){
            private boolean gotFocus = false;

            @Override
            public void windowGainedFocus(WindowEvent we) {
                if (!this.gotFocus) {
                    CacheViewer.this.topPanel.focusOnDefaultButton();
                    this.gotFocus = true;
                }
            }
        };
        this.addWindowFocusListener(adapter);
        final CacheViewer cacheViewer = this;
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27 && keyEvent.getID() == 401) {
                    keyEvent.consume();
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
                    Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(cacheViewer, 201));
                    return true;
                }
                return false;
            }
        });
        this.initialized = true;
    }

    public static void showCacheDialog(DeploymentConfiguration config) {
        CacheViewer psd = new CacheViewer(config);
        psd.setResizable(true);
        psd.centerDialog();
        psd.setVisible(true);
        psd.dispose();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private void centerDialog() {
        ScreenFinder.centerWindowsToCurrentScreen(this);
    }
}

