/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.InputDevice;
import com.sun.glass.ui.monocle.InputDeviceRegistry;
import com.sun.glass.ui.monocle.MouseInput;
import com.sun.glass.ui.monocle.MouseState;
import com.sun.glass.ui.monocle.NativePlatform;
import com.sun.glass.ui.monocle.NativePlatformFactory;
import com.sun.glass.ui.monocle.RunnableProcessor;
import com.sun.glass.ui.monocle.X;
import com.sun.glass.ui.monocle.X11Screen;

class X11InputDeviceRegistry
extends InputDeviceRegistry {
    private MouseState state;
    private static X xLib = X.getX();

    X11InputDeviceRegistry() {
        InputDevice inputDevice = new InputDevice(){

            @Override
            public boolean isTouch() {
                return false;
            }

            @Override
            public boolean isMultiTouch() {
                return false;
            }

            @Override
            public boolean isRelative() {
                return true;
            }

            @Override
            public boolean is5Way() {
                return false;
            }

            @Override
            public boolean isFullKeyboard() {
                return false;
            }
        };
        Thread thread = new Thread(() -> {
            NativePlatform nativePlatform = NativePlatformFactory.getNativePlatform();
            X11Screen x11Screen = (X11Screen)nativePlatform.getScreen();
            long l = x11Screen.getDisplay();
            long l2 = x11Screen.getNativeHandle();
            RunnableProcessor runnableProcessor = nativePlatform.getRunnableProcessor();
            runnableProcessor.invokeLater(() -> this.devices.add(inputDevice));
            this.state = new MouseState();
            X.XEvent xEvent = new X.XEvent();
            while (true) {
                xLib.XNextEvent(l, xEvent.p);
                if (X.XEvent.getWindow(xEvent.p) != l2) continue;
                this.processXEvent(xEvent, runnableProcessor);
            }
        });
        thread.setName("X11 Input");
        thread.setDaemon(true);
        thread.start();
    }

    private void processXEvent(X.XEvent xEvent, RunnableProcessor runnableProcessor) {
        switch (X.XEvent.getType(xEvent.p)) {
            case 4: {
                X.XButtonEvent xButtonEvent = new X.XButtonEvent(xEvent);
                int n = X.XButtonEvent.getButton(xButtonEvent.p);
                runnableProcessor.invokeLater(new ButtonPressProcessor(n));
                break;
            }
            case 5: {
                X.XButtonEvent xButtonEvent = new X.XButtonEvent(xEvent);
                int n = X.XButtonEvent.getButton(xButtonEvent.p);
                runnableProcessor.invokeLater(new ButtonReleaseProcessor(n));
                break;
            }
            case 6: {
                X.XMotionEvent xMotionEvent = new X.XMotionEvent(xEvent);
                int n = X.XMotionEvent.getX(xMotionEvent.p);
                int n2 = X.XMotionEvent.getY(xMotionEvent.p);
                runnableProcessor.invokeLater(new MotionProcessor(n, n2));
                break;
            }
        }
    }

    private static int buttonToGlassButton(int n) {
        switch (n) {
            case 1: {
                return 212;
            }
            case 2: {
                return 214;
            }
            case 3: {
                return 213;
            }
        }
        return 211;
    }

    private class MotionProcessor
    implements Runnable {
        private int x;
        private int y;

        MotionProcessor(int n, int n2) {
            this.x = n;
            this.y = n2;
        }

        @Override
        public void run() {
            MouseInput.getInstance().getState(X11InputDeviceRegistry.this.state);
            X11InputDeviceRegistry.this.state.setX(this.x);
            X11InputDeviceRegistry.this.state.setY(this.y);
            MouseInput.getInstance().setState(X11InputDeviceRegistry.this.state, false);
        }
    }

    private class ButtonReleaseProcessor
    implements Runnable {
        private int button;

        ButtonReleaseProcessor(int n) {
            this.button = n;
        }

        @Override
        public void run() {
            MouseInput.getInstance().getState(X11InputDeviceRegistry.this.state);
            int n = X11InputDeviceRegistry.buttonToGlassButton(this.button);
            if (n != 211) {
                X11InputDeviceRegistry.this.state.releaseButton(n);
            }
            MouseInput.getInstance().setState(X11InputDeviceRegistry.this.state, false);
        }
    }

    private class ButtonPressProcessor
    implements Runnable {
        private int button;

        ButtonPressProcessor(int n) {
            this.button = n;
        }

        @Override
        public void run() {
            MouseInput.getInstance().getState(X11InputDeviceRegistry.this.state);
            int n = X11InputDeviceRegistry.buttonToGlassButton(this.button);
            if (n != 211) {
                X11InputDeviceRegistry.this.state.pressButton(n);
            }
            MouseInput.getInstance().setState(X11InputDeviceRegistry.this.state, false);
        }
    }
}

