#!/bin/bash
#日志函数
log_file="/var/log/installtoolunzip.log"
product_name="OceanStor|Distributed-Storage"
pkg=`ls /opt/fusionstorage/repository/deploymanager_pkg/DSwareSoft/ | grep -E $product_name | grep -v  'OBS' | grep tar.gz | awk -F '.tar.gz' '{print $1}'`
pkg_num=`ls -l /opt/fusionstorage/repository/deploymanager_pkg/DSwareSoft/ | grep -E $product_name | grep -v  'OBS' | grep tar.gz | awk -F '.tar.gz' '{print $1}' | grep "^-" | wc -l`
if [ $pkg_num -gt 1 ];then
  echo "ERROR" "the basic packages are more than one" > ${log_file}
  exit 1
fi
if [ $? -ne 0 ]; then
    echo "ERROR" "file unzip first step failed" > ${log_file}
	exit 1
fi
tar -xzf /opt/fusionstorage/repository/deploymanager_pkg/DSwareSoft/$pkg.tar.gz -C /opt/fusionstorage/repository/deploymanager_pkg/DSwareSoft/ 2>${log_file}
if [ $? -ne 0 ]; then
    echo "ERROR" "file unzip second step failed" >> ${log_file}
	exit 1
fi
mv /opt/fusionstorage/repository/deploymanager_pkg/DSwareSoft/$pkg/deploymanager/* /opt/fusionstorage/repository/deploymanager_pkg/DSwareSoft
if [ $? -ne 0 ]; then
    echo "ERROR" "file unzip third step failed" > ${log_file}
	exit 1
fi
echo "success" "file unzip success" > ${log_file}
exit 0