/****************************************************************************

  Copyright (C), 2011-2022, Huawei Tech. Co., Ltd.

 ******************************************************************************
  File Name     : hrn0_u_api.h
  Description   :
  History       :
  1.Date        : 2018-7-4
  Author        : zhanggang
  Modification  : Created file

******************************************************************************/
#ifndef __HRN0_U_API_H__
#define __HRN0_U_API_H__

struct roce_bond_port_info {
    int original_port_num;
    char original_port[8];
    int rsvd1;

    int alive_port_num;
    char alive_port[8];
    int rsvd2;
};

/*****************************************************************************
     : roce_query_qp_tx_port
   : ѯָQPķ͵Ķ˿
   : struct ibv_qp *qp
             int *tx_port
   :
   ֵ  : ɹ: 0
             ʧ: ֵ
 ú  :
   :
*****************************************************************************/
int roce_query_qp_tx_port(struct ibv_qp *qp, int *tx_port);

/*****************************************************************************
     : roce_set_qp_tx_port
   : ָQPĳ˿
   : struct ibv_qp *qp
             int tx_port
   : 
   ֵ  : ɹ: 0
             ʧ: ֵ
 ú  :
   :
*****************************************************************************/
int roce_set_qp_tx_port(struct ibv_qp *qp, int tx_port);

/*****************************************************************************
     : roce_query_qp_rx_port
   : ѯָQPķձ
   : struct ibv_qp *qp
             int *rx_port
   : 
   ֵ  : ɹ: 0
             ʧ: ֵ
 ú  :
   :
*****************************************************************************/
int roce_query_qp_rx_port(struct ibv_qp *qp, int *rx_port);

/*****************************************************************************
     : roce_query_bond_port_info
   : ѯbonding豸ĻԾ˿Ϣ
   : struct ibv_context *context
             struct roce_bond_port_info *bond_port_info
   :
   ֵ  : ɹ: 0
             ʧ: ֵ
 ú  :
   :
*****************************************************************************/
int roce_query_bond_port_info(struct ibv_context *context, struct roce_bond_port_info *bond_port_info);

/*****************************************************************************
     : roce_set_qp_udp_src_port
   : ָQPudpԴ˿
   : struct ibv_qp *qp
             int udp_src_port(8 bitЧ)
   : 
   ֵ  : ɹ: 0
             ʧ: ֵ
 ú  :
   :
*****************************************************************************/
int roce_set_qp_udp_src_port(struct ibv_qp *qp, int udp_src_port);

/*****************************************************************************
     : roce_query_qp_udp_src_port
   : ѯָQPǰ͵udpԴ˿
   : struct ibv_qp *qp
             int *udp_src_port
   : 
   ֵ  : ɹ: 0
             ʧ: ֵ
 ú  :
   :
*****************************************************************************/
int roce_query_qp_udp_src_port(struct ibv_qp *qp, int *udp_src_port);

/*****************************************************************************
     : roce_set_qp_wwr
   : enable/disable QPwrite_with_read
   : struct ibv_qp *qp
             int wwr(1 bitЧ); 0:disable 1: enable
   : 
   ֵ  : ɹ: 0
             ʧ: ֵ
 ú  :
   :

*****************************************************************************/
int roce_set_qp_wwr(struct ibv_qp *qp, int wwr);

#ifdef ROCE_DRC_EN
/*****************************************************************************
     : roce_set_exp_dct
   : 쳣dctŽи»ɾ
   : struct ibv_qp *qp
             int exp_dct_index(5 bitЧ)
             int flag(1 bitЧ); 0: 1: ɾ
   : 
   ֵ  : ɹ: 0
             ʧ: ֵ

*****************************************************************************/
int roce_set_exp_dct(struct ibv_qp *qp, int exp_dct_index, int flag);
#endif

#endif  // __HRN0_U_API_H__

