/*
 * Copyright (c) 2004, 2005 Topspin Communications.  All rights reserved.
 * Copyright (c) 2004, 2011-2012 Intel Corporation.  All rights reserved.
 * Copyright (c) 2005, 2006, 2007 Cisco Systems, Inc.  All rights reserved.
 * Copyright (c) 2005 PathScale, Inc.  All rights reserved.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * COPYING in the main directory of this source tree, or the
 * OpenIB.org BSD license below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#ifndef INFINIBAND_VERBS_EXP_H
#define INFINIBAND_VERBS_EXP_H

#include <infiniband/verbs.h>
#include <stdio.h>
#include <stdlib.h>

#if __GNUC__ >= 3
#  define __attribute_const __attribute__((const))
#else
#  define __attribute_const
#endif

#ifdef __cplusplus
#if __cplusplus
extern "C"{
#endif
#endif /* __cplusplus */

#define IBV_EXP_RET_ON_INVALID_COMP_MASK(val, valid_mask, ret)						\
	if ((val) > (valid_mask)) {									\
		fprintf(stderr, "%s: invalid comp_mask !!! (comp_mask = 0x%x valid_mask = 0x%x)\n",	\
			__FUNCTION__, val, valid_mask);							\
		errno = EINVAL;										\
		return ret;										\
	}

#define IBV_EXP_RET_NULL_ON_INVALID_COMP_MASK(val, valid_mask)	\
		IBV_EXP_RET_ON_INVALID_COMP_MASK(val, valid_mask, NULL)

#define IBV_EXP_RET_EINVAL_ON_INVALID_COMP_MASK(val, valid_mask)	\
		IBV_EXP_RET_ON_INVALID_COMP_MASK(val, valid_mask, EINVAL)

#define IBV_EXP_RET_ZERO_ON_INVALID_COMP_MASK(val, valid_mask)	\
		IBV_EXP_RET_ON_INVALID_COMP_MASK(val, valid_mask, 0)


enum ibv_exp_roce_gid_type {
	IBV_EXP_IB_ROCE_V1_GID_TYPE,
	IBV_EXP_ROCE_V2_GID_TYPE,
	IBV_EXP_ROCE_V1_5_GID_TYPE,
};

enum ibv_exp_query_gid_attr {
	IBV_EXP_QUERY_GID_ATTR_TYPE = (1 << 0),
	IBV_EXP_QUERY_GID_ATTR_GID	= (1 << 1),
	IBV_EXP_QUERY_GID_ATTR_RESERVED	= (1 << 2),
};

struct ibv_exp_gid_attr {
	uint32_t			comp_mask;
	enum ibv_exp_roce_gid_type	type;
	union ibv_gid			gid;
};
 
/*
 * ibv_exp_query_gid_attr - query a GID attributes
 * @context: ib context
 * @port_num: port number
 * @index: gid index in the gids table
 * @attr: the gid attributes of index in the gids table
 * Return value
 * ibv_exp_query_gid_attr return 0 on success, or the value of errno on failure.
 */
static inline int ibv_exp_query_gid_attr(struct ibv_context *context,
					 uint8_t port_num,
					 unsigned int index,
					 struct ibv_exp_gid_attr *attr)
{
    struct verbs_context *vctx;
    vctx = verbs_get_ctx(context);
	IBV_EXP_RET_EINVAL_ON_INVALID_COMP_MASK(attr->comp_mask,
						IBV_EXP_QUERY_GID_ATTR_RESERVED - 1);
	return vctx->exp_query_gid_attr(context, port_num, index, (void *)attr);
}

#ifdef __cplusplus
#if __cplusplus
}
#endif
#endif /* __cplusplus */

#  undef __attribute_const


#endif /* INFINIBAND_VERBS_EXP_H */
