#ifndef LINUX_26_COMPAT_H
#define LINUX_26_COMPAT_H

#include <generated/autoconf.h>

/* Include the autogenerated header file */
#include "../../compat/config.h"

#define LINUX_BACKPORT(__sym) backport_ ##__sym

#ifdef CONFIG_COMPAT_RDMA

#include <linux/version.h>
#include <linux/kconfig.h>
#include <linux/if.h>
#include <linux/compat_autoconf.h>
#include <linux/init.h>
#include <linux/module.h>
#include <linux/uidgid.h>

/*
 * The define overwriting module_init is based on the original module_init
 * which looks like this:
 * #define module_init(initfn)					\
 *	static inline initcall_t __inittest(void)		\
 *	{ return initfn; }					\
 *	int init_module(void) __attribute__((alias(#initfn)));
 *
 * To the call to the initfn we added the symbol dependency on compat
 * to make sure that compat.ko gets loaded for any compat modules.
 */
void backport_dependency_symbol(void);

#undef module_init
#define module_init(initfn)						\
	static int __init __init_backport(void)				\
	{								\
		backport_dependency_symbol();				\
		return initfn();					\
	}								\
	int init_module(void) __attribute__((alias("__init_backport")));

/*
 * Each compat file represents compatibility code for new kernel
 * code introduced for *that* kernel revision.
 */

#include <linux/compat-3.11.h>
#include <linux/compat-3.12.h>
#include <linux/compat-3.13.h>
#include <linux/compat-3.14.h>
#include <linux/compat-3.15.h>
#include <linux/compat-3.16.h>
#include <linux/compat-3.17.h>
#include <linux/compat-3.19.h>
#include <linux/compat-4.0.h>
#include <linux/compat-4.1.h>
#include <linux/compat-4.5.h>
#include <linux/compat-4.9.h>
#include <linux/compat-4.11.h>
#include <linux/compat-4.16.h>
#include <linux/compat-4.17.h>

#endif /* CONFIG_COMPAT_RDMA */
#endif /* LINUX_26_COMPAT_H */
