#ifndef COMPAT_LIST_H
#define COMPAT_LIST_H

#include_next <linux/list.h>

/* Include the autogenerated header file */
#include "../../compat/config.h"

#ifdef HAVE_HLIST_FOR_EACH_ENTRY_3_PARAMS
#define compat_hlist_for_each_entry_safe(pos, n, head, member)	\
	hlist_for_each_entry_safe(pos, n, head, member)

#define compat_hlist_for_each_entry(pos, head, member)		\
	hlist_for_each_entry(pos, head, member)

#define COMPAT_HL_NODE
#else
#define compat_hlist_for_each_entry_safe(pos, n, head, member)	\
	hlist_for_each_entry_safe(pos, hlnode, n, head, member)

#define compat_hlist_for_each_entry(pos, head, member)		\
	hlist_for_each_entry(pos, hlnode, head, member)		\

#define COMPAT_HL_NODE struct hlist_node *hlnode;
#endif

#ifndef list_prev_entry
#define list_prev_entry(pos, member) \
	list_entry((pos)->member.prev, typeof(*(pos)), member)
#endif

#ifndef list_next_entry
#define list_next_entry(pos, member) \
	list_entry((pos)->member.next, typeof(*(pos)), member)
#endif

#ifndef list_first_entry_or_null
#define list_first_entry_or_null(ptr, type, member) \
	(!list_empty(ptr) ? list_first_entry(ptr, type, member) : NULL)
#endif
#endif /* COMPAT_LIST_H */
