#! /bin/bash

RPM_FILE_DIR="RPMS"
DEB_FILE_DIR="DEB"
LOG_DIR="/tmp/ofed"
LOG_FILE="$LOG_DIR/install_temp.log"
if [ ! -d "$LOG_DIR" ]; then
    mkdir "$LOG_DIR"
fi

#driver install file
driver_install_file_list=(
        "compat-rdma-devel"
        "compat-rdma"
        "rdma-core-devel"
        "rdma-core"
        "libibverbs"
        "libibverbs-utils"
        "libibumad"
        "librdmacm"
        "librdmacm-utils"
        "perftest"
        )

driver_install_file_num=${#driver_install_file_list[*]}

function log()
{
    log_time=$(date +"%Y-%m-%d %H:%M:%S")
    echo "$log_time $@" | tee -a $LOG_FILE
}

function check_file_exist()
{
    #input "file_name"+*, unsupport check more than one file!
    if [ $# -ne 1 ]; then
        log "[ ERROR ] Check $# file, install will be failed!($1,$2)"
        exit 1
    fi

    file=$1
    ls $file > /dev/null
    if [ $? != 0 ]; then
        log "[ ERROR ] Can not find $file! Exit install!"
        exit 1
    fi

    log "[INSTALL] check $file ok"
}

function check_dependent_package()
{
    if [ -n "$(ls /etc/ | egrep -i 'suse')" ] && [ -z "$(ls /etc/ | egrep -i 'euler')" ]; then
        ls /sbin/insserv > /dev/null 2>&1
            if [ $? == 0 ]; then
                log "[INSTALL] check dependent package before install ok"
            else 
                log "[ERROR] check dependent package before install fail, require insserv-compat! Exit install"
                exit 1
            fi
    else
        log "[INSTALL] check before install ok"
    fi
}

function main()
{
    current_dir=$(cd "$(dirname "$0")";pwd)
	for ((i=0;i<$driver_install_file_num;i++)); do
	    if [ -e /etc/debian_version ] && [ -e $current_dir/DEB ]; then
		    check_file_exist "$DEB_FILE_DIR/${driver_install_file_list[$i]}*deb"
		else
		    check_file_exist "$RPM_FILE_DIR/${kernel_driver_install_file_list[$i]}*rpm"
		fi
	done 
    while true; do
    #stty -icanon min 0 time 100
        stty icanon
        echo -e "This program will install the OFED package on your machine."
        echo -e "Note that all other Mellanox, OEM, OFED, RDMA or Distribution IB packages will be removed."
        echo -e "Those packages are removed due to conflicts with OFED, do not reinstall them.\n"
        echo -n "Do you want to continue?[y/N]:"
        read Arg
        case $Arg in
            Y|y|YES|yes|"")
            break;;
            N|n|NO|no)
            exit;;
        esac
    done
    bash ./force_uninstall_other_ofed.sh
    check_dependent_package
}

#excute main function
main
