#!/bin/bash
argc=$#

cd `dirname $0`
DEB_FILE_DIR="DEB"
RPM_FILE_DIR="RPMS"
LOG_DIR="/tmp/ofed"
OFED_VER_FILE="ofed_ver"
LOG_FILE="$LOG_DIR/install_temp.log"
if [ ! -d "$LOG_DIR" ]; then
    mkdir "$LOG_DIR"
fi

#driver install file
driver_install_file_list=(
        "compat-rdma-devel"
        "compat-rdma"
        "rdma-core-devel"
        "rdma-core"
        "libibverbs"
        "libibverbs-utils"
        "libibumad"
        "librdmacm"
        "librdmacm-utils"
        "perftest"
        )

driver_install_file_num=${#driver_install_file_list[*]}

function log()
{
    log_time=$(date +"%Y-%m-%d %H:%M:%S")
    echo "$log_time $@" | tee -a $LOG_FILE
}

function install_package()
{
    file_name=$1
    package_new=$2
    
    if [ -e /etc/debian_version ] && [ -e $current_dir/DEB ]; then
        dpkg -i --force-all $package_new
    else
        rpm -ivh $package_new --nodeps --force
    fi
    if [ $? != 0 ]; then
        log "[ ERROR ] install $package_new fail! Exit install!"
    fi
    
    log "[INSTALL] install package $1 ok"
}

function install_driver()
{
    #install driver
    for ((i=0;i<$driver_install_file_num;i++)); do
        if [ -e /etc/debian_version ] && [ -e $current_dir/DEB ]; then
            install_package "${driver_install_file_list[$i]}" "$DEB_FILE_DIR/${driver_install_file_list[$i]}*deb"
        else
            install_package "${driver_install_file_list[$i]}" "$RPM_FILE_DIR/${driver_install_file_list[$i]}*rpm"
        fi
    done
    
    /sbin/ldconfig > /dev/null 2>&1
    log "[INSTALL] install driver   -----------------pass"
}

function install_ofed_ver()
{
    dos2unix $OFED_VER_FILE
    cp -rf $OFED_VER_FILE /usr/bin/
    chmod +x /usr/bin/$OFED_VER_FILE
}

function main()
{
    log ""
    log "[INSTALL] install OFED software start."
    current_dir=$(cd "$(dirname "$0")";pwd)
    source $current_dir/check_before_install.sh
    if [ $? != 0 ]; then
        log "[ERROR] install OFED software failed."
    else
        sleep 3
        install_driver
        rpm -qa | grep rdma > /dev/null || dpkg -l | grep rdma > /dev/null
        if [ $? = 0 ]; then   
            install_ofed_ver
            log "[INSTALL] install OFED software ok."
            echo -e "To load the new driver, run:\n/etc/init.d/openibd restart"
        else
            log "[ERROR] install OFED software failed."
        fi
    fi
}

#excute main function
main
