#!/bin/bash
argc=$#

cd `dirname $0`
OFED_VER_FILE="ofed_ver"
RPM_FILE_DIR="RPMS"
LOG_DIR="/tmp/ofed"
LOG_FILE="$LOG_DIR/uninstall_temp.log"
if [ ! -d "$LOG_DIR" ]; then
    mkdir "$LOG_DIR"
fi

#driver install file
driver_install_file_list=(
        "compat-rdma-devel"
        "compat-rdma"
        "perftest"
        "librdmacm-utils"
        "librdmacm"
        "libibumad"
        "libibverbs-utils"
        "libibverbs"
        "rdma-core"
        "rdma-core-devel"
        )

driver_install_file_num=${#driver_install_file_list[*]}

function log()
{
    log_time=$(date +"%Y-%m-%d %H:%M:%S")
    echo "$log_time $@" | tee -a $LOG_FILE
}

function is_installed
{
    if [ -e /etc/debian_version ]; then
         dpkg -l $1 >/dev/null 2>&1 
    else
         rpm -q $1 > /dev/null 2>&1    
    fi
    return $?
}

function force_uninstall
{
    if [ -e /etc/debian_version ]; then
        dpkg -l | grep rdma > /dev/null 2>&1 || dpkg -l | grep libib > /dev/null 2>&1 || dpkg -l | grep perftest > /dev/null 2>&1
        if [ $? -eq 0 ]; then
            cmd="dpkg -P --force-all"
            for((i=0;i<$driver_install_file_num;i++)); do
                is_installed ${driver_install_file_list[$i]}
                if [ $? -eq 0 ]; then
                    cmd+=" "
                    cmd+=${driver_install_file_list[$i]}
                fi
            done
            log $cmd
            ${cmd} >> $LOG_FILE
        else
            log "[UNINSTALL] There is no ofed software to uninstall."
            exit 0
        fi
    else 
        rpm -qa | grep rdma > /dev/null 2>&1 || rpm -qa | grep libib > /dev/null 2>&1 || rpm -qa | grep perftest > /dev/null 2>&1
        if [ $? -eq 0 ]; then 
            cmd="rpm -e --allmatches --nodeps"
        
            for ((i=0;i<$driver_install_file_num;i++)); do
                is_installed ${driver_install_file_list[$i]}
                if [ $? -eq 0 ]; then
                    cmd+=" "
                    cmd+=${driver_install_file_list[$i]}
                fi
            done
            log $cmd
            ${cmd} >> $LOG_FILE 			
        else
            log "[UNINSTALL] There is no ofed software to uninstall."
            exit 0
        fi
    fi
}

function main()
{  
    log "[UNINSTALL] uninstall OFED start."
    force_uninstall
    if [ -e /usr/bin/$OFED_VER_FILE ]; then
        rm -rf /usr/bin/$OFED_VER_FILE
    fi
    log "[UNINSTALL] uninstall OFED ok."
}

#excute main function
main
