/*
 * Copyright (c) 2013-2014 Chelsio, Inc. All rights reserved.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * /drivers/net/cxgb4/sge.c+ * COPYING in the main directory of this source tree, or the
 * OpenIB.org BSD license below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

/*
 * dump of firmware files generated using:
 *     hexdump -v -e '"\t" 16/1 "0x%02x, " "\n"'
 */

static u8 t4fw_data[] = {
#  include "./t4fw.txt"
};

static u8 t5fw_data[] = {
#  include "./t5fw.txt"
};

static u8 t6fw_data[] = {
#  include "./t6fw.txt"
};

static inline int t4_local_firmware_load(const struct firmware **firmware)
{
	struct firmware *fw;

	*firmware = fw = kzalloc(sizeof(*fw), GFP_KERNEL);
	if (!fw) {
		pr_err("%s: kmalloc(struct firmware) failed\n", __func__);
		return -ENOMEM;
	}
	fw->data = t4fw_data;
	fw->size = sizeof(t4fw_data);

	return 0;
}

static inline int t5_local_firmware_load(const struct firmware **firmware)
{
	struct firmware *fw;

	*firmware = fw = kzalloc(sizeof(*fw), GFP_KERNEL);
	if (!fw) {
		pr_err("%s: kmalloc(struct firmware) failed\n", __func__);
		return -ENOMEM;
	}
	fw->data = t5fw_data;
	fw->size = sizeof(t5fw_data);

	return 0;
}

static inline int t6_local_firmware_load(const struct firmware **firmware)
{
	struct firmware *fw;

	*firmware = fw = kzalloc(sizeof(*fw), GFP_KERNEL);
	if (!fw) {
		pr_err("%s: kmalloc(struct firmware) failed\n", __func__);
		return -ENOMEM;
	}
	fw->data = t6fw_data;
	fw->size = sizeof(t6fw_data);

	return 0;
}
