#! /bin/bash

LOG_DIR="/tmp/ofed"
LOG_FILE="$LOG_DIR/install_temp.log"
if [ ! -d "$LOG_DIR" ]; then
    mkdir "$LOG_DIR"
fi

function log()
{
    log_time=$(date +"%Y-%m-%d %H:%M:%S")
    echo "$log_time $@" | tee -a $LOG_FILE
}

function uninstall_other_ofed()
{
    log "[UNINSTALL] uninstall ofa_kernel or other ofed start"
    if [ -e /etc/debian_version ] && [ -e ./DEB ]; then
        dpkg -l | grep perftest | awk '{print $2}' | xargs dpkg -P --force-all 2> /dev/null
        dpkg -l | grep rdma | awk '{print $2}' | xargs dpkg -P --force-all 2> /dev/null
        dpkg -l | grep libib | awk '{print $2}' | xargs dpkg -P --force-all 2> /dev/null
        dpkg -l | grep ofed | awk '{print $2}' | xargs dpkg -P --force-all 2> /dev/null
        dpkg -l | grep ofa_kernel | awk '{print $2}' | xargs dpkg -P --force-all 2> /dev/null
    else
        rpm -qa | grep perftest | xargs rpm -e --allmatches --nodeps 2> /dev/null
        rpm -qa | grep rdma | xargs rpm -e --allmatches --nodeps 2> /dev/null
        rpm -qa | grep libib | xargs rpm -e --allmatches --nodeps 2> /dev/null
        rpm -qa | grep ofed | xargs rpm -e --allmatches --nodeps 2> /dev/null
        rpm -qa | grep ofe_kernel | xargs rpm -e --allmatches --nodeps 2> /dev/null
    fi
    log "[UNINSTALL] uninstall ofa_kernel or other ofed ok!"
}

function main()
{
    uninstall_other_ofed
}

#excute main function
main
