/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.io.PrintStream;
import java.security.SecureRandom;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.Utilities;

final class RandomCookie {
    byte[] random_bytes = new byte[32];

    RandomCookie(SecureRandom secureRandom) {
        secureRandom.nextBytes(this.random_bytes);
    }

    RandomCookie(HandshakeInStream handshakeInStream) throws IOException {
        handshakeInStream.read(this.random_bytes, 0, 32);
    }

    void send(HandshakeOutStream handshakeOutStream) throws IOException {
        handshakeOutStream.write(this.random_bytes, 0, 32);
    }

    void print(PrintStream printStream) {
        printStream.print("random_bytes = {");
        for (int i = 0; i < 32; ++i) {
            int n = this.random_bytes[i] & 0xFF;
            if (i != 0) {
                printStream.print(' ');
            }
            printStream.print(Utilities.hexDigits[n >>> 4]);
            printStream.print(Utilities.hexDigits[n & 0xF]);
        }
        printStream.println("}");
    }
}

