/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class IgnoreAllErrorHandler
implements ErrorHandler {
    private static final Logger log = Logger.getLogger(IgnoreAllErrorHandler.class.getName());
    private static final boolean warnOnExceptions = IgnoreAllErrorHandler.getProperty("com.sun.org.apache.xml.internal.security.test.warn.on.exceptions");
    private static final boolean throwExceptions = IgnoreAllErrorHandler.getProperty("com.sun.org.apache.xml.internal.security.test.throw.exceptions");

    private static boolean getProperty(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.getBoolean(string);
            }
        });
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        if (warnOnExceptions) {
            log.log(Level.WARNING, "", sAXParseException);
        }
        if (throwExceptions) {
            throw sAXParseException;
        }
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        if (warnOnExceptions) {
            log.log(Level.SEVERE, "", sAXParseException);
        }
        if (throwExceptions) {
            throw sAXParseException;
        }
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (warnOnExceptions) {
            log.log(Level.WARNING, "", sAXParseException);
        }
        if (throwExceptions) {
            throw sAXParseException;
        }
    }
}

