#!/bin/bash
readonly success=0
readonly failed=1
readonly service_local_ip_port_error=2
readonly manager_local_ip_port_error=3
readonly service_ip_bond_mode_error=4
readonly manager_ip_bond_mode_error=5
readonly config_file_not_exist=6
readonly service_local_float_gateway_config_error=7
readonly manager_local_float_gateway_config_error=8
readonly HA_PROPERTIES="/home/HAInfoFromInstallTool.properties"
readonly IPV4=ipv4
readonly IPV6=ipv6
manager_ip_family=$IPV4

#恢复ipv6脚本路径
+restoreIpAndMaskFile="/home/checkConfig/restoreAndCompressIpv6.py"

ip_regular="^((22[0-3]|2[0-1][0-9]|1[0-9][0-9]|[1-9][0-9]|[1-9])\.)((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])\.){2}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[1-9])$"
active_ip_regular="((22[0-3]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[1-9])\.)((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])\.){2}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[1-9])"
netmask_regular="^(254|252|248|240|224|192|128)\.0\.0\.0|255\.(254|252|248|240|224|192|128|0)\.0\.0|255\.255\.(254|252|248|240|224|192|128|0)\.0|255\.255\.255\.(254|252|248|240|224|192|128|0)$"
IP_V4_REGULAR="^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$|^(([a-zA-Z]|[a-zA-Z][a-zA-Z0-9\-]*[a-zA-Z0-9])\.)*([A-Za-z]|[A-Za-z][A-Za-z0-9\-]*[A-Za-z0-9])$"
IP_V6_REGULAR="^\s*((([0-9A-Fa-f]{1,4}:){7}(([0-9A-Fa-f]{1,4})|:))|(([0-9A-Fa-f]{1,4}:){6}(:|((25[0-5]|2[0-4]\d|[01]?\d{1,2})(\.(25[0-5]|2[0-4]\d|[01]?\d{1,2})){3})|(:[0-9A-Fa-f]{1,4})))|(([0-9A-Fa-f]{1,4}:){5}((:((25[0-5]|2[0-4]\d|[01]?\d{1,2})(\.(25[0-5]|2[0-4]\d|[01]?\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){4}(:[0-9A-Fa-f]{1,4}){0,1}((:((25[0-5]|2[0-4]\d|[01]?\d{1,2})(\.(25[0-5]|2[0-4]\d|[01]?\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){3}(:[0-9A-Fa-f]{1,4}){0,2}((:((25[0-5]|2[0-4]\d|[01]?\d{1,2})(\.(25[0-5]|2[0-4]\d|[01]?\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){2}(:[0-9A-Fa-f]{1,4}){0,3}((:((25[0-5]|2[0-4]\d|[01]?\d{1,2})(\.(25[0-5]|2[0-4]\d|[01]?\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:)(:[0-9A-Fa-f]{1,4}){0,4}((:((25[0-5]|2[0-4]\d|[01]?\d{1,2})(\.(25[0-5]|2[0-4]\d|[01]?\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(:(:[0-9A-Fa-f]{1,4}){0,5}((:((25[0-5]|2[0-4]\d|[01]?\d{1,2})(\.(25[0-5]|2[0-4]\d|[01]?\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(((25[0-5]|2[0-4]\d|[01]?\d{1,2})(\.(25[0-5]|2[0-4]\d|[01]?\d{1,2})){3})))(%.+)?\s*$"
IPV6_VERIFY_REGEX="^\\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|[01]?\\d\\d?)(\\.(25[0-5]|2[0-4]\\d|[01]?\\d\\d?)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|[01]?\\d\\d?)(\\.(25[0-5]|2[0-4]\\d|[01]?\\d\\d?)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|[01]?\\d\\d?)(\\.(25[0-5]|2[0-4]\\d|[01]?\\d\\d?)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|[01]?\\d\\d?)(\\.(25[0-5]|2[0-4]\\d|[01]?\\d\\d?)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|[01]?\\d\\d?)(\\.(25[0-5]|2[0-4]\\d|[01]?\\d\\d?)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|[01]?\\d\\d?)(\\.(25[0-5]|2[0-4]\\d|[01]?\\d\\d?)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|[01]?\\d\\d?)(\\.(25[0-5]|2[0-4]\\d|[01]?\\d\\d?)){3}))|:)))(%.+)?\\s*$";
haInfoForCommonServer="/home/HAInfoFromInstallTool.properties"

#日志函数
log_file="/var/log/installtool.log"

external_flag=""

function checkPortLength()
{
    service_local_port_len=$(echo "${service_local_port}"|wc -L)
    manager_local_port_len=$(echo "${manager_local_port}"|wc -L)
    service_remote_port_len=$(echo "${service_remote_port}"|wc -L)
    manager_remote_port_len=$(echo "${manager_remote_port}"|wc -L)
    #当ha mode 为double时。网口名称不能大于13，当当ha mode 为single时,网口名称不能大于15
    if [ "${ha_mode}" == "double" ]
    then
        if [ ${service_local_port_len} -gt 13 -o ${manager_local_port_len} -gt 13 -o ${service_remote_port_len} -gt 13 -o ${service_remote_port_len} -gt 13 ]
        then
            echo "ERROR" "ha mode is double,port length not support more than 13 characters" >> ${log_file}
            committed="false"
        fi
    else
        if [ ${service_local_port_len} -gt 15 -o ${manager_local_port_len} -gt 15 ]
        then
            echo  "ERROR" "ha mode is double,port length not support more than 15 characters" >> ${log_file}
            committed="false"
        fi
    
    fi   
}

##############################################################
## @Usage get_manager_ip_family
## @Return IP协议类型 ipv4 ipv6
## @Description 获取管理网络平面网络类型；仅仅适用于安装过程中的场景
##############################################################
function get_manager_ip_family()
{
    is_ip_v4 $1
    if [ $? -eq 0 ]
    then
        echo "${IPV4}"
    else
        echo "${IPV6}"
    fi
    return 0
}

function is_ip_v4()
{
    local host=$1
    echo "${host}" | grep -Eq "${IP_V4_REGULAR}"
    return $?
}

function is_ip_v6()
{
    local host=$1
    echo "${host}" | grep -Eq "${IP_V6_REGULAR}"
    return $?
}

##############################################################
## @Usage restoreIpFromPython
## @Return fullIp
## @Description 将缩写扩展的全IP
##############################################################
function restoreIpFromPython()
{
    is_ip_v4 $1
    if [ $? -eq 0 ]
    then
        echo $1
        return 0
    fi
    is_ip_v6 $1
    if [ $? -eq 0 ]
    then
        echo `python $restoreIpAndMaskFile de_compress $1`
        return 0
    fi
    exit 1
}

function checkSubnetInfoIpv4()
{
    ip1="$1"
    ip2="$2"
    #openstack场景下，传入的参数是4个255，直接返回成功
    if [ "255.255.255.255" == "$ip1" ] || [ "255.255.255.255" == "$ip2" ];then
        checkStatus="true"
	return
    fi
    netmask="$3"
    flag="$4"
    ip1Arr=(${ip1//./ })
    ip2Arr=(${ip2//./ })
    ip1Tmp=""
    ip2Tmp=""
    netmaskArr=(${netmask//./ })
    for (( i = 0; i < 4; i++ ))
    do
        ip1=${ip1Arr[$i]}
        ip2=${ip2Arr[$i]}
        netmask=${netmaskArr[$i]}
        ip1Tmp+=$((ip1&netmask))
        ip2Tmp+=$((ip2&netmask))
    done
    if [ "${ip1Tmp}" !=  "${ip2Tmp}" ] && [ "${flag}" == "same" ];then
        checkStatus="false"
    fi

    if [ "${ip1Tmp}" == "${ip2Tmp}" ] && [ "${flag}" != "same" ];then
        checkStatus="false"
    fi

}

function checkSubnetInfoIpv6()
{
    ip1="$1"
    ip2="$2"
    #openstack场景下，传入的参数是4个255，直接返回成功
    if [ "${ip_addr_broadcast}" == "$ip1" ] || [ "${ip_addr_broadcast}" == "$ip2" ];then
        checkStatus="true"
        return
    fi

    ip1=$(restoreIpFromPython ${ip1})

    ip2=$(restoreIpFromPython ${ip2})
    netmask="$3"

    netmask=$(restoreIpFromPython ${netmask})
    flag="$4"
    #相当于split("//:")得到了数组
    ip1Arr=(${ip1//:/ })
    ip2Arr=(${ip2//:/ })
    ip1Tmp=""
    ip2Tmp=""
    netmaskArr=(${netmask//:/ })
    for (( i = 0; i < 8; i++ ))
    do
        tmp_ip1=${ip1Arr[$i]}
        tmp_ip2=${ip2Arr[$i]}
        tmp_netmask=${netmaskArr[$i]}
        #计算与掩码相与后的和是否相同
        ip1Tmp+=$((0x$tmp_ip1&0x$tmp_netmask))
        ip2Tmp+=$((0x$tmp_ip2&0x$tmp_netmask))
    done
    if [ "${ip1Tmp}" !=  "${ip2Tmp}" ] && [ "${flag}" == "same" ];then
        checkStatus="false"
    fi

    if [ "${ip1Tmp}" == "${ip2Tmp}" ] && [ "${flag}" != "same" ];then
        checkStatus="false"
    fi

}

function checkSubnetInfo()
{
    if [ x"${manager_ip_family}" == x"${IPV4}" ];then
        checkSubnetInfoIpv4 $@
    else
        checkSubnetInfoIpv6 $@
    fi
}

function checkAllNetWorkConfigure()
{
    #检查网口名称长度
    #checkPortLength

    ##service_local_ip 如果和已有port的IP相同
    #default_port=$(route -n | grep '^0.0.0.0' | awk 'NR==1{print $8}')
    #if [ -z "${default_port}" ];then
    #    default_port=$(ifconfig | grep -E ${active_ip_regular} -B 1 | awk 'NR==1{print $1}')
    #fi
    #if [ -z "${default_port}" ];then
    #    default_port=$(ifconfig | grep -E ${IPV6_VERIFY_REGEX} -B 1 | awk 'NR==1{print $1}')
    #fi
 
    checkStatus="true"
    #检查service_local_ip是否配置在配置的网口上
	#TMP=$(ip addr |grep -w ${service_local_ip} | awk -v val=${service_local_port} '{if($NF!=val) {print $NF}}')
    #TMP=$(ip addr |grep -w ${service_local_ip} | grep -w ${service_local_port})
    TMP=$(ip addr |grep -w ${service_local_ip})
	if [ -z "${TMP}" ];then
        echo "WARNNING" "local_${external_flag}manager_ip ${service_local_ip}  not on ${service_local_port}. " >> "${log_file}"
        return ${service_local_ip_port_error}
    fi
 
    # 检查存储网口的Bond模式是否为主备或者负载均衡，或者该存储网口没有组Bond
    bond_mode_conf="/sys/class/net/${service_local_port}/bonding/mode"
    if [ -f "$bond_mode_conf" ]; then
        cat $bond_mode_conf | grep -iE "balance-xor|active-backup|802\.3ad"
        if [ 0 -ne $? ]; then
            echo "ERROR" "${service_local_port} is invalid, the bond_mode not active-backup or balance-xor" >> "${log_file}"
			return ${service_ip_bond_mode_error}
        fi
    fi
    
    if [ "$net_mode" = "double" ];then 

		#TMP=$(ip addr |grep -w ${manager_local_ip} | grep -w ${manager_local_port})
		TMP=$(ip addr |grep -w ${manager_local_ip})
		if [ -z "${TMP}" ];then
			echo "WARNNING" "local_${external_flag}manager_ip ${manager_local_ip}  not on ${manager_local_port}. " >> ${log_file}
			return ${manager_local_ip_port_error}
		fi

        # 检查存储网口的Bond模式是否为主备或者负载均衡，或者该存储网口没有组Bond
        bond_mode_conf="/sys/class/net/${manager_local_port}/bonding/mode"
        if [ -f "$bond_mode_conf" ]; then
            cat $bond_mode_conf | grep -iE "balance-xor|active-backup|802\.3ad"
            if [ 0 -ne $? ]; then
                echo "ERROR" "${manager_local_port} is invalid, the bond_mode not active-backup or balance-xor" >> ${log_file}
				return ${manager_ip_bond_mode_error}
            fi
        fi
    fi
}
init()
{  
    if [ ! -f ${log_file} ]; then
        echo "$log_file doesn't exist,creat it." 
        mkdir -p /var/log/
        touch ${log_file}
    fi

    if [ ! -f ${HA_PROPERTIES} ]; then
        echo "$HA_PROPERTIES doesn't exist" >> ${log_file}
        exit 1
    fi
	source ${HA_PROPERTIES}
}
init
#获取管控面网络类型
manager_ip_family=$(get_manager_ip_family ${service_float_ip})
#检查配置文件信息是否正确
checkAllNetWorkConfigure
exit $?
