#
# Copyright 2016 Broadcom.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#


#
# Python 2.6.6
#

import OpEN_py as OpEN
from OpENUtil import *

open_ = OpENUtil()

class InterfaceExample:
  def __init__(self, client):
    self.m_client = client

  def interfaceExampleUsage(self):
    ifSize             = OpEN.OPENAPI_INTERFACE_NAME_LENGTH
    macSize            = OpEN.OPEN_MAC_ADDR_LEN
    ipAddr             = "10.130.181.158"
    ifName_array       = open_.getStringBuffer(ifSize)
    ifName_buff        = OpEN.open_buffdesc()
    ifName_buff.pstart = ifName_array
    ifName_buff.size   = ifSize
    ifNum_p            = OpEN.new_uint32_tp()
    mtu_p              = OpEN.new_uint32_tp()
    value_p            = OpEN.new_uint32_tp()
    state_p            = OpEN.new_OPEN_CONTROL_tp()
    speed_p            = OpEN.new_OPEN_PORT_SPEEDS_tp()
    duplex_p           = OpEN.new_OPEN_PORT_DUPLEX_tp()

    try:
      mac_array          = open_.getByteBuffer(macSize)
    except OpENBufferSizeError:
      print("interfaceExampleUsage: getByteBuffer raised OpENBufferSizeError")
      return
    except TypeError:
      print("interfaceExampleUsage: getByteBuffer raised TypeError")
      return
    mac_buff           = OpEN.open_buffdesc()
    mac_buff.pstart    = mac_array
    mac_buff.size      = macSize

    result = OpEN.openapiIfFirstGet(self.m_client, OpEN.OPEN_INTF_TYPE_PHY, ifNum_p)
    if result != OpEN.OPEN_E_NONE:
      print ("  Bad return code trying to get first physical interface. (result = %d)" % (result))
      return

    result = OpEN.openapiIfNameGet(self.m_client, OpEN.uint32_tp_value(ifNum_p), ifName_buff)
    if result != OpEN.OPEN_E_NONE:
      print ("  Bad return code trying to get first physical interface name. (result = %d)" % (result))
      return

    print ("Using physical interface %d, name %s" % (OpEN.uint32_tp_value(ifNum_p), ifName_array.cast()))

    result = OpEN.openapiIfAdminStateGet(self.m_client, OpEN.uint32_tp_value(ifNum_p), state_p)
    if result != OpEN.OPEN_E_NONE:
      print ("  Bad return code trying to get admin state physical interface. (result = %d)" % (result))
      return
    else:
      if OpEN.OPEN_CONTROL_tp_value(state_p) == OpEN.OPEN_ENABLE:
        print ("physical interface %d get admin-state : ENABLE" % (OpEN.uint32_tp_value(ifNum_p)))
        OpEN.OPEN_CONTROL_tp_assign(state_p, OpEN.OPEN_DISABLE)
      else:
        print ("physical interface %d get admin-state : DISABLE" % (OpEN.uint32_tp_value(ifNum_p)))
        OpEN.OPEN_CONTROL_tp_assign(state_p, OpEN.OPEN_ENABLE)

    result = OpEN.openapiIfAdminStateSet(self.m_client, OpEN.uint32_tp_value(ifNum_p), OpEN.OPEN_CONTROL_tp_value(state_p))
    if result != OpEN.OPEN_E_NONE:
      print ("  Bad return code trying to get speed of  physical interface. (result = %d)" % (result))
      return

    result = OpEN.openapiIfSpeedGet(self.m_client, OpEN.uint32_tp_value(ifNum_p), speed_p)
    if result != OpEN.OPEN_E_NONE:
      print ("  Bad return code trying to get speed of  physical interface. (result = %d)" % (result))
      return
    else:
      print ("physical interface %d speed %d" % (OpEN.uint32_tp_value(ifNum_p), OpEN.OPEN_PORT_SPEEDS_tp_value(speed_p)))

    result = OpEN.openapiIfDuplexModeGet(self.m_client, OpEN.uint32_tp_value(ifNum_p), duplex_p)
    if result != OpEN.OPEN_E_NONE:
      print ("  Bad return code trying to get duplex mode of  physical interface. (result = %d)" % (result))
      return
    else:
      print ("physical interface %d duplex mode %s" % (OpEN.uint32_tp_value(ifNum_p), OpEN.OPEN_PORT_DUPLEX_tp_value(duplex_p)))

    result = OpEN.openapiIfMtuSizeGet(self.m_client, OpEN.uint32_tp_value(ifNum_p), mtu_p)
    if result != OpEN.OPEN_E_NONE:
      print ("  Bad return code trying to get mtu size of  physical interface. (result = %d)" % (result))
    else:
      print ("physical interface %d MTU size : %d" % (OpEN.uint32_tp_value(ifNum_p), OpEN.uint32_tp_value(mtu_p)))

    result = OpEN.openapiIfMacAddrGet(self.m_client, OpEN.uint32_tp_value(ifNum_p), mac_buff)
    if result != OpEN.OPEN_E_NONE:
      print ("  Bad return code trying to get mac-address of  physical interface. (result = %d)" % (result))
    else:
      print ("physical interface %d mac-address : %s" % (OpEN.uint32_tp_value(ifNum_p), mac_array.cast()))

    print ("--- interface statistic---")

    result = OpEN.openapiIfLastChangeGet(self.m_client, OpEN.uint32_tp_value(ifNum_p), value_p)
    if result != OpEN.OPEN_E_NONE:
      print ("  Bad return code trying to get mtu size of  physical interface. (result = %d)" % (result))
    else:
      print ("Physical interface %d Time of last link state change: %d" % (OpEN.uint32_tp_value(ifNum_p), OpEN.uint32_tp_value(value_p)))

    result = OpEN.openapiIfInOctetsGet(self.m_client, OpEN.uint32_tp_value(ifNum_p), value_p)
    if result != OpEN.OPEN_E_NONE:
      print ("  Bad return code trying to get total number of octets. result = %d" % (result))
    else:
      print ("Physical interface %d Total number of octets: %d" % (OpEN.uint32_tp_value(ifNum_p), OpEN.uint32_tp_value(value_p)))

    result = OpEN.openapiIfInUcastPktsGet(self.m_client, OpEN.uint32_tp_value(ifNum_p), value_p)
    if result != OpEN.OPEN_E_NONE:
      print ("  Bad return code trying to get number of packets, delivered by this sub-layer to a higher sub-layer. result = %d" % (result))
    else:
      print ("Physical interface %d Number of packets, delivered by this sub-layer to a higher sub-layer: %d" % (OpEN.uint32_tp_value(ifNum_p), OpEN.uint32_tp_value(value_p)))

    result = OpEN.openapiIfInDiscardsGet(self.m_client, OpEN.uint32_tp_value(ifNum_p), value_p)
    if result != OpEN.OPEN_E_NONE:
      print ("  Bad return code trying to get number of inbound packets which were chosen to be discarded. result = %d" % (result))
    else:
      print ("Physical interface %d Number of inbound packets which were chosen to be discarded: %d" % (OpEN.uint32_tp_value(ifNum_p), OpEN.uint32_tp_value(value_p)))

    result = OpEN.openapiIfInErrorsGet(self.m_client, OpEN.uint32_tp_value(ifNum_p), value_p)
    if result != OpEN.OPEN_E_NONE:
      print ("  Bad return code trying to get In errors counter. result = %d" % (result))
    else:
      print ("Physical interface %d In errors counter: %d" % (OpEN.uint32_tp_value(ifNum_p), OpEN.uint32_tp_value(value_p)))

    result = OpEN.openapiIfInUnknownProtosGet(self.m_client, OpEN.uint32_tp_value(ifNum_p), value_p)
    if result != OpEN.OPEN_E_NONE:
      print ("  Bad return code trying to get number of packets received via the interface \nwhich were discarded because of an unknown or unsupported protocol. result = %d" % (result))
    else:
      print ("Physical interface %d Number of packets received via the interface which were discarded because of an unknown or unsupported protocol: %d" % (OpEN.uint32_tp_value(ifNum_p), OpEN.uint32_tp_value(value_p)))

    result = OpEN.openapiIfOutOctetsGet(self.m_client, OpEN.uint32_tp_value(ifNum_p), value_p)
    if result != OpEN.OPEN_E_NONE:
      print ("  Bad return code trying to get total number of octets transmitted out of the interface, including framing characters. result = %d" % (result))
    else:
      print ("Physical interface %d Total number of octets transmitted out of the interface, including framing characters: %d" % (OpEN.uint32_tp_value(ifNum_p), OpEN.uint32_tp_value(value_p)))

    result = OpEN.openapiIfOutUcastPktsGet(self.m_client, OpEN.uint32_tp_value(ifNum_p), value_p)
    if result != OpEN.OPEN_E_NONE:
      print ("  Bad return code trying to get total number of packets that higher-level protocols requested be transmitted. result = %d" % (result))
    else:
      print ("Physical interface %d Total number of packets that higher-level protocols requested be transmitted: %d" % (OpEN.uint32_tp_value(ifNum_p), OpEN.uint32_tp_value(value_p)))

    result = OpEN.openapiIfOutDiscardsGet(self.m_client, OpEN.uint32_tp_value(ifNum_p), value_p)
    if result != OpEN.OPEN_E_NONE:
      print ("  Bad return code trying to get number of outbound packets which were chosen to be discarded. result = %d" % (result))
    else:
      print ("Physical interface %d Number of outbound packets which were chosen to be discarded: %d" % (OpEN.uint32_tp_value(ifNum_p), OpEN.uint32_tp_value(value_p)))

    result = OpEN.openapiIfOutErrorsGet(self.m_client, OpEN.uint32_tp_value(ifNum_p), value_p)
    if result != OpEN.OPEN_E_NONE:
      print ("  Bad return code trying to get out errors counter. result = %d" % (result))
    else:
      print ("Physical interface %d Out errors counter: %d" % (OpEN.uint32_tp_value(ifNum_p), OpEN.uint32_tp_value(value_p)))

    OpEN.delete_uint32_tp(ifNum_p)
    OpEN.delete_uint32_tp(mtu_p)
    OpEN.delete_uint32_tp(value_p)
    OpEN.delete_OPEN_CONTROL_tp(state_p)
    OpEN.delete_OPEN_PORT_SPEEDS_tp(speed_p)
    OpEN.delete_OPEN_PORT_DUPLEX_tp(duplex_p)


def main():
  """Demonstrate OpEN usage for Interface APIs"""

  open = OpENUtil()
  ret = open.connect("inteface_example")
  if ret == OpEN.OPEN_E_NONE :
    open.getNetworkOSVersion()
    open.getAPIVersion()
    client = open.get_client()
    interfaceExample = InterfaceExample(client)
    interfaceExample.interfaceExampleUsage()
    open.terminate()
  else :
    print ("Unable to connect")

if __name__ == '__main__': main()
