import OpEN_py as OpEN
from OpENUtil import *

open_ = OpENUtil()

class pbvlanExample:

  def __init__(self, client):
    self.client = client

  ''' Creates new Protocol-Based Group with specified group ID '''
  def pbvlanGroupCreate(self, groupId):
    result = OpEN.openapiPbVlanGroupCreate(self.client, groupId)
    if result == OpEN.OPEN_E_NONE:
      print("The new Protocol-Based VLAN group with specified ID (%d) has been successfully created. (result = %d)" % (groupId, result))
    elif result == OpEN.OPEN_E_EXISTS:
      print("Protocol-Based VLAN group with specified ID (%d) already exists. (result = %d)" % (groupId, result))
    elif result == OpEN.OPEN_E_PARAM:
      print("Invalid parameter was passed. (result = %d)" % (result))
    else:
      print("Failed to created new Protocol-Based VLAN group with specified ID (%d). (result = %d)" % (groupId, result))

    return result

  ''' Deletes Protocol-Based Group with specified group ID '''
  def pbvlanGroupDelete(self, groupId):
    result = OpEN.openapiPbVlanGroupDelete(self.client, groupId)
    if result == OpEN.OPEN_E_NONE:
      print("Protocol-Based VLAN group with specified ID (%d) has been successfully deleted. (result = %d)" % (groupId, result))
    elif result == OpEN.OPEN_E_NOT_FOUND:
      print("Protocol-Based VLAN group with specified ID (%d) was not found. (result = %d)" % (groupId, result))
    elif result == OpEN.OPEN_E_PARAM:
      print("Invalid parameter was passed. (result = %d)" % (result))
    else:
      print("Failed to delete Protocol-Based VLAN group with specified ID (%d). (result = %d)" % (groupId, result))

    return

  ''' Demonstrates how to set/get a name of the Protocol-Based Group with specified group ID '''
  def pbvlanNameExample(self, groupId, groupName):
    result = self.pbvlanGroupCreate(groupId)
    if (result != OpEN.OPEN_E_NONE) and (result != OpEN.OPEN_E_EXISTS):
      return

    buffdesc = OpEN.open_buffdesc()
    try:
      buf_set = open_.getStringBuffer(len(groupName) + 1, groupName)
    except OpENBufferSizeError:
      print("pbvlanNameExample: getStringBuffer raised OpENBufferSizeError")
      return
    except TypeError:
      print("pbvlanNameExample: getStringBuffer raised TypeError")
      return
    buffdesc.pstart = buf_set
    buffdesc.size = len(groupName) + 1

    result = OpEN.openapiPbVlanGroupNameSet(self.client, groupId, buffdesc)
    if result == OpEN.OPEN_E_NONE:
      print("The name (%s) of the Protocol-Based VLAN group with specified ID (%d) has been successfully set. (result = %d)" % (buf_set.cast(), groupId, result))
    elif result == OpEN.OPEN_E_NOT_FOUND:
      print("Protocol-Based VLAN group with specified ID (%d) was not found. (result = %d)" % (groupId, result))
    elif result == OpEN.OPEN_E_PARAM:
      print("Invalid parameter was passed. (result = %d)" % (result))
    else:
      print("Failed to set the name (%s) of the Protocol-Based VLAN group with specified ID (%d). (result = %d)" % (buf_set.cast(), groupId, result))

    if result == OpEN.OPEN_E_NONE:
      group_name = OpEN.open_buffdesc()
      group_name.size = OpEN.OPENAPI_PBVLAN_MAX_GROUP_NAME + 1
      try:
        buf_get = open_.getStringBuffer(group_name.size)
      except OpENBufferSizeError:
        print("pbvlanNameExample: getStringBuffer raised OpENBufferSizeError")
        return
      except TypeError:
        print("pbvlanNameExample: getStringBuffer raised TypeError")
        return
      group_name.pstart = buf_get

      result = OpEN.openapiPbVlanGroupNameGet(self.client, groupId, group_name)
      if result == OpEN.OPEN_E_NONE:
        print("The name of the Protocol-Based VLAN group with specified ID (%d) is %s. (result = %d)" % (groupId, buf_get.cast(), result))
      elif result == OpEN.OPEN_E_NOT_FOUND:
        print("Protocol-Based VLAN group with specified ID (%d) was not found. (result = %d)" % (groupId, result))
      elif result == OpEN.OPEN_E_PARAM:
        print("Invalid parameter was passed. (result = %d)" % (result))
      else:
        print("Failed to get the name of the Protocol-Based VLAN group with specified ID (%d). (result = %d)" % (groupId, result))

    self.pbvlanGroupDelete(groupId)
    return


  ''' Demonstrates how to add/get/delete VLAN ID of the Protocol-Based Group with specified group ID '''
  def pbvlanVlanExample(self, groupId, vlanId):
    result = self.pbvlanGroupCreate(groupId)
    if (result != OpEN.OPEN_E_NONE) and (result != OpEN.OPEN_E_EXISTS):
      return

    result = OpEN.openapiPbVlanGroupVlanIDAdd(self.client, groupId, vlanId)
    if result == OpEN.OPEN_E_NONE:
      print("The VLAN (%d) has been successfully added to the Protocol-Based VLAN group with specified ID (%d). (result = %d)" % (vlanId, groupId, result))
    elif result == OpEN.OPEN_E_NOT_FOUND:
      print("Protocol-Based VLAN group with specified ID (%d) was not found. (result = %d)" % (groupId, result))
    elif result == OpEN.OPEN_E_PARAM:
      print("Invalid parameter was passed. (result = %d)" % (str.cast(), result))
    else:
      print("Failed to add the VLAN (%d) to the Protocol-Based VLAN group with specified ID (%d). (result = %d)" % (vlanId, groupId, result))

    if result == OpEN.OPEN_E_NONE:
      newVlanId_p = OpEN.new_uint32_tp()

      result = OpEN.openapiPbVlanGroupVlanIDGet(self.client, groupId, newVlanId_p)
      if result == OpEN.OPEN_E_NONE:
        print("The VLAN ID of the Protocol-Based VLAN group with specified ID (%d) is %d. (result = %d)" % (groupId, OpEN.uint32_tp_value(newVlanId_p), result))
      elif result == OpEN.OPEN_E_NOT_FOUND:
        print("Protocol-Based VLAN group with specified ID (%d) was not found. (result = %d)" % (groupId, result))
      elif result == OpEN.OPEN_E_PARAM:
        print("Invalid parameter was passed. (result = %d)" % (result))
      else:
        print("Failed to get the VLAN ID of the Protocol-Based VLAN group with specified ID (%d). (result = %d)" % (groupId, result))

      result = OpEN.openapiPbVlanGroupVlanIDDelete(self.client, groupId, vlanId)
      if result == OpEN.OPEN_E_NONE:
        print("The VLAN (%d) has been successfully deleted from the Protocol-Based VLAN group with specified ID (%d). (result = %d)" % (vlanId, groupId, result))
      elif result == OpEN.OPEN_E_NOT_FOUND:
        print("Protocol-Based VLAN group with specified ID (%d) was not found. (result = %d)" % (groupId, result))
      elif result == OpEN.OPEN_E_ERROR:
        print("VLAN (%d) was not found in the Protocol-Based VLAN group with specified ID (%d). (result = %d)" % (vlanId, groupId, result))
      elif result == OpEN.OPEN_E_PARAM:
        print("Invalid parameter was passed. (result = %d)" % (result))
      else:
        print("Failed to delete the VLAN (%d) from the Protocol-Based VLAN group with specified ID (%d). (result = %d)" % (vlanId, groupId, result))

      OpEN.delete_uint32_tp(newVlanId_p)

    self.pbvlanGroupDelete(groupId)
    return

  ''' Demonstrates how to add/get/delete a protocol of the Protocol-Based Group with specified group ID '''
  def pbvlanProtocolExample(self, groupId, prot, protType):
    result = self.pbvlanGroupCreate(groupId)
    if (result != OpEN.OPEN_E_NONE) and (result != OpEN.OPEN_E_EXISTS):
      return

    result = OpEN.openapiPbVlanGroupProtocolAdd(self.client, groupId, prot, protType)
    if result == OpEN.OPEN_E_NONE:
      print("The protocol (%d) has been successfully added to the Protocol-Based VLAN group with specified ID (%d). (result = %d)" % (prot, groupId, result))
    elif result == OpEN.OPEN_E_NOT_FOUND:
      print("Protocol-Based VLAN group with specified ID (%d) was not found. (result = %d)" % (groupId, result))
    elif result == OpEN.OPEN_E_EXISTS:
      print("Protocol (%d) is already added to the group with specified ID (%d). (result = %d)" % (prot, groupId, result))
    elif result == OpEN.OPEN_E_PARAM:
      print("Invalid parameter was passed. (result = %d)" % (result))
    else:
      print("Failed to add the protocol (%d) to the Protocol-Based VLAN group with specified ID (%d). (result = %d)" % (prot, groupId, result))

    if (result == OpEN.OPEN_E_NONE) or (result == OpEN.OPEN_E_EXISTS):
      newProt_p = OpEN.new_uint32_tp()

      result = OpEN.openapiPbVlanGroupProtocolGetNext(self.client, groupId, 0, newProt_p)
      if result == OpEN.OPEN_E_NONE:
        print("The first protocol of the Protocol-Based VLAN group with specified ID (%d) is %d. (result = %d)" % (groupId, OpEN.uint32_tp_value(newProt_p), result))
      elif result == OpEN.OPEN_E_NOT_FOUND:
        print("Protocol-Based VLAN group with specified ID (%d) was not found. (result = %d)" % (groupId, result))
      elif result == OpEN.OPEN_E_PARAM:
        print("Invalid parameter was passed. (result = %d)" % (result))
      else:
        print("Failed to get the first protocol of the Protocol-Based VLAN group with specified ID (%d). (result = %d)" % (groupId, result))

      result = OpEN.openapiPbVlanGroupProtocolDelete(self.client, groupId, prot)
      if result == OpEN.OPEN_E_NONE:
        print("The protocol (%d) has been successfully deleted from the Protocol-Based VLAN group with specified ID (%d). (result = %d)" % (prot, groupId, result))
      elif result == OpEN.OPEN_E_NOT_FOUND:
        print("Protocol-Based VLAN group with specified ID (%d) was not found. (result = %d)" % (groupId, result))
      elif result == OpEN.OPEN_E_ERROR:
        print("Protocol (%d) was not found in the Protocol-Based VLAN group with specified ID (%d). (result = %d)" % (prot, groupId, result))
      elif result == OpEN.OPEN_E_PARAM:
        print("Invalid parameter was passed. (result = %d)" % (result))
      else:
        print("Failed to delete the protocol (%d) from the Protocol-Based VLAN group with specified ID (%d). (result = %d)" % (prot, groupId, result))

      OpEN.delete_uint32_tp(newProt_p)

    self.pbvlanGroupDelete(groupId)
    return

  ''' Demonstrates how to add/get/delete an interface of the Protocol-Based Group with specified group ID '''
  def pbvlanPortExample(self, groupId, ifNum):
    result = self.pbvlanGroupCreate(groupId)
    if (result != OpEN.OPEN_E_NONE) and (result != OpEN.OPEN_E_EXISTS):
      return

    result = OpEN.openapiPbVlanIntfValidate(self.client, ifNum)
    if result == OpEN.OPEN_E_NONE:
      print("The interface (%d) could be used for the Protocol-Based VLAN configuration. (result = %d)" % (ifNum, result))
    elif result == OpEN.OPEN_E_PARAM:
      print("Invalid parameter was passed. (result = %d)" % (result))
    else:
      print("The interface (%d) could not be used for the Protocol-Based VLAN configuration. (result = %d)" % (ifNum, result))

    result = OpEN.openapiPbVlanGroupPortAdd(self.client, groupId, ifNum)
    if result == OpEN.OPEN_E_NONE:
      print("The interface (%d) has been successfully added to the Protocol-Based VLAN group with specified ID (%d). (result = %d)" % (ifNum, groupId, result))
    elif result == OpEN.OPEN_E_NOT_FOUND:
      print("Protocol-Based VLAN group with specified ID (%d) was not found. (result = %d)" % (groupId, result))
    elif result == OpEN.OPEN_E_PARAM:
      print("Invalid parameter was passed. (result = %d)" % (result))
    else:
      print("Failed to add the protocol (%d) to the Protocol-Based VLAN group with specified ID (%d). (result = %d)" % (ifNum, groupId, result))

    if result == OpEN.OPEN_E_NONE:
      newIfNum_p = OpEN.new_uint32_tp()

      result = OpEN.openapiPbVlanGroupPortGetNext(self.client, groupId, 0, newIfNum_p)
      if result == OpEN.OPEN_E_NONE:
        print("The first interface of the Protocol-Based VLAN group with specified ID (%d) is %d. (result = %d)" % (groupId, OpEN.uint32_tp_value(newIfNum_p), result))
      elif result == OpEN.OPEN_E_NOT_FOUND:
        print("Protocol-Based VLAN group with specified ID (%d) was not found. (result = %d)" % (groupId, result))
      elif result == OpEN.OPEN_E_PARAM:
        print("Invalid parameter was passed. (result = %d)" % (result))
      else:
        print("Failed to get the first interface of the Protocol-Based VLAN group with specified ID (%d). (result = %d)" % (groupId, result))

      result = OpEN.openapiPbVlanGroupPortDelete(self.client, groupId, ifNum)
      if result == OpEN.OPEN_E_NONE:
        print("The interface (%d) has been successfully deleted from the Protocol-Based VLAN group with specified ID (%d). (result = %d)" % (ifNum, groupId, result))
      elif result == OpEN.OPEN_E_NOT_FOUND:
        print("Protocol-Based VLAN group with specified ID (%d) was not found. (result = %d)" % (groupId, result))
      elif result == OpEN.OPEN_E_ERROR:
        print("Interface (%d) was not found in the Protocol-Based VLAN group with specified ID (%d). (result = %d)" % (ifNum, groupId, result))
      elif result == OpEN.OPEN_E_PARAM:
        print("Invalid parameter was passed. (result = %d)" % (result))
      else:
        print("Failed to delete the protocol (%d) from the Protocol-Based VLAN group with specified ID (%d). (result = %d)" % (ifNum, groupId, result))

      OpEN.delete_uint32_tp(newIfNum_p)

    self.pbvlanGroupDelete(groupId)
    return

def main():
  ret = open_.connect("pbvlan_example")
  if ret == OpEN.OPEN_E_NONE :
    open_.getNetworkOSVersion()
    client = open_.get_client()

    example = pbvlanExample(client)
    example.pbvlanNameExample(10, "test_name")
    example.pbvlanVlanExample(10, 10)
    example.pbvlanProtocolExample(10, 0x0800, OpEN.OPENAPI_PBVLAN_NUM_PROT_TYPE)
    example.pbvlanPortExample(10, 1)

    open_.terminate()
  else :
    print("Unable to connect")

if __name__ == '__main__': main()
