import OpEN_py as OpEN
from OpENUtil import *
open_ = OpENUtil()

#
# Copyright 2016 Broadcom.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#


#
# Python 2.6.6
#

class STPExample :
  def __init__(self, client) :
    self.m_client = client

  def dot1s_mode_set (self, mode) :
      result = OpEN.openapiDot1SModeSet(self.m_client, mode)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else :
       return 0

  def dot1s_mode_get (self, mode) :
      result = OpEN.openapiDot1SModeGet(self.m_client, mode)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else :
       return 0

  def dot1s_intf_bpdu_filter_mode_set (self, ifNum, mode) :
      result = OpEN.openapiDot1SIntfBPDUFilterModeSet(self.m_client, ifNum, mode)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else :
       return 0

  def dot1s_intf_bpdu_filter_mode_get (self, ifNum, mode) :
      result = OpEN.openapiDot1SIntfBPDUFilterModeGet(self.m_client, ifNum, mode)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else :
       return 0

  def dot1s_intf_bpdu_flood_mode_set (self, ifNum, mode) :
      result = OpEN.openapiDot1SIntfBPDUFloodModeSet(self.m_client, ifNum, mode)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else :
       return 0

  def dot1s_intf_bpdu_flood_mode_get (self, ifNum, mode) :
      result = OpEN.openapiDot1SIntfBPDUFloodModeGet(self.m_client, ifNum, mode)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else :
       return 0

  def dot1s_mgmt_str_len_get (self, dot1sLen) :
      result = OpEN.openapiDot1sMgmtStrLenGet(self.m_client, OpEN.OPEN_DOT1S_MGMT_STR_CONFIG_NAME, dot1sLen)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else :
       return 0

  def dot1s_config_name_set (self, name) :
      result = OpEN.openapiDot1SConfigNameSet(self.m_client, name)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else :
       return 0

  def dot1s_config_name_get (self, name) :
      result = OpEN.openapiDot1SConfigNameGet(self.m_client, name)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else :
       return 0
       
  def dot1s_config_revision_set (self, revision) :
      result = OpEN.openapiDot1SConfigRevisionSet(self.m_client, revision)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else :
       return 0

  def dot1s_config_revision_get (self, revision) :
      result = OpEN.openapiDot1SConfigRevisionGet(self.m_client, revision)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else :
       return 0

  def dot1s_intf_guard_mode_set (self, ifNum, mode) :
      result = OpEN.openapiDot1SIntfGuardModeSet(self.m_client, ifNum, mode)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else :
       return 0

  def dot1s_intf_guard_mode_get (self, ifNum, mode) :
      result = OpEN.openapiDot1SIntfGuardModeGet(self.m_client, ifNum, mode)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else :
       return 0

  def dot1s_smst_instance_set (self, dot1sMSTInstanceId, action) :
      result = OpEN.openapiDot1SMSTInstanceSet(self.m_client, dot1sMSTInstanceId, action)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else :
       return 0

  def dot1s_smst_instance_first_get(self, instanceId) :
      result = OpEN.openapiDot1SMSTInstanceFirstGet(self.m_client, instanceId)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else :
       return 0

  def dot1s_smst_instance_next_get(self, instanceId, nextInstanceId) :
      result = OpEN.openapiDot1SMSTInstanceNextGet(self.m_client, instanceId, nextInstanceId)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else :
       return 0

  def dot1s_intf_mode_get (self, ifNum, mode) :
      result = OpEN.openapiDot1SIntfModeGet(self.m_client, ifNum, mode)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else :
       return 0

  def dot1s_intf_port_fwd_state_get (self, ifNum, dot1sInstance, dot1sPortFwdState) :
      result = OpEN.openapiDot1SIntfPortFwdStateGet(self.m_client, ifNum, dot1sInstance, dot1sPortFwdState)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else :
       return 0

def main() :
    """Demonstrate OpEN usage for STP(DOT1S) APIs"""
    ret = open_.connect("dot1s_example")
    if ret == OpEN.OPEN_E_NONE :
      open_.getNetworkOSVersion()
      client = open_.get_client()
      
      example = STPExample(client)
      mode = OpEN.new_OPEN_CONTROL_tp()
      mode = OpEN.OPEN_ENABLE
      ifNum = OpEN.new_uint32_tp()
      mngmLen = OpEN.new_uint32_tp()
      OpEN.uint32_tp_assign(ifNum, 1)
      ifNumValue = OpEN.uint32_tp_value(ifNum)
      """DOT1S Mode Set/Get"""
      if (example.dot1s_mode_set(mode) != 0) :
       print("Bad return code trying to set Spanning Tree Operational Mode.")
      else :
       print("Spanning Tree Operational Mode set successfully.")

      mode = OpEN.new_OPEN_CONTROL_tp()
      if (example.dot1s_mode_get(mode) != 0) :
       print("Bad return code trying to get Spanning Tree Operational Mode.")
      else :
       if (OpEN.OPEN_CONTROL_tp_value(mode) == OpEN.OPEN_ENABLE) :
        text = " Enabled"
       elif (OpEN.OPEN_CONTROL_tp_value(mode) == OpEN.OPEN_DISABLE) :
        text = " Disableed"
       else :
        text = " Undefined"
       print("Spanning Tree Operational Mode: %s" % (text))

      """DOT1S Interface BPDU Filter Mode Set/Get"""
      if (example.dot1s_intf_bpdu_filter_mode_set(ifNumValue, OpEN.OPEN_CONTROL_tp_value(mode)) != 0) :
       print("Bad return code trying to set Spanning Tree Interface BPDU Filter Mode.")
      else :
       print("Spanning Tree Interface BPDU Filter Mode set successfully.")

      if (example.dot1s_intf_bpdu_filter_mode_get(ifNumValue, mode) != 0) :
       print("Bad return code trying to get Spanning Tree Interface BPDU Filter Mode.")
      else :
       if (OpEN.OPEN_CONTROL_tp_value(mode) == OpEN.OPEN_ENABLE) :
        text = " Enabled"
       elif (OpEN.OPEN_CONTROL_tp_value(mode) == OpEN.OPEN_DISABLE) :
        text =  " Disableed"
       else :
        text = " Undefined"
       print("Spanning Tree Interface BPDU Filter Mode for interface %s: %s" % (ifNumValue, text))

      """DOT1S Interface BPDU Filter Mode Set/Get"""
      if (example.dot1s_intf_bpdu_flood_mode_set(ifNumValue, OpEN.OPEN_CONTROL_tp_value(mode)) != 0) :
       print("Bad return code trying to set Spanning Tree Interface BPDU Flood Mode.")
      else :
       print("Spanning Tree Interface BPDU Flood Mode set successfully.")

      if (example.dot1s_intf_bpdu_flood_mode_get(ifNumValue, mode) != 0) :
       print("Bad return code trying to get Spanning Tree Interface BPDU Flood Mode.")
      else :
       if (OpEN.OPEN_CONTROL_tp_value(mode) == OpEN.OPEN_ENABLE) :
        text = " Enabled"
       elif (OpEN.OPEN_CONTROL_tp_value(mode) == OpEN.OPEN_DISABLE) :
        text = " Disableed"
       else :
        text = " Undefined"
       print("Spanning Tree Interface BPDU Flood Mode for interface %s: %s" % (ifNumValue, text))

      """DOT1S Config name Set/Get"""
      s = 'test_name_dot1s'
      try:
        name_string  = open_.getStringBuffer(len(s) + 1, s) 
      except OpENBufferSizeError:
        print("main: getStringBuffer raised OpENBufferSizeError")
        return
      except TypeError:
        print("main: getStringBuffer raised TypeError")
        return
      name = OpEN.open_buffdesc()
      name.pstart = name_string
      name.size = len(s) + 1

      if (example.dot1s_config_name_set(name) != 0) :
       print("Bad return code trying to set Spanning Tree Configuration Name.")
      else :
       print("Spanning Tree Configuration Name set successfully.")

      max_len = 100
      if (example.dot1s_mgmt_str_len_get(mngmLen) != 0) :
       print("Bad return code for mgmt string length, buffer has default size {}.".format(max_len))
      else :
       max_len =  OpEN.uint32_tp_value(mngmLen)
       print("Buffer size is: %s" % (max_len))

      try:
        name_string = open_.getStringBuffer(max_len)
      except OpENBufferSizeError:
        print("main: getStringBuffer raised OpENBufferSizeError")
        return
      except TypeError:
        print("main: getStringBuffer raised TypeError")
        return
      name.pstart = name_string
      name.size = max_len
      if (example.dot1s_config_name_get(name) != 0) :
       print("Bad return code trying to get Spanning Tree Configuration Name.")
      else :
       print("Spanning Tree Configuration Name: %s" % (name_string.cast()))

      """DOT1S Config name Set/Get"""
      revision = OpEN.new_uint32_tp()
      OpEN.uint32_tp_assign(revision, 3200)
      if (example.dot1s_config_revision_set(OpEN.uint32_tp_value(revision))) :
       print("Bad return code trying to set Spanning Tree Configuration Revision.")
      else :
       print("Spanning Tree Configuration Revision set successfully.")
      
      OpEN.uint32_tp_assign(revision, 0)
      if (example.dot1s_config_revision_get(revision)) :
       print("Bad return code trying to get Spanning Tree Configuration Revision.")
      else :
       print("Spanning Tree Configuration Revision: %s." % (OpEN.uint32_tp_value(revision)))

      if (example.dot1s_intf_guard_mode_set(ifNumValue, OpEN.OPEN_CONTROL_tp_value(mode)) != 0) :
       print("Bad return code trying to set Spanning Tree Interface Guard Mode.")
      else :
       print("Spanning Tree Interface Guard Mode set successfully.")

      modeGuard = OpEN.new_OPEN_DOT1S_PORT_GUARD_tp()
      if (example.dot1s_intf_guard_mode_get(ifNumValue, modeGuard) != 0) :
       print("Bad return code trying to get Spanning Tree Interface Guard Mode.")
      else :
       if (OpEN.OPEN_DOT1S_PORT_GUARD_tp_value(modeGuard) == OpEN.OPEN_DOT1S_PORT_GUARD_LOOP) :
        text = " Loop"
       elif (OpEN.OPEN_DOT1S_PORT_GUARD_tp_value(modeGuard) == OpEN.OPEN_DOT1S_PORT_GUARD_ROOT) :
        text = " Root"
       elif (OpEN.OPEN_DOT1S_PORT_GUARD_tp_value(modeGuard) == OpEN.OPEN_DOT1S_PORT_GUARD_NONE) :
        text = " None"
       else :
        text = " Undefined"
      print("Spanning Tree Interface Guard Mode for interface %s: %s" % (ifNumValue, text))

      dot1sMSTInstanceId = OpEN.new_uint32_tp() 
      OpEN.uint32_tp_assign(dot1sMSTInstanceId, 1)
      if (example.dot1s_smst_instance_set(OpEN.uint32_tp_value(dot1sMSTInstanceId), OpEN.OPEN_ACTION_ADD) != 0) :
       print("Bad return code trying to configure Spanning Tree MST Instance.")
      else :
       print("Spanning Tree MST Instance set successfully.")

      text = ''
      instanceId = OpEN.new_uint32_tp()
      nextInstanceId = OpEN.new_uint32_tp()
      if (example.dot1s_smst_instance_first_get(instanceId) != 0) :
       print("Bad return code trying to get the first Spanning Tree MST Instance.")
      else :
       text += str(OpEN.uint32_tp_value(instanceId))
    
      while (example.dot1s_smst_instance_next_get(OpEN.uint32_tp_value(instanceId), nextInstanceId) == 0) :
       text += ", %s" % (OpEN.uint32_tp_value(nextInstanceId))
       instanceId = nextInstanceId
      print("Spanning Tree MST Instances: %s" % (text))

      if (example.dot1s_intf_mode_get(ifNumValue, mode) != 0) :
       print("Bad return code trying to get Spanning Tree Mode.")
      else :
       if (OpEN.OPEN_CONTROL_tp_value(mode) == OpEN.OPEN_ENABLE) :
        text = " Enabled"
       elif (OpEN.OPEN_CONTROL_tp_value(mode) == OpEN.OPEN_DISABLE) :
        text = " Disableed"
       else :
        text = " Undefined"
       print("Spanning Tree Interface Mode for interface %s: %s" % (ifNumValue, text))
    
      dot1sPortFwdStat = OpEN.new_OPEN_DOT1S_PORT_FWD_STATE_tp()
      if (example.dot1s_intf_port_fwd_state_get(ifNumValue, OpEN.uint32_tp_value(instanceId), dot1sPortFwdStat) != 0) :
       print("Bad return code trying to get Spanning Tree Port Forwarding State. ")
      else :
       if (OpEN.OPEN_DOT1S_PORT_FWD_STATE_tp_value(dot1sPortFwdStat) == OpEN.OPEN_DOT1S_PORT_DISCARDING) :
        text = " Discarding"
       elif (OpEN.OPEN_DOT1S_PORT_FWD_STATE_tp_value(dot1sPortFwdStat) == OpEN.OPEN_DOT1S_PORT_LEARNING) :
        text = " Learning"
       elif (OpEN.OPEN_DOT1S_PORT_FWD_STATE_tp_value(dot1sPortFwdStat) == OpEN.OPEN_DOT1S_PORT_FORWARDING) :
        text = " Forwarding"
       elif (OpEN.OPEN_DOT1S_PORT_FWD_STATE_tp_value(dot1sPortFwdStat) == OpEN.OPEN_DOT1S_PORT_DISABLED) :
        text = " Disabled"
       elif (OpEN.OPEN_DOT1S_PORT_FWD_STATE_tp_value(dot1sPortFwdStat) == OpEN.OPEN_DOT1S_PORT_MANUAL_FWD) :
        text = " Manual Forward"
       elif (OpEN.OPEN_DOT1S_PORT_FWD_STATE_tp_value(dot1sPortFwdStat) == OpEN.OPEN_DOT1S_PORT_NOT_PARTICIPATE) :
        text = " Not Participating"
       else :
        text = " Undefined"
       print("Spanning Tree Interface Port Forwarding State: %s" % (text))

       if (example.dot1s_smst_instance_set(OpEN.uint32_tp_value(dot1sMSTInstanceId), OpEN.OPEN_ACTION_DELETE) != 0) :
        print("Bad return code trying to delete Spanning Tree MST Instance.")
       else :
        print("Spanning Tree MST Instance deleted successfully.")
    
      OpEN.delete_OPEN_DOT1S_PORT_GUARD_tp(modeGuard)
      OpEN.delete_OPEN_DOT1S_PORT_FWD_STATE_tp(dot1sPortFwdStat)
      OpEN.delete_uint32_tp(ifNum)
      OpEN.delete_uint32_tp(instanceId)
      OpEN.delete_uint32_tp(dot1sMSTInstanceId)
      OpEN.delete_uint32_tp(revision)
      OpEN.delete_OPEN_CONTROL_tp(mode)
      OpEN.delete_uint32_tp(mngmLen)
    else :
      print("Unable to connect")
    open_.terminate()
if __name__ == '__main__': main()
