import OpEN_py as OpEN
from OpENUtil import *
from time import time
from select import select
import fcntl
import os
import errno
from sys import version_info

#
# Copyright 2016 Broadcom.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#


#
# Python 2.6.6
#

class Vlan :
  def __init__(self):
    self.m_vlan_exists = False
    self.m_staticVlan = False

class VlanExample :
  def __init__(self, client) :
    self.m_client = client
    self.m_vlan_table = []

  def vlan_status_show(self):
    print("\n\nThe following VLAN IDs are in the switch's VLAN database:\n")
    size = 4096
    if version_info >= (3,0,0):
      for i in range(0, size - 1):
        if self.m_vlan_table[i].vlan_exists == True :
          res = "VLAN: " + str(i) + " is "
          if self.m_vlan_table[i].staticVlan == True :
            res += "Static"
          else :
            res += "Dynamic"
          print(res)
    else:
      for i in xrange(0, size - 1):
        if self.m_vlan_table[i].vlan_exists == True :
          res = "VLAN: " + str(i) + " is "
          if self.m_vlan_table[i].staticVlan == True :
            res += "Static"
          else :
            res += "Dynamic"
          print(res)

  def vlan_table_validate(self):
    size = 4096
    if version_info >= (3,0,0):
      for vlan_num in range(0, size - 1) :
        if self.m_vlan_table[vlan_num].exists == True :
          ret = OpEN.openapiVlanCreatedCheck(self.m_client, vlan_num)
          if ret == OPEN_E_NONE :
            self.m_vlan_table[vlan_num].staticVlan = OpEN.openapiVlanIsStatic(self.m_client, vlan_num)
          else :
            self.m_vlan_table[vlan_num].vlan_exists = False;
            self.m_vlan_table[vlan_num].staticVlan = False;
    else:
      for vlan_num in xrange(0, size - 1) :
        if self.m_vlan_table[vlan_num].exists == True :
          ret = OpEN.openapiVlanCreatedCheck(self.m_client, vlan_num)
          if ret == OPEN_E_NONE :
            self.m_vlan_table[vlan_num].staticVlan = OpEN.openapiVlanIsStatic(self.m_client, vlan_num)
          else :
            self.m_vlan_table[vlan_num].vlan_exists = False;
            self.m_vlan_table[vlan_num].staticVlan = False;

  def vlan_table_create(self):
    size = 4096
    self.m_vlan_table = []

    open_event = OpEN.openapiEventList_t()
    OpEN.openapiEventListClear(open_event)
    OpEN.openapiEventSet(open_event, OpEN.OPEN_EVENT_VLAN)

    ret = OpEN.openapiEventRegister(self.m_client, open_event)
    if ret != OpEN.OPEN_E_NONE :
      print("Failed to register for OPEN_EVENT_VLAN events.\n")
    else :
      print("Successfully registered for OPEN_EVENT_VLAN events.\n")

      size -= 1
      if version_info >= (3,0,0):
        for vlan_num in range(0, size):
          vlan = Vlan()
          ret = OpEN.openapiVlanCreatedCheck(self.m_client, vlan_num)
          if ret == OpEN.OPEN_E_NONE :
            vlan.vlan_exists = True
            vlan.staticVlan = OpEN.openapiVlanIsStatic(self.m_client, vlan_num)
          else :
            vlan.vlan_exists = False
            vlan.staticVlan = False
          self.m_vlan_table.append(vlan)
      else:
        for vlan_num in xrange(0, size):
          vlan = Vlan()
          ret = OpEN.openapiVlanCreatedCheck(self.m_client, vlan_num)
          if ret == OpEN.OPEN_E_NONE :
            vlan.vlan_exists = True
            vlan.staticVlan = OpEN.openapiVlanIsStatic(self.m_client, vlan_num)
          else :
            vlan.vlan_exists = False
            vlan.staticVlan = False
          self.m_vlan_table.append(vlan)

      vlan_num = 1
      while True :
        self.m_vlan_table[vlan_num].vlan_exists = True
        self.m_vlan_table[vlan_num].staticVlan = OpEN.openapiVlanIsStatic(self.m_client, vlan_num)
        vlan_num_p = OpEN.new_uint32_tp()
        ret = OpEN.openapiVlanNextGet(self.m_client, vlan_num, vlan_num_p)
        if ret == OpEN.OPEN_E_NONE:
          vlan_num = OpEN.uint32_tp_value(vlan_num_p)
        else:
          break
        OpEN.delete_uint32_tp(vlan_num_p)

  def vlan_table_monitor(self, duration):
    change_pending_event = OpEN.openapiEventList_t()
    OpEN.openapiEventListClear(change_pending_event)
    purge_event = OpEN.openapiEventList_t()
    OpEN.openapiEventListClear(purge_event)

    end_time = time() + duration
    notify_fd = OpEN.openapiClientNotifySocketFDGet(self.m_client)
    if notify_fd == 0 :
      print("Invalid notify_fd retrieved")
    else :
      fcntl.fcntl(notify_fd, fcntl.F_SETFL, os.O_NONBLOCK)
      print("notify_fd is %d\n" % notify_fd)
      rd_fds = [notify_fd]
      wr_fds = []
      ex_fds = [] 
      while time() < end_time :
        rr, wr, er = select(rd_fds, wr_fds, ex_fds, 5)
        if len(rr) :
          while True:
            s = ""
            try:
              s = os.read(notify_fd, 1024)
            except os.error as e:
              if e.errno == errno.EWOULDBLOCK:
                break
            if len(s) > 0 :
              continue
            else :
              break  
          ret = OpEN.openapiPendingEventsGet(self.m_client, change_pending_event.m_open_event, purge_event.m_open_event)
          if ret == OpEN.OPEN_E_NONE :
            if purge_event.is_set(OpEN.OPEN_EVENT_VLAN) == True :
              print("Got Purge event for OPEN_EVENT_VLAN")
              vlan_table_validate()
            if change_pending_event.is_set(OpEN.OPEN_EVENT_VLAN) == True :
              print("Got Change Pending event for OPEN_EVENT_VLAN")

          vlan_num = 0
          vlan_num_p = OpEN.new_uint32_tp()
          delete_pending_p = OpEN.new_uint32_tp()
          while True :
            ret = OpEN.openapiVlanNextChangedGet(self.m_client, vlan_num, vlan_num_p, delete_pending_p)
            if ret == OpEN.OPEN_E_NONE :
              vlan_num = OpEN.uint32_tp_value(vlan_num_p)
              delete_pending = OpEN.uint32_tp_value(delete_pending_p)
              if delete_pending != 0 :
                print("Deleting VLAN ID: %d" % vlan_num)
                self.m_vlan_table[vlan_num].vlan_exists = False
                self.m_vlan_table[vlan_num].staticVlan = False
              else :
                print("Change event received for VLAN ID: %d" % vlan_num)
                ret2 = OpEN.openapiVlanCreatedCheck(self.m_client, vlan_num)
                if ret2 == OpEN.OPEN_E_NONE :
                  self.m_vlan_table[vlan_num].vlan_exists = True
                  self.m_vlan_table[vlan_num].staticVlan = OpEN.openapiVlanIsStatic(self.m_client, vlan_num)
                else :
                  self.m_vlan_table[vlan_num].vlan_exists = False
                  self.m_vlan_table[vlan_num].staticVlan = False
              self.vlan_status_show()
            else :
              break
          OpEN.delete_uint32_tp(vlan_num_p)
          OpEN.delete_uint32_tp(delete_pending_p)

open = OpENUtil()
ret = open.connect("vlan_example")
if ret == OpEN.OPEN_E_NONE :
  open.getNetworkOSVersion()
  open.getAPIVersion()
  client = open.get_client()
  vlanExample = VlanExample(client)
  vlanExample.vlan_table_create()
  vlanExample.vlan_status_show()
  vlanExample.vlan_table_monitor(60)
  vlanExample.vlan_status_show()
  open.terminate()
else :
  print("Unable to connect")
  
