#
# Cookbook Name:: boa
# File:: providers/accounting.rb
#
# Copyright 2016 Broadcom.
#
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#

require "OpEN"
require "OpENUtil"

def whyrun_supported?
  true
end

action :create do
  converge_by("create accounting methond for '#{@new_resource.acct_type}'") do
    create_acct_type
  end
end

def load_current_resource
  Chef::Log.info "Loading current resource #{@new_resource.acct_type}"
  @current_resource = Chef::Resource::BoaAccounting.new(@new_resource.acct_type)
  @current_resource.acct_type(@new_resource.acct_type)
  @current_resource.methods(@new_resource.methods)
end

def create_acct_type

  my_local  = OpEN::OPEN_AUTHOR_METHOD_LOCAL
  my_none   = OpEN::OPEN_AUTHOR_METHOD_NONE
  my_radius = OpEN::OPEN_AUTHOR_METHOD_RADIUS
  my_tacacs = OpEN::OPEN_AUTHOR_METHOD_TACACS
  
  acct_type = OpEN::OPEN_ACCT_TYPE_EXEC_SESSION
  acct_name_buffdesc   = OpEN::Open_buffdesc.new
  acct_method_buffdesc = OpEN::Open_buffdesc.new

  if new_resource.acct_type == "exec"
    acct_type = OpEN::OPEN_ACCT_TYPE_EXEC_SESSION
  elsif new_resource.acct_type == "command"
    acct_type = OpEN::OPEN_ACCT_TYPE_COMMANDS
  end

  my_methods = @new_resource.methods
  open = OpENUtil.new()
  ret = open.connect("boa-accounting")
  if ret == OpEN::OPEN_E_NONE
    client = open.client
    my_methods.each {|acct_name, list| 
      if my_methods[acct_name].has_key? "methodType"
        my_method_type = my_methods[acct_name]['methodType']
        if my_method_type == "start-stop" || my_method_type == "stop-only" || my_method_type == "none"
          if my_method_type == "start-stop"
            method_type = OpEN::OPEN_ACCT_RECORD_TYPE_START_STOP
          elsif my_method_type == "stop-only"
            method_type = OpEN::OPEN_ACCT_RECORD_TYPE_STOP_ONLY
          elsif my_method_type == "none"
            method_type = OpEN::OPEN_ACCT_RECORD_TYPE_NONE
          end	
 
          #Create Accounting method list
          acct_name_buffdesc.size   = acct_name.length + 1
          acct_name_buffdesc.pstart = open.getCharBuffer(acct_name_buffdesc.size, acct_name)
          ret = OpEN::openapiAccountingListCreate(client, acct_type, method_type, acct_name_buffdesc)
          if ret == OpEN::OPEN_E_NONE || ret == OpEN::OPEN_E_EXISTS
            methods = list['methods']
            my_method_list = ""
            for my_method in methods
              case my_method
                when "local"
                  my_method_list = my_method_list + my_local.to_s()
                when "none"
                  my_method_list = my_method_list + my_none.to_s()
                when "radius"
                  my_method_list = my_method_list + my_radius.to_s()
                when "tacacs"
                  my_method_list = my_method_list + my_tacacs.to_s()
              end # end of case my_method
            end # end of for my_method in methods

            if my_method_list.length > 0
              acct_method_buffdesc.size   = my_method_list.length + 1
              acct_method_buffdesc.pstart = open.getCharBuffer(acct_method_buffdesc.size, my_method_list)

              #Add methods to accounting method list
              ret = OpEN::openapiAccountingMethodsAdd(client, acct_type, acct_name_buffdesc, acct_method_buffdesc)
              if ret == OpEN::OPEN_E_NONE
                line = list['line']
                line.each {|my_line|
                  case my_line
                    when "console"
                      access_line = OpEN::OPEN_ACCESS_LINE_CONSOLE
                    when "telnet"
                      access_line = OpEN::OPEN_ACCESS_LINE_TELNET
                    when "ssh"
                      access_line = OpEN::OPEN_ACCESS_LINE_SSH
                  end # end of case my_line
	
                  # Associate the accounting list to access line
                  ret = OpEN::openapiAccountingListLineSet(client, access_line, acct_type, acct_name_buffdesc)
                  if ret != OpEN::OPEN_E_NONE
                    Chef::Log.info "Failed to add line method '#{my_line} to '#{acct_name}', returned #{ret}" 
                  end
                }
              else
                Chef::Log.info "Failed to add methods to '#{acct_name}', returned #{ret}" 
              end
            else
              Chef::Log.info "Failed to add methods to '#{acct_name}', no methods specified"
            end
          else
            Chef::Log.info "Failed to create accounting method list '#{acct_name}', returned #{ret}"
          end
        else
          Chef::Log.info "Failed, unidentified method type defined '#{my_method_type}'" 
        end
      else
        Chef::Log.info "Failed to find method type, is not defined" 
      end
    }
  else
    Chef::Log.info "Failed to connect to 'boa-accounting'." 
  end 
  open.terminate()
end

