/*********************************************************************
*
* Copyright 2016-2018 Broadcom.
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*************************************************************************
*
* @filename  instru_packet_trace_example.c
*
* @purpose   Instrumentation - Packet Trace Example.
*
* @component OPEN
*
* @comments
*
* @create    1/27/2016
*
* @end
*
***************************************************************************/
#include <stdlib.h>
#include <stdbool.h>
#include <unistd.h>

#include "rpcclt_openapi.h"
#include "proc_util.h"
#include "openapi_common.h"
#include "openapi_tcam.h"
#include "openapi_instru_packet_trace.h"

/*******************************************************************
*
* @brief  This is the main function that will demonstrate 
*         Packet Trace OpEN APIs.
*
* @returns  0: Success
* @returns  1: Failure
*
********************************************************************/
int main(int argc, char **argv)
{
  openapiClientHandle_t clientHandle;
  open_error_t result = OPEN_E_FAIL;
  open_buffdesc switch_os_revision;
  char switch_os_revision_string[100];
  OPEN_PT_PACKET_t packetData;
  OPEN_PT_TRACE_PROFILE_t traceProfile;
  OPEN_TCAM_API_POLICYID_t requestId;
  OPEN_PORT_MASK_t portList;
  OPEN_PT_5_TUPLE_PARAMS_t tupleParams;
  time_t time;
  uint32_t asic = 0;
  uint32_t port = 1234;
  OPEN_TCAM_API_POLICYID_t policyHandle;
  l7proc_crashlog_register();

  /* Register with OpEN */
  if ((result = openapiClientRegister("instru_packet_trace_example", &clientHandle)) != OPEN_E_NONE)
  {
    printf("\nFailed to initialize RPC to OpEN. Exiting result = %d\n", result);
    exit(2);
  }

  /* RPC call can fail until server starts. Keep trying */
  while (openapiConnectivityCheck(&clientHandle) != OPEN_E_NONE)
  {
    sleep(1);
  }
  printf("\n");
  switch_os_revision.pstart = switch_os_revision_string;
  switch_os_revision.size = sizeof(switch_os_revision_string);
  if (openapiNetworkOSVersionGet(&clientHandle, &switch_os_revision) == OPEN_E_NONE)
  {
    printf("Network OS version = %s\n", switch_os_revision_string);
  }
  else
  {
    printf("Network OS version retrieve error\n");
  }
  printf("\n");

  if ((result = openapiPtTraceProfileGet(&clientHandle, asic, port, &packetData, &traceProfile, &time)) != OPEN_E_NONE)
  {
    printf("Bad return code trying to get trace profile. result = %d\n", result);
    return 1;
  }
  else
  {
    printf("Success to get trace profile\n");
  }

  if ((result = openapiPtTrace5TupleProfileCreate(&clientHandle, asic, requestId, 
	                                          &portList, &tupleParams, &policyHandle)) != OPEN_E_NONE)
  {
    printf("Bad return code while trying to create 5tuple. result = %d\n", result);
    return 1;
  }
  else
  {
    printf("Success 5tuple profile created\n");
  }

  if ((result = openapiPtTrace5TupleProfileDelete(&clientHandle, asic, &requestId)) != OPEN_E_NONE)
  {
    printf("Bad return code trying to delete 5tuple profile. requestId= %d, result = %d\n", requestId, result);
    return 1;
  }
  else
  {
    printf("Success in deleting 5tuple profile\n");
  }

  /* Log goodbye message with OPEN */
  L7PROC_LOGF(L7PROC_LOG_SEVERITY_INFO, 0, "Stopping Packet Trace API example application");

  (void) openapiClientTearDown(&clientHandle);
  return 0;
}

