import OpEN_py
from OpENUtil import *
from sys import version_info

#
# Copyright 2016-2018 Broadcom.
#

open_ = OpENUtil()

#
# Python 2.6.6
#

ctrStr = [];
ctrStr.append("OPEN_CTR_RESERVED");
ctrStr.append("OPEN_CTR_RX_TOTAL_BYTES");
ctrStr.append("OPEN_CTR_RX_64");
ctrStr.append("OPEN_CTR_RX_65_127");
ctrStr.append("OPEN_CTR_RX_128_255");
ctrStr.append("OPEN_CTR_RX_256_511");
ctrStr.append("OPEN_CTR_RX_512_1023");
ctrStr.append("OPEN_CTR_RX_1024_1518");
ctrStr.append("OPEN_CTR_RX_1519_1530");
ctrStr.append("OPEN_CTR_RX_GOOD_OVERSIZE");
ctrStr.append("OPEN_CTR_RX_ERROR_OVERSIZE");
ctrStr.append("OPEN_CTR_RX_GOOD_UNDERSIZE");
ctrStr.append("OPEN_CTR_RX_ERROR_UNDERSIZE");
ctrStr.append("OPEN_CTR_RX_UCAST_FRAMES");
ctrStr.append("OPEN_CTR_RX_MCAST_FRAMES");
ctrStr.append("OPEN_CTR_RX_BCAST_FRAMES");
ctrStr.append("OPEN_CTR_RX_ALIGN_ERRORS");
ctrStr.append("OPEN_CTR_RX_FCS_ERRORS");
ctrStr.append("OPEN_CTR_RX_OVERRUNS");
ctrStr.append("OPEN_CTR_RX_FRAME_TOO_LONG");
ctrStr.append("OPEN_CTR_TX_TOTAL_BYTES");
ctrStr.append("OPEN_CTR_TX_64");
ctrStr.append("OPEN_CTR_TX_65_127");
ctrStr.append("OPEN_CTR_TX_128_255");
ctrStr.append("OPEN_CTR_TX_256_511");
ctrStr.append("OPEN_CTR_TX_512_1023");
ctrStr.append("OPEN_CTR_TX_1024_1518");
ctrStr.append("OPEN_CTR_TX_1519_1530");
ctrStr.append("OPEN_CTR_TX_UCAST_FRAMES");
ctrStr.append("OPEN_CTR_TX_MCAST_FRAMES");
ctrStr.append("OPEN_CTR_TX_BCAST_FRAMES");
ctrStr.append("OPEN_CTR_TX_FCS_ERRORS");
ctrStr.append("OPEN_CTR_TX_OVERSIZED");
ctrStr.append("OPEN_CTR_TX_UNDERRUN_ERRORS");
ctrStr.append("OPEN_CTR_TX_ONE_COLLISION");
ctrStr.append("OPEN_CTR_TX_MULTIPLE_COLLISION");
ctrStr.append("OPEN_CTR_TX_EXCESSIVE_COLLISION");
ctrStr.append("OPEN_CTR_TX_LATE_COLLISION");
ctrStr.append("OPEN_CTR_TX_RX_64");
ctrStr.append("OPEN_CTR_TX_RX_65_127");
ctrStr.append("OPEN_CTR_TX_RX_128_255");
ctrStr.append("OPEN_CTR_TX_RX_256_511");
ctrStr.append("OPEN_CTR_TX_RX_512_1023");
ctrStr.append("OPEN_CTR_TX_RX_1024_1518");
ctrStr.append("OPEN_CTR_TX_RX_1519_1522");
ctrStr.append("OPEN_CTR_TX_RX_1523_2047");
ctrStr.append("OPEN_CTR_TX_RX_2048_4095");
ctrStr.append("OPEN_CTR_TX_RX_4096_9216");
ctrStr.append("OPEN_CTR_ETHER_STATS_DROP_EVENTS");
ctrStr.append("OPEN_CTR_SNMPIFOUTDISCARD_FRAMES");
ctrStr.append("OPEN_CTR_SNMPIFINDISCARD_FRAMES");
ctrStr.append("OPEN_CTR_RX_TOTAL_FRAMES");
ctrStr.append("OPEN_CTR_RX_TOTAL_ERROR_FRAMES");
ctrStr.append("OPEN_CTR_TX_TOTAL_FRAMES");
ctrStr.append("OPEN_CTR_TX_TOTAL_ERROR_FRAMES");
ctrStr.append("OPEN_CTR_TX_TOTAL_COLLISION_FRAMES");
ctrStr.append("OPEN_CTR_RX_CRC_ERRORS");
ctrStr.append("OPEN_CTR_RX_TOTAL_MAC_ERROR_FRAMES");
ctrStr.append("OPEN_CTR_RX_RATE_BITS");
ctrStr.append("OPEN_CTR_TX_RATE_BITS");
ctrStr.append("OPEN_CTR_RX_RATE_FRAMES");
ctrStr.append("OPEN_CTR_TX_RATE_FRAMES");
ctrStr.append("OPEN_CTR_ETHER_STATS_HOLD");
ctrStr.append("OPEN_CTR_RX_JABBER_FRAMES");
ctrStr.append("OPEN_CTR_PORT_LINK_DOWN_COUNTER");


class InterfaceExample :
  def __init__(self, client) :
    self.m_client = client
      
  def interface_table_show(self):
        

   print("ifNum  Interface                      Interface      OPEN_CTR_RX_TOTAL_ERROR_FRAMES                   ")
   print("         Name                           State                   Value   ")
   print("-----  ----------------------------   ----------    ---------------------------------")

   for ifType in [OpEN.OPEN_INTF_TYPE_PHY, OpEN.OPEN_INTF_TYPE_LAG, OpEN.OPEN_INTF_TYPE_CPU, OpEN.OPEN_INTF_TYPE_SERVICE_PORT] :
     ifNum_p = OpEN.new_uint32_tp();
     ret = OpEN.openapiIfFirstGet(self.m_client, ifType, ifNum_p);
     while ret == OpEN.OPEN_E_NONE :
       intf_num = OpEN.uint32_tp_value(ifNum_p);
      
       print("  %3d" % intf_num, end=" ")
       try:
         linkNameBuff_string = open_.getStringBuffer(OpEN.OPENAPI_INTERFACE_NAME_LENGTH) 
       except OpENBufferSizeError:
         print("interface_table_show: getStringBuffer raised OpENBufferSizeError")
         return
       except TypeError:
         print("interface_table_show: getStringBuffer raised TypeError")
         return
       linkNameBuff = OpEN.open_buffdesc();
       linkNameBuff.pstart = linkNameBuff_string;
       linkNameBuff.size = OpEN.OPENAPI_INTERFACE_NAME_LENGTH 
       ret = OpEN.openapiIfNameGet(self.m_client, intf_num, linkNameBuff);
       print("%25s" % linkNameBuff_string.cast())
       linkState_p = OpEN.new_OPEN_LINK_STATE_tp();
       OpEN.openapiIfLinkStateGet(self.m_client, intf_num, linkState_p);
       linkState = OpEN.OPEN_LINK_STATE_tp_value(linkState_p);
       #print("link State : %d\n" % linkState)
       if  linkState == 0 :
         print("%12s" %"Up", end=" ")
       if  linkState == 1 :
         print("%12s" %"Down", end=" ")
       ctrValue = 0;
       ctrValue_p = OpEN.new_uint64_tp();
       counterId = 51; 
       ret = OpEN.openapiStatGet(self.m_client, counterId, intf_num, ctrValue_p);
       ctrValue = OpEN.uint64_tp_value(ctrValue_p);
       print("          0x%016x" % ctrValue)
       ret =  OpEN.openapiIfNextGet(self.m_client, ifType, intf_num, ifNum_p);
     print("")

   ifType = OpEN.OPEN_INTF_TYPE_PHY;
   ifNum_p = OpEN.new_uint32_tp();
   ret = OpEN.openapiIfFirstGet(self.m_client, ifType, ifNum_p);
   intf_num = OpEN.uint32_tp_value(ifNum_p);
   if ret ==  OpEN.OPEN_E_NONE :
     try:
       linkNameBuff_string = open_.getStringBuffer(OpEN.OPENAPI_INTERFACE_NAME_LENGTH) 
     except OpENBufferSizeError:
       print("interface_table_show: getStringBuffer raised OpENBufferSizeError")
       return
     except TypeError:
       print("interface_table_show: getStringBuffer raised TypeError")
       return
     linkNameBuff = OpEN.open_buffdesc();
     linkNameBuff.pstart = linkNameBuff_string;
     linkNameBuff.size = OpEN.OPENAPI_INTERFACE_NAME_LENGTH 
     ret= OpEN.openapiIfNameGet(self.m_client, intf_num, linkNameBuff);
     if ret == OpEN.OPEN_E_NONE :
        print("Displaying statistics of %s" % linkNameBuff_string.cast())
     else :
        print("link name retrieval error")
     print("")
     if version_info >= (3,0,0):
       for i in range(1, 65):
         ctrValue = 0;
         ctrValue_p = OpEN.new_uint64_tp();
         ret = OpEN.openapiStatGet(self.m_client, i, intf_num, ctrValue_p);
         ctrValue = OpEN.uint64_tp_value(ctrValue_p);
         print(" %s = " % ctrStr[i-1], end=" ")
         if ret == OpEN.OPEN_E_NONE :
           print("0x%016x" % ctrValue)
         elif ret == OpEN.OPEN_E_NOT_FOUND:
           print("Counter unavailable")
         else :
           print("Counter get failed (ret = %d)\n" % ret)
     else:
       for i in xrange(1, 65):
         ctrValue = 0;
         ctrValue_p = OpEN.new_uint64_tp();
         ret = OpEN.openapiStatGet(self.m_client, i, intf_num, ctrValue_p);
         ctrValue = OpEN.uint64_tp_value(ctrValue_p);
         print(" %s = " % ctrStr[i-1], end=" ")
         if ret == OpEN.OPEN_E_NONE :
           print("0x%016x" % ctrValue)
         elif ret == OpEN.OPEN_E_NOT_FOUND:
           print("Counter unavailable")
         else :
           print("Counter get failed (ret = %d)\n" % ret)
    
     print("")
     print("Resetting OPEN_CTR_RX_TOTAL_BYTES on an interface.")
     rc = OpEN.openapiStatReset(self.m_client, OpEN.OPEN_CTR_RX_TOTAL_BYTES, intf_num);
     if rc == OpEN.OPEN_E_NONE :
       print("Statistics reset successfully on interface %d." % intf_num)
     elif rc == OpEN.OPEN_E_FAIL :
       print("Failed to reset statistics on interface %d." % intf_num)
     elif rc == OpEN.OPEN_E_NOT_FOUND :
       print("Error resetting stats.")
     else :
       print("Internal error.")

   OpEN.delete_uint32_tp(ifNum_p);
   OpEN.delete_OPEN_LINK_STATE_tp(linkState_p);
   OpEN.delete_uint64_tp(ctrValue_p);

ret = open_.connect("stats_example")
if ret == OpEN.OPEN_E_NONE :
  open_.getNetworkOSVersion()
  client = open_.get_client()
  InterfaceExample = InterfaceExample(client)
  InterfaceExample.interface_table_show()
  open_.terminate()
else :
  print("Unable to connect")
