
require "OpEN"
require "OpENUtil"


#
# Copyright 2016 Broadcom.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#


#
# Ruby 1.8.7.
#

class Vlan

  def initialize()
    @vlan_exists = false
    @staticVlan = false
  end

  attr_accessor :vlan_exists
  attr_accessor :staticVlan
end

class VlanExample
  def initialize(client)
    @client = client
    @vlan_table = []
  end

  def vlan_status_show()
    printf "\n\nThe following VLAN IDs are in the switch's VLAN database:\n"
    size = 4096
    for i in 0..size - 1
      if @vlan_table[i].vlan_exists == true
        printf "VLAN: %d is ", i
        if @vlan_table[i].staticVlan == true
          puts "Static"
        else
          puts "Dynamic"
        end
      end
    end
  end

  def vlan_table_validate()
    size = 4096;
    for vlan_num in 0..size - 1
      if @vlan_table[vlan_num].exists == true
        ret = OpEN::openapiVlanCreatedCheck(@client, vlan_num)
        if ret == OPEN_E_NONE
		  vlan_is_static = OpEN::openapiVlanIsStatic(@client, vlan_num)
		  if vlan_is_static == 1
		    @vlan_table[vlan_num].staticVlan = true
		  else
		    @vlan_table[vlan_num].staticVlan = false
		  end
        else
          @vlan_table[vlan_num].vlan_exists = false;
          @vlan_table[vlan_num].staticVlan = false;
        end
      end
    end
  end

  def vlan_table_create()
    size = 4096
    @vlan_table = []

      open_event = OpEN::OpenapiEventList_t.new
      OpEN::openapiEventListClear(open_event)
      OpEN::openapiEventSet(open_event, OpEN::OPEN_EVENT_VLAN)

      ret = OpEN::openapiEventRegister(@client, open_event)
      if ret != OpEN::OPEN_E_NONE 
        puts "Failed to register for OPEN_EVENT_VLAN events."
      else
        puts "Successfully registered for OPEN_EVENT_VLAN events."

        size -= 1
        for vlan_num in 0..size 
          vlan = Vlan.new
          ret = OpEN::openapiVlanCreatedCheck(@client, vlan_num)
          if ret == OpEN::OPEN_E_NONE 
            vlan.vlan_exists = true
			vlan_is_static = OpEN::openapiVlanIsStatic(@client, vlan_num)
			if vlan_is_static == 1
			  vlan.staticVlan = true
			else
			  vlan.staticVlan = false
			end
          else
            vlan.vlan_exists = false
            vlan.staticVlan = false
          end
          @vlan_table << vlan
        end

        vlan_num = 1
        begin
          @vlan_table[vlan_num].vlan_exists = true
		  vlan_is_static = OpEN::openapiVlanIsStatic(@client, vlan_num)
		  if vlan_is_static == 1
		    @vlan_table[vlan_num].staticVlan = true
		  else
		    @vlan_table[vlan_num].staticVlan = false
		  end
          vlan_num_p = OpEN.new_uint32_tp()
          ret, vlan_num = OpEN::openapiVlanNextGet(@client, vlan_num, vlan_num_p)
          vlan_num = OpEN.uint32_tp_value(vlan_num_p)
          OpEN.delete_uint32_tp(vlan_num_p)
        end while ret == OpEN::OPEN_E_NONE
      end
  end

  def vlan_table_monitor(duration)
    change_pending_event = OpEN::OpenapiEventList_t.new
    OpEN::openapiEventListClear(change_pending_event)
    purge_event = OpEN::OpenapiEventList_t.new
    OpEN::openapiEventListClear(purge_event)

    end_time = Time.new.to_i + duration
    notify_fd = OpEN.openapiClientNotifySocketFDGet(@client)
    if notify_fd == 0
      puts "Invalid notify_fd retrieved"
    else
      printf "notify_fd is %d\n", notify_fd
      io = IO.new(notify_fd, "r")
      rd_fds = []
      rd_fds << io
    while Time.new.to_i < end_time
      result = IO.select(rd_fds, nil, nil, 5)
      if result != nil && result[0] != nil && (result[0].include? rd_fds[0])
        begin
          data = io.read_nonblock(1024)
        end while false
        ret = OpEN::openapiPendingEventsGet(@client, 
                                              change_pending_event.open_event,
                                              purge_event.open_event)
        if ret == OpEN::OPEN_E_NONE 
          if purge_event.is_set(OpEN::OPEN_EVENT_VLAN) == true
            puts "Got Purge event for OPEN_EVENT_VLAN"
            vlan_table_validate()
          end
          if change_pending_event.is_set(OpEN::OPEN_EVENT_VLAN) == true
            puts "Got Change Pending event for OPEN_EVENT_VLAN"
          end
        end

        vlan_num = 0
        vlan_num_p = OpEN.new_uint32_tp()
        delete_pending_p = OpEN.new_uint32_tp()
        begin
          ret, vlan_num, delete_pending = OpEN::openapiVlanNextChangedGet(@client, vlan_num, vlan_num_p, delete_pending_p)
          if ret == OpEN::OPEN_E_NONE
            vlan_num = OpEN.uint32_tp_value(vlan_num_p)
            delete_pending = OpEN.uint32_tp_value(delete_pending_p)
            if delete_pending != 0
              printf "Deleting VLAN ID: %d\n", vlan_num
              @vlan_table[vlan_num].vlan_exists = false
              @vlan_table[vlan_num].staticVlan = false
            else
              printf "Change event received for VLAN ID: %d\n", vlan_num
              ret2 = OpEN::openapiVlanCreatedCheck(@client, vlan_num)
              if ret2 == OpEN::OPEN_E_NONE
                @vlan_table[vlan_num].vlan_exists = true
		        vlan_is_static = OpEN::openapiVlanIsStatic(@client, vlan_num)
		        if vlan_is_static == 1
		          @vlan_table[vlan_num].staticVlan = true
		        else
		          @vlan_table[vlan_num].staticVlan = false
				end
              else
                @vlan_table[vlan_num].vlan_exists = false
                @vlan_table[vlan_num].staticVlan = false
              end
            end
            vlan_status_show()
          end
        end while ret == OpEN::OPEN_E_NONE
        OpEN.delete_uint32_tp(vlan_num_p)
        OpEN.delete_uint32_tp(delete_pending_p)
      end
    end
    end
  end
end

  open = OpENUtil.new()
  ret = open.connect("vlan_example")
  if ret == OpEN::OPEN_E_NONE
    open.getNetworkOSVersion()
    open.getAPIVersion()
    client = open.client
    vlanExample = VlanExample.new(client)
    vlanExample.vlan_table_create()
    vlanExample.vlan_status_show()
    vlanExample.vlan_table_monitor(60)
    vlanExample.vlan_status_show()
    open.terminate()
  else
    print "Unable to connect"
  end
  
