/*********************************************************************
*
* Copyright 2016-2017 Broadcom.
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
**********************************************************************
*
* @filename openapi_fip_snooping.h
*
* @purpose  Provide an API to interface with the FIP Snooping component
*
* @component Datacenter
*
* @create   09/01/2012
*
* @end
*
**********************************************************************/
#ifndef OPENAPI_FIPSNOOPING_H_INCLUDED
#define OPENAPI_FIPSNOOPING_H_INCLUDED
 
#include "openapi_common.h"
/*  Flags to specify what type of TLVs to send */
#define OPEN_FIP_SEND_TLV_NONE 0 /**< Disable TLV */
#define OPEN_FIP_SEND_TLV_FIP  1 /**< Enable the standard FIP TLV */
#define OPEN_FIP_SEND_TLV_FCOE 2 /**< Enable the standard FCoE TLV */
 
/**************************************************************************
* @purpose  Override the FIP Snooping behavior to force it to send the TLVs
*
* @param   forceMode      {(input)}  Enable or disable the mode.
*                                    If enabled the FIP Snooping will send TLVs
*                                    out on ports even if it is disabled.
* @param   sendFlags      {(input)}  A bitmap of flags specifying the TLVs to transmit.
* @param   priority       {(input)}  An integer value between 1-8 specifies
*                                    the priority of the TLVs.
*                                    Applies to all types of TLVs
*                                   
*
* @returns  OPEN_E_NONE: API initialized successfully
* @returns  OPEN_E_FAIL: Error encountered in TCAM API initialization
*
* @comments  none
* 
* @supported-in-version OpEN API Version: 1.2
*
* @end
*************************************************************************/
open_error_t openapiFipSnoopingForceModeSet(OPEN_CONTROL_t forceMode,
                                            uint32_t sendFlags,
                                            uint8_t priority);

#endif /* OPENAPI_FIPSNOOPING_H_INCLUDED*/
