/**********************************************************************
*
* Copyright 2016-2018 Broadcom.
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
***********************************************************************
*
* @filename  openapi_hash.h
*
* @purpose   Hash Prediction 
*
* @component OpEN
*
* @create    10/17/2014
*
* @end
*
*********************************************************************/
#ifndef OPENAPI_HASH_H_INCLUDED
#define OPENAPI_HASH_H_INCLUDED

#include "openapi_common.h"
#include "openapi_mpls.h"

typedef enum
{
   OPEN_AGGR_TYPE_ECMP = 0,
   OPEN_AGGR_TYPE_LAG = 1     
} OPEN_AGGR_TYPE_t;

typedef struct open_hash_egress_obj_s
{
   union
   {
      uint32_t lagId;                          
      open_inet_pfx_t ecmpId;      
   } aggrId;
} open_hash_egress_obj_t;

typedef struct open_hashPktInfo_s
{
    OPEN_AGGR_TYPE_t aggrType;                    
    open_hash_egress_obj_t egressId;                 
    open_USP_t inUsp;                             
    unsigned char src_mac[OPEN_MAC_ADDR_LEN];         
    unsigned char dst_mac[OPEN_MAC_ADDR_LEN];	       
    uint32_t vid;            		        
    uint32_t ethertype;  			
    uint32_t srcIp;               		
    uint32_t destIp;               		
    open_in6_addr_t srcIp6;             		
    open_in6_addr_t destIp6;             		
    uint32_t protocol;             		
    uint32_t srcL4Port;         		
    uint32_t dstL4Port;         		
} open_hashPktInfo_t;

/*********************************************************************
* @purpose  Get the unit, slot and port of the interface.
*
* @param    client_handle @b{(input)}   client handle from registration API
* @param    intf          @b{(input)}   the network interface
* @param    usp           @b{(output)}  unit/slot/port of the interface
*
* @returns  OPEN_E_NONE on success
* @returns  OPEN_E_PARAM on improper input parameters
* @returns  OPEN_E_FAIL on other failure
*
* @notes
*
* @supported-in-version OpEN API Version: 1.4
*
* @end
*********************************************************************/
open_error_t openapiHashIntfUnitSlotPortGet(openapiClientHandle_t *client_handle,
                                            uint32_t intf, open_USP_t *usp);

/*********************************************************************
* @purpose  Get the destination physical port for the given packet and
*           configuration information.
*
* @param    packetInfo    incoming packet information 
* @param    usp           unit/slot/port of the out going interface
* @param    mpls_label    For MPLS-tagged routes this is the MPLS label stack.
*
* @returns  OPEN_E_NONE         Get successful.
* @returns  OPEN_E_FAIL         Get failed.
* @returns  OPEN_E_PARAM        Error in parameter passed.
*
* @notes   
* 
* @supported-in-version OpEN API Version: 1.4
*
* @end
*
*********************************************************************/
open_error_t openapiHashDestGet(open_hashPktInfo_t *packetInfo, 
                                open_USP_t *usp,
                                OPEN_MPLS_LABELS_t *mpls_label);

#endif /* OPENAPI_HASH_H_INCLUDED */
