#
# Cookbook Name:: boa
# File:: providers/authentication.rb
#
# Copyright 2016 Broadcom.
#
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#

require "OpEN"
require "OpENUtil"

def whyrun_supported?
  true
end

action :create do
  converge_by("create authentication method list for '#{@new_resource.auth_type}'") do
    create_auth_type
  end
end

def load_current_resource
  Chef::Log.info "Loading current resource #{@new_resource.auth_type}"
  @current_resource = Chef::Resource::BoaAuthentication.new(@new_resource.auth_type)
  @current_resource.auth_type(@new_resource.auth_type)
  @current_resource.methods(@new_resource.methods)
end

def create_auth_type

  if new_resource.auth_type == "login"
    access_level = OpEN::OPEN_ACCESS_LEVEL_LOGIN
  elsif new_resource.auth_type == "enable"
    access_level = OpEN::OPEN_ACCESS_LEVEL_ENABLE
  end

  methods = @new_resource.methods
  open = OpENUtil.new()
  ret = open.connect("boa-authentication")
  if ret == OpEN::OPEN_E_NONE
    client = open.client
    methods.each {|auth_name, list|
      auth_name_buffdesc        = OpEN::Open_buffdesc.new
      auth_name_buffdesc.size   = auth_name.length + 1
      auth_name_buffdesc.pstart = open.getCharBuffer(auth_name_buffdesc.size,auth_name)

      # Create authentication method list
      ret = OpEN::openapiAuthenticationListCreate(client,access_level,auth_name_buffdesc)
      if ret == OpEN::OPEN_E_NONE || ret == OpEN::OPEN_E_EXISTS
        my_enable = OpEN::OPEN_AUTH_METHOD_ENABLE
        my_line   = OpEN::OPEN_AUTH_METHOD_LINE
        my_local  = OpEN::OPEN_AUTH_METHOD_LOCAL
        my_none   = OpEN::OPEN_AUTH_METHOD_NONE
        my_radius = OpEN::OPEN_AUTH_METHOD_RADIUS
        my_tacacs = OpEN::OPEN_AUTH_METHOD_TACACS

        methods = list['methods']

        my_method_list = ""
        for my_method in methods
          case my_method
            when "enable"
              my_method_list = my_method_list + my_enable.to_s()
            when "line"
              my_method_list = my_method_list + my_line.to_s()
            when "local"
              my_method_list = my_method_list + my_local.to_s()
            when "none"
              my_method_list = my_method_list + my_none.to_s()
            when "radius"
              my_method_list = my_method_list + my_radius.to_s()
            when "tacacs"
              my_method_list = my_method_list + my_tacacs.to_s()
          end # end of case my_method
        end # end of for my_method in methods
        
        if my_method_list.length > 0 
          auth_method_buffdesc        = OpEN::Open_buffdesc.new
          auth_method_buffdesc.size   = my_method_list.length + 1
          auth_method_buffdesc.pstart = open.getCharBuffer(auth_method_buffdesc.size, my_method_list)
        
          # Add methods to authentication method list
          ret = OpEN::openapiAuthenticationMethodsAdd(client, access_level, auth_name_buffdesc, auth_method_buffdesc)
          if ret != OpEN::OPEN_E_NONE
            Chef::Log.info "Failed to create authentication method list '#{auth_name}', returned #{ret}."
          else
            line = list['line']
            line.each {|this_line|
              case this_line
                when "console"
                  access_line = OpEN::OPEN_ACCESS_LINE_CONSOLE
                when "telnet"
                  access_line = OpEN::OPEN_ACCESS_LINE_TELNET
                when "ssh"
                  access_line = OpEN::OPEN_ACCESS_LINE_SSH
                else
                  access_line = OpEN::OPEN_ACCESS_LINE_CONSOLE
              end # end of case my_line
          	
              # Associate the authentication list to access line
              ret = OpEN::openapiAuthenticationListLineSet(client, access_line, access_level, auth_name_buffdesc)
              if ret != OpEN::OPEN_E_NONE
                Chef::Log.info "Failed to create authentication method list '#{auth_name}', returned #{ret}."
              end
            }
          end
        else
          Chef::Log.info "Failed to add methods to '#{auth_name}', no methods specified"
        end
      else
        Chef::Log.info "Failed to create authentication method list '#{auth_name}', returned #{ret}."
      end
    }
  else
    Chef::Log.info "Failed to connect to 'boa-authentication'." 
  end 
  open.terminate()
end

