#
# Cookbook Name:: boa
# Recipe:: authentication
#
# Copyright 2016 Broadcom.
#
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#

hostname = node[:hostname]
Chef::Log.info "My hostname is #{hostname}"

boa_authentication_provider = node[:boa][:providers][:authentication]

authentication = node['authentication']

if !authentication.nil?
  authentication.each do |auth_type, attribs|
    if auth_type == 'login' ||  auth_type == 'enable'
      boa_authentication auth_type do
        provider boa_authentication_provider
        methods node['authentication'][auth_type]
        action [:create]
      end
    else
      Chef::Log.info("Failed to configure, unidentified auth_type: '#{auth_type}' found")
    end
  end
end

