#
# Cookbook Name:: boa
# Recipe:: vlan
#
# Copyright 2016 Broadcom.
#
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#

hostname = node[:hostname]
Chef::Log.info "My hostname is #{hostname}"

boa_vlan_provider = node[:boa][:providers][:vlan]
Chef::Log.info "My provider is #{boa_vlan_provider}"

vlans = node['vlans']

if !vlans.nil?
  vlans.each do |name, attribs|
    Chef::Log.info "Processing vlan #{name}"

    if attribs['state'] == 'absent'
      boa_vlans name do
        provider boa_vlan_provider
        vlan_id attribs['vlan_id'].to_i
        action [:delete]
      end

    else
      boa_vlans name do
        provider boa_vlan_provider
        vlan_id attribs['vlan_id'].to_i
        participate attribs['participate']
        action [:create, :add_participation]
      end
    end

  end
end

