name             'netdev_icos'
maintainer       'Broadcom'
maintainer_email 'support@broadcom.com'
license          'Apache v2.0'
description      'Implements a NOS specific provider for netdev resources'
long_description IO.read(File.join(File.dirname(__FILE__), 'README.md'))
version          '0.1.1'

depends "netdev"

recipe "interface",
  "Manages physical interface resources on NOS based devices"
  
recipe "vlan",
  "Manages vlan resources on NOS based devices"

recipe "l2_interface",
  "Manages switchport resources on NOS based devices"
  
recipe "lag",
  "Manages lag (port-channel) resources on NOS based devices"

attribute 'netdev_config/databag_name',
  :display_name => 'Data Bag Name',
  :description => 'The name of the data bag to use for finding settings',
  :type => 'string',
  :required => 'required',
  :recipes => [ 'netdev_icos::vlan', 'netdev_icos::interface', 'netdev_icos::l2_interface', 'netdev_icos::lag' ],
  :default => 'netdev_config'
    
attribute 'netdev_config/providers/netdev_interface',
  :display_name => "Provider for netdev_interface LWRP",
  :description => "Sets the netdev_interface provider to use for implementing the LWRP",
  :type => "string",
  :required => "required",
  :recipes => [ 'netdev_icos::interface' ],
  :default => 'netdev_icos_interface'
  
attribute 'netdev_config/providers/netdev_vlan',
  :display_name => "Provider for netdev_vlan LWRP",
  :description => "Sets the netdev_vlan provider to use for implementing the LWRP",
  :type => "string",
  :required => "required",
  :recipes => [ 'netdev_icos::vlan' ],
  :default => 'netdev_icos_vlan'
    
attribute 'netdev_config/providers/netdev_l2_interface',
  :display_name => "Provider for netdev_l2_interface LWRP",
  :description => "Sets the netdev_l2_interface provider to use for implementing the LWRP",
  :type => "string",
  :required => "required",
  :recipes => [ 'netdev_icos::l2_interface' ],
  :default => 'netdev_icos_l2_interface'
      
attribute 'netdev_config/providers/netdev_lag',
  :display_name => "Provider for netdev_lag LWRP",
  :description => "Sets the netdev_lag provider to use for implementing the LWRP",
  :type => "string",
  :required => "required",
  :recipes => [ 'netdev_icos::lag' ],
  :default => 'netdev_icos_lag'
  
