import OpEN_py as OpEN
from OpENUtil import *
import sys

open_ = OpENUtil()

#
# Copyright 2016 Broadcom.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#


#
# Python 2.6.6
#


class FdbExample :
  def __init__(self, client):
    self.clientHandle = client
    self.m_valn_table = []

  def main(self):
    try:
      buf = open_.getByteBuffer(100, '')
    except TypeError:
      print("received a TypeError exception from getByteBuffer")
      sys.exit(1)
    except OpENBufferSizeError:
      print("received an OpENBufferSizeError exception")
      sys.exit(1)
      
    mac = OpEN.open_buffdesc()
    mac.pstart = buf
    mac.size = 100

    vlanId = OpEN.new_uint32_tp()
    OpEN.uint32_tp_assign(vlanId, 1)

    fdbIfNum = OpEN.new_uint32_tp()
    OpEN.uint32_tp_assign(fdbIfNum, 1)

    fdbEntryType = OpEN.new_OPEN_FDB_ADDR_FLAG_tp()
    fdbEntryType = OpEN.copy_OPEN_FDB_ADDR_FLAG_tp(OpEN.OPEN_FDB_ADDR_FLAG_STATIC)

    fdbId = OpEN.new_uint32_tp()
    value = OpEN.new_uint32_tp()
    vlType = OpEN.new_OPEN_VL_TYPE_tp()
    vlType = OpEN.copy_OPEN_VL_TYPE_tp(OpEN.OPEN_IVL_TYPE)

    open_event = OpEN.openapiEventList_t()
    OpEN.openapiEventListClear(open_event)

    result = OpEN.openapiEventRegister(self.clientHandle, open_event)
    if result != OpEN.OPEN_E_NONE:
      print "Failed to register for OPEN_EVENT_FDB events.\n"
      return
    else:
      print "Successfully registered for OPEN_EVENT_FDB events.\n"

    while True:

      ''' Testing of the retrieving the first entry from the forwarding database '''
      result = OpEN.openapiFdbEntryNextGet(self.clientHandle, mac, vlanId, fdbIfNum, fdbEntryType)
      if result != OpEN.OPEN_E_NONE:
        print "Failed to get the first entry from the forwarding database (Result = %d)\n" % result
        break
      else:
        print "Success: Get the first entry from the forwarding database with MAC: %s\n" % buf.cast()

        ''' Testing of the retrieving the next entry from the forwarding database '''
        result = OpEN.openapiFdbEntryNextGet(self.clientHandle, mac, vlanId, fdbIfNum, fdbEntryType)
        if result != OpEN.OPEN_E_NONE:
          if OpEN.OPEN_E_NOT_FOUND != result:
            print "Failed to get the next entry from the forwarding database (Result = %d)\n" % result
            break
          print "Success: Cannot get the next entry from the forwarding database - entry not found (Result = %d)\n" % result
        else:
          print "Success: Get the next entry from the forwarding database with MAC: %s\n" % buf.cast()

      ''' Testing of the verification is a FDB with the specified ID exists '''
      result = OpEN.openapiFdbIdGet(self.clientHandle, OpEN.uint32_tp_value(fdbId))
      if OpEN.OPEN_E_NONE == result:
        print "Success: FDB with ID %d exists.\n" % OpEN.uint32_tp_value(fdbId)
      elif OpEN.OPEN_E_NOT_FOUND == result:
        print "Success: FDB with ID %d is not exists.\n" % OpEN.uint32_tp_value(fdbId)
      else:
        print "Failed to verify is FDB with ID %d exists. (Result = %d)\n" % (OpEN.uint32_tp_value(fdbId), result)
        break

      ''' Testing Fdb Address Aging Timeout - only if FDB exists '''
      if OpEN.OPEN_E_NONE == result:
        result = OpEN.openapiFdbAddrAgingTimeoutGet(self.clientHandle, OpEN.uint32_tp_value(fdbId), value)
        if OpEN.OPEN_E_NONE == result:
          print "Success: Fdb Address Aging Timeout is %d.\n" % (OpEN.uint32_tp_value(value))
        else:
          print "Failed to get Fdb Address Aging Timeout for FDB with ID %d. (Result = %d)\n" % (OpEN.uint32_tp_value(fdbId), result)

        ''' Testing of the Set Fdb Address Aging Timeout '''
        OpEN.uint32_tp_assign(value, OpEN.uint32_tp_value(value) + 1)
        OpEN.uint32_tp_assign(value, OpEN.uint32_tp_value(value) + 1)
        result = OpEN.openapiFdbAddrAgingTimeoutSet(self.clientHandle, OpEN.uint32_tp_value(fdbId), value)
        if OpEN.OPEN_E_NONE == result:
          print "Success: Set Fdb Address Aging Timeout value: %d.\n" % (OpEN.uint32_tp_value(value))
        else:
          print "Failed to set Fdb Address Aging Timeout value: %d. (Result = %d)\n" % (OpEN.uint32_tp_value(value), result)

      ''' Testing maximum number of entries that the FDB table can hold '''
      result = OpEN.openapiFdbMaxTableEntriesGet(self.clientHandle, value)
      if OpEN.OPEN_E_NONE == result:
        print "Success: The maximum number of FDB entries supported on the platform: %d.\n" % (OpEN.uint32_tp_value(value))
      else:
        print "Failed to get maximum number of FDB entries supported on the platform. (Result = %d)\n" % (result)

      ''' Testing of current number of entries in the FDB table '''
      result = OpEN.openapiActiveAddrEntriesGet(self.clientHandle, value)
      if OpEN.OPEN_E_NONE == result:
        print "Success: The current number of FDB entries: %d.\n" % (value)
      else:
        print "Failed to get the current number of FDB entries. (Result = %d)\n" % (result)

      ''' Testing of count maximum number of entries in the FDB table '''
      result = OpEN.openapiFdbMaxCountGet(self.clientHandle, value)
      if OpEN.OPEN_E_NONE == result:
        print "Success: The count maximum number of FDB entries: %d.\n" % (value)
      else:
        print "Failed to get the count maximum number of FDB entries. (Result = %d)\n" % (result)

      ''' Testing the reset of the greatest number of entries in the FDB table '''
      result = OpEN.openapiMaxCountReset(self.clientHandle)
      if OpEN.OPEN_E_NONE == result:
        print "Success: The count greatest number of FDB entries is resetted.\n"
      else:
        print "Failed to reset the greatest number of FDB entries. (Result = %d)\n" % (result)

      ''' Testing the count of dynamic entries in the L2FDB '''
      result = OpEN.openapiFdbDynamicEntriesGet(self.clientHandle, value)
      if OpEN.OPEN_E_NONE == result:
        print "Success: The count of dynamic entries in the L2FDB: %d.\n" % (value)
      else:
        print "Failed to get the count of dynamic entries in the L2FDB. (Result = %d)\n" % (result)

      ''' Testing the count of internally added entries in the L2FDB '''
      result = OpEN.openapiFdbInternalEntriesGet(self.clientHandle, value)
      if OpEN.OPEN_E_NONE == result:
        print "Success: The count of internally added entries in the L2FDB: %d.\n" % (value)
      else:
        print "Failed to get the count of internally added entries in the L2FDB. (Result = %d)\n" % (result)

      ''' Testing of verification is specified MAC is restricted '''
      result = OpEN.openapiIsRestrFilterMacGet(self.clientHandle, mac)
      if OpEN.OPEN_E_NONE == result:
        print "Success: The specified MAC is not restricted.\n"
      elif OpEN.OPEN_E_DISABLED == result:
        print "Success: The specified MAC is restricted.\n"
      else:
        print "Failed to verify is specified MAC is restricted. (Result = %d)\n" % (result)

      ''' Testing the retrieving next entry from the forwarding database based for the specified interface '''
      result = OpEN.openapiFdbIntfEntryNextGet(self.clientHandle, mac, fdbIfNum, fdbEntryType)
      if OpEN.OPEN_E_NONE == result:
        print "Success: Get next entry from the forwarding database for the specified internal interface number: %d.\n" % (fdbIfNum)
      else:
        print "Failed to get next entry from the forwarding database for the specified interface. (Result = %d)\n" % (result)

      ''' Testing the retrieving next entry from the forwarding database based for the specified VLAN '''
      result = OpEN.openapiFdbVlanEntryNextGet(self.clientHandle, mac, fdbIfNum, fdbEntryType, vlanId)
      if OpEN.OPEN_E_NONE == result:
        print "Success: Get next entry from the forwarding database for the specified VLAN.\n"
      else:
        print "Failed to get next entry from the forwarding database for the specified VLAN. (Result = %d)\n" % (result)

      ''' Testing the retrieving of the supported VL '''
      result = OpEN.openapiFdbTypeOfVLGet(self.clientHandle, vlType)
      if OpEN.OPEN_E_NONE == result:
        print "Success: Get the supported VLAN learning type: %d.\n" % (vlType)
      else:
        print "Failed to get the supported VL. (Result = %d)\n" % (result)

      ''' Testing the retrieving of the next fdbID starting from a certain index '''
      result = OpEN.openapiFdbIdNextGet(self.clientHandle, OpEN.uint32_tp_value(fdbId), value)
      if OpEN.OPEN_E_NONE == result:
        print "Success: Get the next fdbID starting from a '%d' index.\n" % (OpEN.uint32_tp_value(fdbId))
      else:
        print "Cannot get the next fdbID starting from a '%d' index. (Result = %d)\n" % (OpEN.uint32_tp_value(fdbId), result)

      ''' Testing of retrieving the number of failed FDB insert attempts due to failure to allocate space '''
      result = OpEN.openapiFdbBadAddsGet(self.clientHandle, value)
      if OpEN.OPEN_E_NONE == result:
        print "Success: Get the number of failed FDB insert: %d.\n" % (value)
      else:
        print "Failed to get the number of failed FDB insert. (Result = %d)\n" % (result)

      ''' Testing of retrieving the max limit of MAC entries set in the hardware '''
      result = OpEN.openapiFdbBadAddsGet(self.clientHandle, value)
      if OpEN.OPEN_E_NONE == result:
        print "Success: Get the max limit of MAC entries set in the hardware: %d.\n" % (value)
      else:
        print "Failed to get the max limit of MAC entries set in the hardware. (Result = %d)\n" % (result)

      ''' Testing of retrieving the value of dynamic entries in the L2FDB for a specific interface '''
      result = OpEN.openapiFdbIntfDynamicEntriesGet(self.clientHandle, OpEN.uint32_tp_value(fdbIfNum), value)
      if OpEN.OPEN_E_NONE == result:
        print "Success: Get the value of dynamic entries in the L2FDB for a %d interface: %d.\n" % (OpEN.uint32_tp_value(fdbIfNum), value)
      else:
        print "Failed to get the value of dynamic entries in the L2FDB for a %d interface. (Result = %d)\n" % (OpEN.uint32_tp_value(fdbIfNum), result)

      ''' Testing of retrieving the value of dynamic entries in the L2FDB for a specific VLAN '''
      result = OpEN.openapiFdbVlanDynamicEntriesGet(self.clientHandle, OpEN.uint32_tp_value(vlanId), value)
      if OpEN.OPEN_E_NONE == result:
        print "Success: Get the value of dynamic entries in the L2FDB for a VLAN %d: %d.\n" % (OpEN.uint32_tp_value(vlanId), value)
      else:
        print "Failed to get the value of dynamic entries in the L2FDB for a VLAN %d. (Result = %d)\n" % (OpEN.uint32_tp_value(vlanId), result)

      ''' Testing of retrieving the value of internal entries in the L2FDB for a specific interface '''
      result = OpEN.openapiFdbIntfInternalEntriesGet(self.clientHandle, OpEN.uint32_tp_value(fdbIfNum), value)
      if OpEN.OPEN_E_NONE == result:
        print "Success: Get the value of internal entries in the L2FDB for a %d interface: %d.\n" % (OpEN.uint32_tp_value(fdbIfNum), value)
      else:
        print "Failed to get the value of internal entries in the L2FDB for a %d interface. (Result = %d)\n" % (OpEN.uint32_tp_value(fdbIfNum), result)

      ''' Testing of retrieving the value of internal entries in the L2FDB for a specific VLAN '''
      result = OpEN.openapiFdbVlanInternalEntriesGet(self.clientHandle, OpEN.uint32_tp_value(vlanId), value)
      if OpEN.OPEN_E_NONE == result:
        print "Success: Get the value of internal entries in the L2FDB for a VLAN %d: %d.\n" % (OpEN.uint32_tp_value(vlanId), value)
      else:
        print "Failed to get the value of internal entries in the L2FDB for a VLAN %d. (Result = %d)\n" % (OpEN.uint32_tp_value(vlanId), result)

      ''' Testing of flushing all entries in fdb learned on the specified interface '''
      result = OpEN.openapiFdbFlushByPort(self.clientHandle, OpEN.uint32_tp_value(fdbIfNum))
      if OpEN.OPEN_E_NONE == result:
        print "Success: Flushed all entries in fdb learned on the interface %d.\n" % (OpEN.uint32_tp_value(fdbIfNum))
      else:
        print "Failed to flush all entries in fdb learned on the interface %d. (Result = %d)\n" % (OpEN.uint32_tp_value(fdbIfNum), result)

      ''' Testing of flushing all entries in fdb learned on the specified VLAN '''
      result = OpEN.openapiFdbFlushByVlan(self.clientHandle, OpEN.uint32_tp_value(vlanId))
      if OpEN.OPEN_E_NONE == result:
        print "Success: Flushed all entries in fdb learned on the VLAN %d.\n" % (OpEN.uint32_tp_value(vlanId))
      else:
        print "Failed to flush all entries in fdb learned on the VLAN %d. (Result = %d)\n" % (OpEN.uint32_tp_value(vlanId), result)

      ''' Testing of flushing all entries in fdb learned on the specified MAC '''
      result = OpEN.openapiFdbFlushByMac(self.clientHandle, mac)
      if OpEN.OPEN_E_NONE == result:
        print "Success: Flushed all entries in fdb learned on the MAC.\n"
      else:
        print "Failed to flush all entries in fdb learned on the MAC. (Result = %d)\n" % (result)

      ''' Testing of flushing all learned entries from the L2FDB '''
      result = OpEN.openapiFdbFlush(self.clientHandle)
      if OpEN.OPEN_E_NONE == result:
        print "Success: Flushed all learned entries from the L2FDB.\n"
      else:
        print "Failed to flush all learned entries from the L2FDB. (Result = %d)\n" % (result)


def main():
  ret = open_.connect("fdb_example")
  if ret == OpEN.OPEN_E_NONE:
    open_.getNetworkOSVersion()
    open_.getAPIVersion()
    client = open_.get_client()

    fdbExample = FdbExample(client)
    fdbExample.main()

    open_.terminate()
  else:
    print "Unable to connect"


if __name__ == '__main__': main()
