#!/mnt/fastpath/usr/bin/ruby

require "OpEN"
require "OpENUtil"

#
# Copyright 2016 Broadcom.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#


#
# Ruby 1.8.7.
#

$open = OpENUtil.new()

PKT_LEN = 128

def print_sanity_results(result, test, msg, feat)
  #Print overall comparison results

  if result == OpEN::OPEN_E_UNAVAIL
    puts "Sanity test skipped."
  elsif result == OpEN::OPEN_E_NONE and test == true
    puts "Sanity Success - #{msg} - #{feat}."
  else
    puts "Sanity Failure - #{msg} - #{feat}."
  end
end

def print_bad_result(result, msg)
  #Print some general error messages if the result is bad
   
  if result == OpEN::OPEN_E_UNAVAIL
    puts "Feature not supported - #{msg} (err #{result})."
  elsif result != OpEN::OPEN_E_NONE
    puts "Test Failure - #{msg} (err #{result})."
  end
end

class TxPktExample
  #Packet transmission

  def initialize(client)
    @client = client
  end

  def test_tx_pkt(intf)
    #Send a packet using Unicast transmission

    intf_max_tp = OpEN.new_uint32_tp()

    result = OpEN.openapiMaxInterfaceCountGet(@client, intf_max_tp)
    if result == OpEN::OPEN_E_NONE:
      max_intf = OpEN.uint32_tp_value(intf_max_tp)
      if intf < 1 or intf > max_intf
        puts "Invalid interface. The available range is 1 to %d." % max_intf
        OpEN.delete_uint32_tp(intf_max_tp)
        return
      end
    else
      OpEN.delete_uint32_tp(intf_max_tp)
      return
    end

    # Build a dummy ethernet packet
    pkt_data = "\x00\x01\x02\x03\x04\x05"
    pkt_data += "\x06\x07\x08\x09\x0a\x0b"
    pkt_data += "\xcc" * (PKT_LEN-pkt_data.length)

    pkt_string = $open.getCharBuffer(pkt_data.length, pkt_data)
    pkt_buff = OpEN::Open_buffdesc.new
    pkt_buff.pstart = pkt_string
    pkt_buff.size = PKT_LEN

    puts "Send Packet..."
    result = OpEN.openapiExtPktTransmit(@client, pkt_buff, OpEN::OPEN_EXT_PKT_TX_L2RAW_UNICAST, intf, 0, 0) 
    print_bad_result(result, 'openapiExtPktTransmit')
    print_sanity_results(result, true, 'openapiExtPktTransmit', 'ifnum %d' % intf) 

    OpEN.delete_uint32_tp(intf_max_tp)
  end

end

def main()
  #Demonstrate OpEN usage for Packet API

  if ARGV.length == 1
    begin
      intf = Integer(ARGV[0])
    rescue
      puts 'Invalid interface, <ifnum> must be numeric.'
      exit
    end
  else
    puts 'tx_pkt_example.py <ifnum>'
    exit
  end
  
  ret = $open.connect("tx_pkt_example")
  if ret == OpEN::OPEN_E_NONE
    $open.getNetworkOSVersion()
    $open.getAPIVersion()
    client = $open.client
    example = TxPktExample.new(client)
    example.test_tx_pkt(intf)
    $open.terminate()
  else
    print "Unable to connect"
  end
end

if __FILE__ == $0 then main() end


