=begin
*
* Copyright 2016-2018 Broadcom.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0*
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
=end

require 'pathname'
require "OpEN"
require "OpENUtil"

Puppet::Type.type(:netdev_config_script).provide(:icos) do
  confine :exists => "/etc/brl-release"
  @doc = "NOS netdev Config script file"

  def create
    file_name = File.basename(resource[:file])
    open = OpENUtil.new()
    open.connect("netdev_stdlib_icos-config_script")
    buffdesc        = OpEN::Open_buffdesc.new
    buffdesc.size   = file_name.length + 1
    buffdesc.pstart = open.getCharBuffer(buffdesc.size, file_name)

    case resource[:action]
    when :'backup' then
      ret = OpEN::openapiRunningCfgGenerate(open.client, buffdesc)
      if ret != OpEN::OPEN_E_NONE
        warning('Failed to generate running configuration file.')
      end
    when :'save' then
      ret = OpEN::openapiSaveConfig(open.client)
      if ret != OpEN::OPEN_E_NONE
        warning('Failed to save configuration.')
      end
    else
      tmpFile        = `mktemp`
      tmpFile        = tmpFile.chomp
      tmpdesc        = OpEN::Open_buffdesc.new
      tmpdesc.size   = tmpFile.length + 1
      tmpdesc.pstart = open.getCharBuffer(tmpdesc.size, tmpFile)
      ret = OpEN::openapiTxtCfgApply(open.client, buffdesc, tmpdesc)
      if ret != OpEN::OPEN_E_NONE
        warning('Failed to apply configuration.')
      end
      File.delete(tmpFile) if File.exist?(tmpFile)
    end
    open.terminate()
  end

  def exists?
    File.exist?('#{resource[:file]}')
  end

end

