#!/usr/local/bin/perl
#
# Copyright 2016-2017 Broadcom
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#

use File::Path;
use Shell;

my $root_dir = "../..";
my $openapi_inc_all = $root_dir . "/rpc/rpccom_openapi_all_incl.h"; 
my @openapi_include_files = &get_openapi_include_files;
my @rpc_header_files = ("proc_util.h","rpcclt_openapi.h","rpcclt_openapi_map.h","rpccom_openapi_all_incl.h","rpccom_openapi.h");
my @rpc_include_files = &get_rpc_include_files;
my $helper_function_file = $root_dir . "/swig/common/common.c";
my $helper_include_file = $root_dir . "/swig/common/instru.h";

my $swig_helper_common_functions = q'';
my $swig_helper_common_include = q'';
my $swig_helper_pointer_functions = q'';
my $swig_helper_ft_pointer_functions = q'';

my $swig_related_content = q'
%typemap(in) unsigned char[((OPEN_EVENT_LAST) / 8) + 1] (unsigned char tmp[((OPEN_EVENT_LAST) / 8) + 1]) {
$1 = &tmp[0];
memset((void *) $1, 0, ((OPEN_EVENT_LAST) / 8) + 1);
memcpy((void *) $1, (void *) lua_tostring(L,$input), strlen(lua_tostring(L,$input)));
}
%{
void buf_to_open_sysExtAgentPktRxDesc_t(char *buf, open_sysExtAgentPktRxDesc_t* dst)
{
  memcpy((char*)dst ,(char*)buf, sizeof(open_sysExtAgentPktRxDesc_t));
}


#include <ctype.h>

/*********************************************************************
* @purpose  Test bit in a unsigned 32-bit mask. Lua 5.1 does not support
*           bit ops.
*
* @param    mask        uint32_t mask
* @param    bit         bit to test (valid range 0 - 31)
*
* @returns  0 if specified bit is set in mask
* @returns  1 if specified bit is not set
* @returns -1 if specified bit not in range [0-31]
*
* @end
*********************************************************************/
int testBit(uint32_t mask, int bit)
{
  int ret = 0;

  if (bit < 0 || bit > 31)  
  {
    ret = -1;
  }
  else if (mask & (1 << bit)) 
  {
    ret = 1;
  }
  return ret;
}

/*********************************************************************
* @purpose  Convert a sequence of bytes into a MAC address string
*
* @param    bytes       pointer to 6 bytes of MAC address
* @param    mac         string at least 18 characters in length to hold result
* @param    size        number of bytes in mac
*
* @returns  0 on success, 1 on failure
*
* @end
*********************************************************************/
int bytes_to_mac(char *bytes, void *mac, int size)
{
  const char *p = (const char *) bytes;

  int ret = 1;

  if (p && (char *) mac) 
  {
    snprintf((char *) mac, size, "%02x:%02x:%02x:%02x:%02x:%02x",
      p[0] & 0xff,
      p[1] & 0xff,
      p[2] & 0xff,
      p[3] & 0xff,
      p[4] & 0xff,
      p[5] & 0xff);
    ret = 0;
  }
  return ret;
}

/*********************************************************************
* @purpose  Convert a MAC address from ASCII string to hex characters
*
* @param    *pString    @{(input)}  ASCII string in one of the next formats:
*                                   "xx:xx:xx:xx:xx:xx"
*                                   "xx-xx-xx-xx-xx-xx"
*                                   "xxxx.xxxx.xxxx"
* @param    *pHexBuf    @{(output)} Output buffer to store 6-byte hex value
*
* @returns  L7_SUCCESS
* @returns  L7_FAILURE
*
* @comments The input MAC address string format must be exactly as shown
*           for the pString parameter.  That is, two characters are required
*           for each of the six octets in the MAC address, with each octet
*           separated by a colon character.
*
* @comments The caller must ensure that the output buffer pointed to by
*           pHexBuf is at least L7_MAC_ADDR_LEN bytes in size.
*
* @note     Clone of L7_RC_t l7utilsMacAddrStringToHex(L7_uchar8 *pString, L7_uchar8 *pHexBuf).
* @end
*********************************************************************/

int mac_to_bytes(const char *mac, void *bytes)
{
  int L7_MAC_ADDR_LEN = 6;
  char *L7_NULLPTR = (char *) NULL;
  char L7_NULL = \'\0\';
  int L7_FAILURE = 1;
  int L7_SUCCESS  = 0;
  typedef char L7_char8;
  typedef uint32_t L7_uint32;
  typedef int32_t L7_int32;

  const L7_char8  *pMacAddrStringTemplate = "xx:xx:xx:xx:xx:xx";
  const L7_char8  *pMacAddrStringTemplate2 = "xxxx.xxxx.xxxx";
  const L7_char8  *pMacAddrStringFormat = "%02x:%02x:%02x:%02x:%02x:%02x";
  const L7_char8  *pMacAddrStringFormat1 = "%02x-%02x-%02x-%02x-%02x-%02x";
  const L7_char8  *pMacAddrStringFormat2 = "%02x%02x.%02x%02x.%02x%02x";
  L7_uint32  macAddrDelimiterIndx = 2;

  L7_uint32     temp[L7_MAC_ADDR_LEN];
  L7_uint32     i;
  L7_int32      count;
  L7_uint32     inStrLen = L7_NULL;

  L7_char8 *pString = (L7_char8 *) mac;
  L7_char8 *pHexBuf = (L7_char8 *) bytes;

  /* code here on out identical to l7utilsMacAddrStringToHex */

  if ((pString == L7_NULLPTR) || (pHexBuf == L7_NULLPTR))
  {
    return L7_FAILURE;
  }

  inStrLen = strlen(pString);

  if (strlen(pMacAddrStringTemplate) == inStrLen)
  {
    if (\':\' == pString[macAddrDelimiterIndx])
    {
      count = sscanf(pString, pMacAddrStringFormat,
                     &temp[0], &temp[1], &temp[2], &temp[3], &temp[4], &temp[5]);
    }
    else
    {
      count = sscanf(pString, pMacAddrStringFormat1,
                     &temp[0], &temp[1], &temp[2], &temp[3], &temp[4], &temp[5]);
    }

    if (count != L7_MAC_ADDR_LEN)
    {
      return L7_FAILURE;
    }

    for (i = 0; i < L7_MAC_ADDR_LEN; i++)
    {
      *(pHexBuf + i) = temp[i];
    }
  }
  else if (strlen(pMacAddrStringTemplate2) == inStrLen)
  {
    count = sscanf(pString, pMacAddrStringFormat2,
                   &temp[0], &temp[1], &temp[2], &temp[3], &temp[4], &temp[5]);

    if (count != L7_MAC_ADDR_LEN)
    {
      return L7_FAILURE;
    }

    for (i = 0; i < L7_MAC_ADDR_LEN; i++)
    {
      *(pHexBuf + i) = temp[i];
    }
  }
  else
  {
    return L7_FAILURE;
  }

  return L7_SUCCESS;
}

%}
%include "stdint.i"
%include "cpointer.i"
%pointer_functions(uint8_t, uint8_tp);
%pointer_functions(uint16_t, uint16_tp);
%pointer_functions(uint32_t, uint32_tp);
%pointer_functions(uint64_t, uint64_tp);
%pointer_functions(open_inet_addr_t, open_inet_addr_tp);
%pointer_functions(bool, bool_tp);
%pointer_functions(OPEN_TCAM_API_POLICYID_t, OPEN_TCAM_API_POLICYID_tp);
%pointer_functions(OPEN_VLAN_LIST_t, OPEN_VLAN_LIST_tp);
%pointer_functions(open_sysExtAgentPktRxDesc_t, open_sysExtAgentPktRxDesc_tp);

%include "carrays.i"
%array_functions(uint32_t, uint32_tArray);
%array_functions(uint16_t, uint16_tArray);
%array_functions(uint8_t, uint8_tArray);
#if defined(L7_ACL_PACKAGE)
%array_functions(OPEN_ACL_INTF_LIST_INFO_t, OPEN_ACL_INTF_LIST_INFO_tArray);
%array_functions(OPEN_ACL_VLAN_LIST_INFO_t, OPEN_ACL_VLAN_LIST_INFO_tArray);
#endif
%array_class(int, intArray);
%array_class(char, charArray);
%array_class(unsigned char, ucharArray);
%array_functions(OPEN_BOOL_t, OPEN_BOOL_tArray)
%array_functions(openapiTrapLogEntry_t, openapiTrapLogEntry_tArray)
int bytes_to_mac(void *bytes, void *mac, int size);
int mac_to_bytes(const char *mac, void *bytes);
int testBit(uint32_t mask, int bit);
';

if ($ENV{'BLD_L7_COMPONENTS_INSTRU_APP'} == 1)
{
  $swig_helper_pointer_functions = q'
%pointer_functions(OPEN_ASIC_CAPABILITIES_t, OPEN_ASIC_CAPABILITIES_tp);
%pointer_functions(OPEN_ASIC_PORT_MAP_t, OPEN_ASIC_PORT_MAP_tp);
%pointer_functions(OPEN_BST_DEVICE_DATA_t, OPEN_BST_DEVICE_DATA_tp);
%pointer_functions(OPEN_BST_INGRESS_PORT_PG_DATA_t, OPEN_BST_INGRESS_PORT_PG_DATA_tp);
%pointer_functions(OPEN_BST_INGRESS_PORT_SP_DATA_t, OPEN_BST_INGRESS_PORT_SP_DATA_tp);
%pointer_functions(OPEN_BST_INGRESS_SP_DATA_t, OPEN_BST_INGRESS_SP_DATA_tp);
%pointer_functions(OPEN_BST_EGRESS_PORT_SP_DATA_t, OPEN_BST_EGRESS_PORT_SP_DATA_tp);
%pointer_functions(OPEN_BST_EGRESS_SP_DATA_t, OPEN_BST_EGRESS_SP_DATA_tp);
%pointer_functions(OPEN_BST_EGRESS_UC_QUEUE_DATA_t, OPEN_BST_EGRESS_UC_QUEUE_DATA_tp);
%pointer_functions(OPEN_BST_EGRESS_UC_QUEUEGROUPS_DATA_t, OPEN_BST_EGRESS_UC_QUEUEGROUPS_DATA_tp);
%pointer_functions(OPEN_BST_EGRESS_MC_QUEUE_DATA_t, OPEN_BST_EGRESS_MC_QUEUE_DATA_tp);
%pointer_functions(OPEN_BST_EGRESS_CPU_QUEUE_DATA_t, OPEN_BST_EGRESS_CPU_QUEUE_DATA_tp);
%pointer_functions(OPEN_BST_EGRESS_RQE_QUEUE_DATA_t, OPEN_BST_EGRESS_RQE_QUEUE_DATA_tp);
%pointer_functions(OPEN_BST_ASIC_SNAPSHOT_DATA_t, OPEN_BST_ASIC_SNAPSHOT_DATA_tp);
%pointer_functions(OPEN_BST_CONFIG_t, OPEN_BST_CONFIG_tp);
%pointer_functions(OPEN_BST_EGRESS_PORT_SP_THRESHOLD_t, OPEN_BST_EGRESS_PORT_SP_THRESHOLD_tp);
%pointer_functions(OPEN_BST_DEVICE_THRESHOLD_t, OPEN_BST_DEVICE_THRESHOLD_tp);
%pointer_functions(OPEN_BST_INGRESS_PORT_PG_THRESHOLD_t, OPEN_BST_INGRESS_PORT_PG_THRESHOLD_tp);
%pointer_functions(OPEN_BST_INGRESS_PORT_SP_THRESHOLD_t, OPEN_BST_INGRESS_PORT_SP_THRESHOLD_tp);
%pointer_functions(OPEN_BST_INGRESS_SP_THRESHOLD_t, OPEN_BST_INGRESS_SP_THRESHOLD_tp);
%pointer_functions(OPEN_BST_EGRESS_SP_THRESHOLD_t, OPEN_BST_EGRESS_SP_THRESHOLD_tp);
%pointer_functions(OPEN_BST_EGRESS_UC_QUEUE_THRESHOLD_t, OPEN_BST_EGRESS_UC_QUEUE_THRESHOLD_tp);
%pointer_functions(OPEN_BST_EGRESS_UC_QUEUEGROUPS_THRESHOLD_t, OPEN_BST_EGRESS_UC_QUEUEGROUPS_THRESHOLD_tp);
%pointer_functions(OPEN_BST_EGRESS_MC_QUEUE_THRESHOLD_t, OPEN_BST_EGRESS_MC_QUEUE_THRESHOLD_tp);
%pointer_functions(OPEN_BST_EGRESS_CPU_QUEUE_THRESHOLD_t, OPEN_BST_EGRESS_CPU_QUEUE_THRESHOLD_tp);
%pointer_functions(OPEN_BST_EGRESS_RQE_QUEUE_THRESHOLD_t, OPEN_BST_EGRESS_RQE_QUEUE_THRESHOLD_tp);
%pointer_functions(OPEN_BST_TRIGGER_CALLBACK_t, OPEN_BST_TRIGGER_CALLBACK_tp);
%pointer_functions(OPEN_PT_PACKET_t, OPEN_PT_PACKET_tp);
%pointer_functions(OPEN_PT_TRACE_PROFILE_t, OPEN_PT_TRACE_PROFILE_tp);
%pointer_functions(OPEN_BLACK_HOLE_CONFIG_t, OPEN_BLACK_HOLE_CONFIG_tp);
%pointer_functions(OPEN_BHD_PORT_SFLOW_SAMPLING_STATUS_t, OPEN_BHD_PORT_SFLOW_SAMPLING_STATUS_tp);
%pointer_functions(time_t, time_tp);
%pointer_functions(OPEN_SYSTEM_COSQ_HWQ_MAP_t, OPEN_SYSTEM_COSQ_HWQ_MAP_tp);
  ';
if ($ENV{'BLD_L7_FEAT_FT'} == 1)
{
  $swig_helper_ft_pointer_functions = q'
%pointer_functions(OPEN_FT_CAPABILITIES_t, OPEN_FT_CAPABILITIES_tp);
%pointer_functions(OPEN_FT_CONFIG_t, OPEN_FT_CONFIG_tp);
%pointer_functions(OPEN_FT_CL_INFO_t, OPEN_FT_CL_INFO_tp);
%pointer_functions(OPEN_FT_FLW_GRP_CONFIG_t, OPEN_FT_FLW_GRP_CONFIG_tp);
%pointer_functions(OPEN_FT_FLW_REC_TEMPLATE_t, OPEN_FT_FLW_REC_TEMPLATE_tp);
%pointer_functions(OPEN_FT_FLW_REC_TEMPLATE_INFO_t, OPEN_FT_FLW_REC_TEMPLATE_INFO_tp);
%pointer_functions(OPEN_IP_FIX_FLD_SPEC_WITH_EN_t, OPEN_IP_FIX_FLD_SPEC_WITH_EN_tp);
%pointer_functions(OPEN_FT_FLW_GRP_STATS_t, OPEN_FT_FLW_GRP_STATS_tp);
%array_functions(OPEN_IP_FIX_FLD_SPEC_WITH_EN_t, OPEN_IP_FIX_FLD_SPEC_WITH_EN_tArray);
%array_functions(OPEN_FT_FLW_REC_TEMPLATE_INFO_t, OPEN_FT_FLW_REC_TEMPLATE_INFO_tArray);
';
}

  $swig_helper_common_functions = get_helper_functions($helper_function_file);
  $swig_helper_common_include   = get_helper_functions($helper_include_file);
}

my $openwrap_content = qq|%module OpEN_Lua

%{
#define SWIG_FILE_WITH_INIT 1
#ifndef bool
#include <stdbool.h>
#endif
@{[&print_includes("#", @rpc_include_files)]}
@{[&print_includes("#", @openapi_include_files)]}

#if defined (OPENAPI_FT_H_INCLUDED)
void setFtFlowGroupCollectorName(OPEN_FT_FLW_GRP_CONFIG_t *dst, int idx, char x[OPEN_FT_MAX_NAME_LENGTH])
{
  int i;
  for (i = 0; i < OPEN_FT_MAX_NAME_LENGTH; i++)
  {
    dst->cl_name_list[idx][i] = x[i];
  }
}
#endif

char *getStringFromUcharArray(unsigned char x[])
{
  return (char *) x;
}

#if defined (OPENAPI_ROUTING_STATS_H_INCLUDED)
size_t getopenEcmpRouteProtocolCount_tSize()
{
  return sizeof(openEcmpRouteProtocolCount_t);
}
#endif

%}
%{
@{[$swig_helper_common_functions]}
%}
@{[$swig_related_content]}
@{[$swig_helper_pointer_functions]}
@{[$swig_helper_ft_pointer_functions]}
@{[&print_includes("%", @rpc_include_files)]}
@{[&print_includes("%", @openapi_include_files)]}
%include "../../api/include/openapi_swig_helpers.h"
@{[&print_enums]}
#if defined(__OPENAPI_L2OL3TUNNEL_H__)
%pointer_functions(open_l2ol3TunnelInfo_t, open_l2ol3TunnelInfo_tp);
%pointer_functions(open_l2ol3TunnelStats_t, open_l2ol3TunnelStats_tp);
%pointer_functions(open_l2ol3AccessPortInfo_t, open_l2ol3AccessPortInfo_tp);
%pointer_functions(open_l2ol3TenantConfig_t, open_l2ol3TenantConfig_tp);
%pointer_functions(open_l2ol3L2FwdEntry_t, open_l2ol3L2FwdEntry_tp);
%pointer_functions(open_l2ol3ResourceStats_t, open_l2ol3ResourceStats_tp);
%pointer_functions(open_l2ol3ResourceLimits_t, open_l2ol3ResourceLimits_tp);
#endif
#if defined(OPENAPI_BGP_CONFIG_H_INCLUDED)
%pointer_functions(open_bgpPeerStatus_t, open_bgpPeerStatus_tp);
%pointer_functions(open_bgpDecProcHist_t, open_bgpDecProcHist_tp);
#endif

#if defined(OPENAPI_ROUTING_H_INCLUDED)
%pointer_functions(openBfdSessionInfo_t, openBfdSessionInfo_tp);
#endif

#if defined (OPENAPI_ROUTING_STATS_H_INCLUDED)
%array_functions(openEcmpRouteProtocolCount_t, openEcmpRouteProtocolCount_tArray);
%pointer_functions(openRouteStats_t, openRouteStats_tp);
size_t getopenEcmpRouteProtocolCount_tSize();
#endif
char *getStringFromUcharArray(unsigned char x[]);
#if defined (OPENAPI_FT_H_INCLUDED)
void setFtFlowGroupCollectorName(OPEN_FT_FLW_GRP_CONFIG_t *dst, int idx, char x[OPEN_FT_MAX_NAME_LENGTH]);
#endif

@{[$swig_helper_common_include]}
|;

open(OUTFILE, ">./openwrap.i");
print OUTFILE $openwrap_content;
close(OUTFILE);

sub get_helper_functions
{
  my ($filename) = @_;
  my $content;
  open(my $fh, '<', $filename) or die "cannot open file $filename";
  {
    local $/;
    $content = <$fh>;
  }
  close($fh);

  #remove comments in the file
  $content =~ s#/\*[^*]*\*+([^/*][^*]*\*+)*/
           |//[^\n]*
           |("(\\.|[^"\\])*" | '(\\.|[^'\\])*' | .[^/"'\\]*)
           #defined $2 ? $2 : ""#gsex;

  return $content;
}

sub print_enums
{
  my @enums = &get_enums;
  my $str = "";
  foreach my $enum (@enums)
  {
    $str .= "%pointer_functions(". $enum . ", " . $enum . "p" . ");\n";
  }
  return $str;
}

sub get_enums
{
  my @enums = ();

  foreach my $header_file (@openapi_include_files)
  {
    #read contents of a file into a variable
    my $content = do {
        local $/ = undef;
        open my $fh, "<", $header_file
            or die "could not open $header_file: $!";
        <$fh>;
    };
    #remove comments in the file
    $content =~ s#/\*[^*]*\*+([^/*][^*]*\*+)*/
             |//[^\n]*
             |q("(\\.|[^"\\])*" | '(\\.|[^'\\])*' | .[^/"'\\]*)
             #defined $2 ? $2 : ""#gsex;

    while ($content =~ /(typedef\s+enum\s*{[^}]*}[^;]+;)/g)
    {
      my ($tmp1, $enumName) = split("}", $1);
      $enumName =~ s/^\s+//; #remove leading spaces
      $enumName =~ s/\s+$//; #remove trailing spaces
      chop($enumName); #remove last character ';'
      push(@enums, $enumName);
    }
  }
  return @enums;
}

sub print_includes
{
  my ($suffix, @file_list) = @_;
  my $str = "";
  foreach my $this_file (@file_list)
  {
    $str .= $suffix . "include \"" . $this_file . "\"\n";
  }
  chomp($str);
  return $str;
}

sub get_rpc_include_files
{
  my @files = ();
  foreach $rpc_file (@rpc_header_files)
  {
    my $this_file = $root_dir . "/rpc/" . $rpc_file;
    push(@files, $this_file);
  }
  return @files;
}

sub get_openapi_include_files
{
  return &get_include_files;
}

sub get_include_files
{
  my ($suffix) = @_;
  my @files = ();

  my $inc_content = do {
      local $/ = undef;
      open my $fh, "<", $openapi_inc_all
          or die "could not open $openapi_inc_all: $!";
      <$fh>;
  };

  my $list_of_include_file = "";
  open(allHeaderFiles, "find $root_dir/api -name '*.h' -print|sort|");
  while (my $file = <allHeaderFiles>)
  {
    chomp($file);
    my $basename = basename($file);
    chomp($basename);
    if ($inc_content =~ /$basename/) 
    {
      push(@files, $file); 
    }
  }
  close(allHeaderFiles);
  return @files;
}

