
#
# Copyright 2016 Broadcom.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#

import OpEN_py as OpEN

if __name__ == "__main__":
  import sys
  import unittest

class OpENBufferSizeError(Exception):
  def __init__(self, message):
    super(OpENBufferSizeError, self).__init__(message)
    self._message = message

  def __str__(self):
    return repr(self._message)

class OpENUtil:
  def get_client(self):
    return self.m_client

  def __init__(self):
    self.m_client = None

  def getCharBuffer(self, size, init=None):
    '''
    This function is deprecated. Use getByteBuffer for byte-buffers,
    or getStringBuffer for buffers that hold C-style, NULL-terminated
    strings.
    '''
    ret = OpEN.charArray(size)
    if init != None and len(init) and size >= 1:
      if len(init) >= size:
        count = size - 1        # truncate with space for terminating NULL
      else:
        count = len(init)
      for x in xrange(0, count):
        ret[x] = init[x]
      ret[count] = '\0'
    else:
      for x in xrange(0, size):
        ret[x] = '\0'
    return ret

  def getByteBuffer(self, size, init=None):
    '''
    Use this function for allocating non-string buffers, like those 
    used to hold mac addresses. For any buffers that hold C-style, 
    NULL-terminated strings, use getStringBuffer.
    '''
    ret = OpEN.charArray(size)
    if init != None and len(init):
      if len(init) > size:
        raise OpENBufferSizeError("initializer larger than requested size {}".format(size))
      else:
        count = len(init)
      for x in xrange(0, count):
        ret[x] = init[x]
    else:
      for x in xrange(0, size):
        ret[x] = '\0' 
    return ret

  def getStringBuffer(self, size, init=None):
    '''
    Use this function for allocating buffers that hold C-style,
    NULL-terminated strings.
    For non-string buffers, use getStringBuffer.
    '''
    if init and not type(init) == str:
      raise TypeError                     # fail if a string is not passed
    ret = OpEN.charArray(size)
    if init != None and len(init):
      if len(init) >= size:
        raise OpENBufferSizeError("size too small for initializer {} and appended '\0'".format(init))
      else:
        count = len(init)
      for x in xrange(0, count):
        ret[x] = init[x]
      ret[count] = '\0'
    else:
      for x in xrange(0, size):
        ret[x] = '\0' 
    return ret

  def getUCharBuffer(self, size, init=None):
    '''
    This function is deprecated. Use getUByteBuffer 
    '''
    ret = OpEN.ucharArray(size)
    if init != None and len(init) and size > 0:
      if len(init) >= size:
        count = size - 1
      else:
        count = len(init)
      for x in xrange(0, count):
        ret[x] = ord(init[x])
      ret[count] = ord('\0')
    else:
      for x in xrange(0, size):
        ret[x] = ord('\0')
    return ret

  def getUByteBuffer(self, size, init=None):
    ret = OpEN.ucharArray(size)
    if init != None and len(init) and size > 0:
      if len(init) > size:
        raise OpENBufferSizeError("initializer larger than requested size {}".format(size))
      else:
        count = len(init)
      for x in xrange(0, count):
        ret[x] = ord(init[x])
    else:
      for x in xrange(0, size):
        ret[x] = ord('\0')
    return ret

  def getIntBuffer(self, size):
    ret = OpEN.intArray(size)
    return ret

  def connect(self, appname):
    maxtries = 100
    handle = OpEN.openapiClientHandle_s()
    ret = OpEN.openapiClientRegister(appname, handle)
    self.m_client = handle
    if ret == OpEN.OPEN_E_NONE:
      ret = OpEN.openapiConnectivityCheck(self.m_client)
      count = 0
      while ret != OpEN.OPEN_E_NONE and count < maxtries:
        count += 1 
        sleep(1)
        ret = OpEN.openapiConnectivityCheck(self.m_client)
    return ret

  def getNetworkOSVersion(self):
    size = 100
    switch_os_revision_string = self.getCharBuffer(size)
    switch_os_revision = OpEN.open_buffdesc()
    switch_os_revision.pstart = switch_os_revision_string
    switch_os_revision.size = size 
    ret = OpEN.openapiNetworkOSVersionGet(self.m_client, switch_os_revision)
    if ret != OpEN.OPEN_E_NONE:
      print "Network OS version retrieve error\n"
    else:
      print "Network OS version %s\n" % switch_os_revision_string.cast()

  def getAPIVersion(self):
    revData = OpEN.open_revision_data_t()
    ret = OpEN.openapiApiVersionGet(self.m_client, revData)
    if ret != OpEN.OPEN_E_NONE:
      print "OpEN version retrieve error\n"
    else:
      print "OpEN version = %u.%u.%u.%u\n" % (revData.release, revData.version, revData.maint_level, revData.build_num)

  def terminate(self):
    pass

if __name__ == "__main__":

  class testOpENGetBufferFunctions(unittest.TestCase):
    def setUp(self):  
       self.ou = OpENUtil()

    def testGetCharBuffer(self):
      y = self.ou.getCharBuffer(10)
      self.assertEqual(y[0], '\0')
      self.assertEqual(y[1], '\0')
      self.assertEqual(y[2], '\0')
      self.assertEqual(y[3], '\0')
      self.assertEqual(y[4], '\0')
      self.assertEqual(y[5], '\0')
      self.assertEqual(y[6], '\0')
      self.assertEqual(y[7], '\0')
      self.assertEqual(y[8], '\0')
      self.assertEqual(y[9], '\0')
      try:
        y = self.ou.getCharBuffer(0)
      except:
        self.assertTrue(0 == "failed to deal with 0 sized buffer")
      s = ""
      try:
        y = self.ou.getCharBuffer(len(s), s)
      except:
        self.assertTrue(0 == "failed to deal with 0 sized buffer, 0 size initializer")
      s = "1"
      try:
        y = self.ou.getCharBuffer(0, s)
      except:
        self.assertTrue(0 == "failed to deal with 0 sized, non-zero length initializer")
      s = "Hello World"
      y = self.ou.getCharBuffer(len(s) + 1, s)
      i = 0
      for x in s:
        self.assertTrue(x == y[i])
        i = i + 1
      y = self.ou.getCharBuffer(len(s), s)
      self.assertEqual(y[0], 'H')
      self.assertEqual(y[1], 'e')
      self.assertEqual(y[2], 'l')
      self.assertEqual(y[3], 'l')
      self.assertEqual(y[4], 'o')
      self.assertEqual(y[5], ' ')
      self.assertEqual(y[6], 'W')
      self.assertEqual(y[7], 'o')
      self.assertEqual(y[8], 'r')
      self.assertEqual(y[9], 'l')
      self.assertEqual(y[10], '\0')
      
    def testGetByteBuffer(self):
      y = self.ou.getByteBuffer(10)
      self.assertEqual(y[0], '\0')
      self.assertEqual(y[1], '\0')
      self.assertEqual(y[2], '\0')
      self.assertEqual(y[3], '\0')
      self.assertEqual(y[4], '\0')
      self.assertEqual(y[5], '\0')
      self.assertEqual(y[6], '\0')
      self.assertEqual(y[7], '\0')
      self.assertEqual(y[8], '\0')
      self.assertEqual(y[9], '\0')
      try:
        y = self.ou.getByteBuffer(0)
      except:
        self.assertTrue(0 == "failed to deal with 0 sized buffer")
      s = ""
      try:
        y = self.ou.getByteBuffer(len(s), s)
      except:
        self.assertTrue(0 == "failed to deal with 0 sized buffer, 0 size initializer")
      s = "Hello World"
      try:
        y = self.ou.getByteBuffer(len(s) + 1, init=s)
      except TypeError: 
        self.assertEqual(1, "received a TypeError exception when passing a string to getByteBuffer")
      except OpENBufferSizeError:
        self.assertEqual(1, "received an OpENBufferSizeError exception")
      for x in xrange(0, len(s)):
        self.assertEqual(s[x], y[x])
      try:
        y = self.ou.getByteBuffer(len(s), s)
      except TypeError: 
        self.assertEqual(1, "received a TypeError exception when passing a string to getByteBuffer")
      except OpENBufferSizeError:
        self.assertEqual(1, "received an OpENBufferSizeError exception")
      for x in xrange(0, len(s)):
        self.assertEqual(s[x], y[x])

      try:
        y = self.ou.getByteBuffer(100, '')
      except TypeError: 
        self.assertEqual(1, "received a TypeError exception from getByteBuffer")
      except OpENBufferSizeError:
        self.assertEqual(1, "received an OpENBufferSizeError exception")

      PKT_LEN = 128

      # Build a dummy ethernet packet
      pkt_data = "\x00\x01\x02\x03\x04\x05"
      pkt_data += "\x06\x07\x08\x09\x0a\x0b"
      pkt_data += "\xcc" * (PKT_LEN-len(pkt_data))

      try:
        pkt_string = self.ou.getByteBuffer(PKT_LEN, pkt_data)
      except TypeError: 
        self.assertEqual(1, "received a TypeError exception when passing a string to getByteBuffer")
      except OpENBufferSizeError:
        self.assertEqual(1, "received an OpENBufferSizeError exception")

      for x in xrange(0, PKT_LEN):
        self.assertEqual(pkt_string[x], pkt_data[x])

    def testGetUCharBuffer(self):
      y = self.ou.getUCharBuffer(10)
      self.assertEqual(y[0], ord('\0'))
      self.assertEqual(y[1], ord('\0'))
      self.assertEqual(y[2], ord('\0'))
      self.assertEqual(y[3], ord('\0'))
      self.assertEqual(y[4], ord('\0'))
      self.assertEqual(y[5], ord('\0'))
      self.assertEqual(y[6], ord('\0'))
      self.assertEqual(y[7], ord('\0'))
      self.assertEqual(y[8], ord('\0'))
      self.assertEqual(y[9], ord('\0'))
      try:
        y = self.ou.getUCharBuffer(0)
      except:
        self.assertTrue(0 == "failed to deal with 0 sized buffer")
      s = ""
      try:
        y = self.ou.getUCharBuffer(len(s), s)
      except:
        self.assertTrue(0 == "failed to deal with 0 sized buffer, 0 size initializer")
      s = "1"
      try:
        y = self.ou.getUCharBuffer(0, s)
      except TypeError: 
        self.assertEqual(1, "received a TypeError exception from getUCharBuffer")
      except OpENBufferSizeError:
        self.assertEqual(1, "received an OpENBufferSizeError exception")
      except:
        self.assertTrue(0 == "failed to deal with 0 sized, non-zero length initializer")
      s = "Hello World"
      y = self.ou.getUCharBuffer(len(s) + 1, s)
      i = 0
      for x in s:
        self.assertTrue(ord(x) == y[i])
        i = i + 1
      y = self.ou.getUCharBuffer(len(s), s)
      self.assertEqual(y[0], ord('H'))
      self.assertEqual(y[1], ord('e'))
      self.assertEqual(y[2], ord('l'))
      self.assertEqual(y[3], ord('l'))
      self.assertEqual(y[4], ord('o'))
      self.assertEqual(y[5], ord(' '))
      self.assertEqual(y[6], ord('W'))
      self.assertEqual(y[7], ord('o'))
      self.assertEqual(y[8], ord('r'))
      self.assertEqual(y[9], ord('l'))
      self.assertEqual(y[10], ord('\0'))
      
    def testGetUByteBuffer(self):
      try:
        y = self.ou.getUByteBuffer(0)
      except:
        self.assertTrue(0 == "failed to deal with 0 sized buffer")
      s = ""
      try:
        y = self.ou.getUByteBuffer(len(s), s)
      except:
        self.assertTrue(0 == "failed to deal with 0 sized buffer, 0 size initializer")
      s = "1"
      try:
        y = self.ou.getUByteBuffer(0, s)
      except:
        self.assertTrue(0 == "failed to deal with 0 sized, non-zero length initializer")
      y = self.ou.getUByteBuffer(10)
      self.assertEqual(y[0], ord('\0'))
      self.assertEqual(y[1], ord('\0'))
      self.assertEqual(y[2], ord('\0'))
      self.assertEqual(y[3], ord('\0'))
      self.assertEqual(y[4], ord('\0'))
      self.assertEqual(y[5], ord('\0'))
      self.assertEqual(y[6], ord('\0'))
      self.assertEqual(y[7], ord('\0'))
      self.assertEqual(y[8], ord('\0'))
      self.assertEqual(y[9], ord('\0'))
      y = self.ou.getUByteBuffer(0)
      s = "Hello World"
      try:
        y = self.ou.getUByteBuffer(len(s) + 1, s)
      except OpENBufferSizeError:
        self.assertEqual(1, "received an OpENBufferSizeError exception")
      except TypeError:
        self.assertEqual(1, "received a TypeError exception")
      i = 0
      for x in s:
        self.assertTrue(ord(x) == y[i])
        i = i + 1
      try:
        y = self.ou.getUByteBuffer(len(s), s)
        i = 0
        for x in s:
          self.assertTrue(ord(x) == y[i])
          i = i + 1
      except OpENBufferSizeError:
        self.assertEqual(1, "received an OpENBufferSizeError exception")
      s = '\x13\0\0\0\x08\0'
      try:
        y = self.ou.getUByteBuffer(len(s), s)
      except OpENBufferSizeError:
        self.assertEqual(1, "received an OpENBufferSizeError exception")
      except TypeError:
        self.assertEqual(1, "received a TypeError exception")
      self.assertEqual(y[0], ord('\x13'))
      self.assertEqual(y[1], ord('\0'))
      self.assertEqual(y[2], ord('\0'))
      self.assertEqual(y[3], ord('\0'))
      self.assertEqual(y[4], ord('\x08'))
      self.assertEqual(y[5], ord('\0'))

      try:
        y = self.ou.getUByteBuffer(len(s) - 1, s)
        self.assertEqual(1, "did not receive an OpENBufferSizeError exception")
      except OpENBufferSizeError:
        pass
      except TypeError:
        self.assertEqual(1, "received a TypeError exception")

    def testGetStringBuffer(self):
      y = self.ou.getStringBuffer(10)
      self.assertEqual(y[0], '\0')
      self.assertEqual(y[1], '\0')
      self.assertEqual(y[2], '\0')
      self.assertEqual(y[3], '\0')
      self.assertEqual(y[4], '\0')
      self.assertEqual(y[5], '\0')
      self.assertEqual(y[6], '\0')
      self.assertEqual(y[7], '\0')
      self.assertEqual(y[8], '\0')
      self.assertEqual(y[9], '\0')
      try:
        y = self.ou.getStringBuffer(0)
      except:
        self.assertTrue(0 == "failed to deal with 0 sized buffer")
      s = ""
      try:
        y = self.ou.getStringBuffer(len(s), s)
      except:
        self.assertTrue(0 == "failed to deal with 0 sized buffer, 0 size initializer")
      s = "Hello World"
      try:
        y = self.ou.getStringBuffer(len(s) + 1, s)
      except OpENBufferSizeError:
        self.assertEqual(1, "received an OpENBufferSizeError exception")
      except TypeError:
        self.assertEqual(1, "received a TypeError exception")
      i = 0
      for x in s:
        self.assertTrue(x == y[i])
        i = i + 1
      try:
        y = self.ou.getStringBuffer(len(s), s)
        self.assertEqual(1, "did not receive an OpENBufferSizeError exception")
      except OpENBufferSizeError:
        pass
      except TypeError:
        self.assertEqual(1, "received a TypeError exception")

      try:
        y = self.ou.getStringBuffer(len(s) - 1, s)
        self.assertEqual(1, "did not receive an OpENBufferSizeError exception")
      except OpENBufferSizeError:
        pass
      except TypeError:
        self.assertEqual(1, "received a TypeError exception")

  unittest.main(argv=[sys.argv[0]])  
