import OpEN_py as OpEN
from OpENUtil import *
import socket, struct

open_ = OpENUtil()

#
# Copyright 2016-2017 Broadcom.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#


#
# Python 2.6.6
#

class BxsExample :
  def __init__(self, client):
    self.clientHandle = client

  def gtemp(self):
      temperature_p = OpEN.new_uint32_tp()
      result = OpEN.openapiBoxsGeneralTempGet(self.clientHandle, temperature_p)
      if OpEN.OPEN_E_NONE == result :
        temp = OpEN.uint32_tp_value(temperature_p)
        print "General temperature: %d.\n" % (temp)
      else:
        print "General temperature get - failed. (result = %d)\n" % (result)

      OpEN.delete_uint32_tp(temperature_p)

  def gtemprange(self):
      mintemp_p = OpEN.new_uint32_tp()
      maxtemp_p = OpEN.new_uint32_tp()
      result = OpEN.openapiBoxsTempRangeGet(self.clientHandle, mintemp_p, maxtemp_p)
      if OpEN.OPEN_E_NONE == result :
        mintemp = OpEN.uint32_tp_value(mintemp_p)
        maxtemp = OpEN.uint32_tp_value(maxtemp_p)
        print "General temperature range: %d-%d.\n" % (mintemp, maxtemp)
      else:
        print "General temperature range get - failed. (result = %d)\n" % (result)

      OpEN.delete_uint32_tp(mintemp_p)
      OpEN.delete_uint32_tp(maxtemp_p)

  def gfspeed(self):
      fspeed_p = OpEN.new_uint32_tp()
      result = OpEN.openapiBoxsiGeneralFanSpeedGet(self.clientHandle, fspeed_p)
      if OpEN.OPEN_E_NONE == result :
        fspeed = OpEN.uint32_tp_value(fspeed_p)
        print "General Fan speed - %d.\n" % (fspeed)
      else:
        print "General Fans speed get - failed!. (result = %d)\n" % (result)
      OpEN.delete_uint32_tp(fspeed_p)

  def gfduty(self):
      fduty_p = OpEN.new_uint32_tp()
      result = OpEN.openapiBoxsiGeneralFanDutyLevelGet(self.clientHandle, fduty_p)
      if OpEN.OPEN_E_NONE == result :
        fduty = OpEN.uint32_tp_value(fduty_p)
        print "General Fan duty-level - %d.\n" % (fduty)
      else:
        print "General Fan duty-level get - failed!. (result = %d)\n" % (result)
      OpEN.delete_uint32_tp(fduty_p)

  def tscount(self):
      nts_p = OpEN.new_uint32_tp()
      result = OpEN.openapiBoxsNumOfTempSensorsGet(self.clientHandle, nts_p)
      if OpEN.OPEN_E_NONE == result :
        tsc = OpEN.uint32_tp_value(nts_p)
        print "Temp sensor count - %d. \n" % (tsc)
      else:
        print "Temp sensor count get - failed!. (result = %d)\n" % (result)
      OpEN.delete_uint32_tp(nts_p)
      return tsc

  def tsdescsize(self):
      dsize = 0
      dsize_p = OpEN.new_uint32_tp()
      result = OpEN.openapiBoxsTempSensorDescripSizeGet(self.clientHandle, dsize_p)
      if OpEN.OPEN_E_NONE == result :
        dsize = OpEN.uint32_tp_value(dsize_p)
        print "Temp sensor Description size: %s.\n" % (dsize)
      else:
        print "Temp sensor Description size get - failed!. (result = %d)\n" % (result)
      OpEN.delete_uint32_tp(dsize_p)
      return dsize

  def tsdesc(self, i, dsize):
      descr = OpEN.open_buffdesc()
      descr.size = dsize
      descr_string = open_.getStringBuffer(dsize)
      descr.pstart = descr_string
      result = OpEN.openapiBoxsTempSensorDescripGet(self.clientHandle, i, descr)
      if OpEN.OPEN_E_NONE == result :
        print "Temp sensor[%d] Description: %s.\n" % (i, descr_string.cast())
      else:
        print "Temp sensor[%d] Description get - failed!. (result = %d)\n" % (i, result)

  def tstemp(self,i):
      temperature_p = OpEN.new_uint32_tp()
      result = OpEN.openapiBoxsTempGet(self.clientHandle, i, temperature_p)
      if OpEN.OPEN_E_NONE == result :
        temp = OpEN.uint32_tp_value(temperature_p)
        print "Temp sensor[%d] temp: %d.\n" % (i, temp)
      else:
        print "Temp sensor[%d] temp get - failed. (result = %d)\n" % (i, result)

      OpEN.delete_uint32_tp(temperature_p)

  def tsstatus(self, i):
      tempStatus_p = OpEN.new_OPEN_BOXS_TEMPSENSOR_STATE_tp()
      result = OpEN.openapiBoxsTempSensorStatusGet(self.clientHandle, i, tempStatus_p)
      if OpEN.OPEN_E_NONE == result:
        tempStatus = OpEN.OPEN_BOXS_TEMPSENSOR_STATE_tp_value(tempStatus_p)
        if OpEN.OPEN_TEMPSENSOR_STATE_NORMAL == tempStatus:
          tempStatusStr = "Normal"
        elif OpEN.OPEN_TEMPSENSOR_STATE_WARNING == tempStatus :
          tempStatusStr = "Warning"
        elif OpEN.OPEN_TEMPSENSOR_STATE_CRITICAL == tempStatus :
          tempStatusStr = "Critical"
        elif OpEN.OPEN_TEMPSENSOR_STATE_SHUTDOWN == tempStatus :
          tempStatusStr = "Shutdown"
        elif OpEN.OPEN_TEMPSENSOR_STATE_NOTPRESENT == tempStatus :
          tempStatusStr = "Not Present"
        elif OpEN.OPEN_TEMPSENSOR_STATE_NOTOPERATIONAL == tempStatus :
          tempStatusStr = "Not Operational"
        else:
          tempStatusStr = "Unknown"
        print "Temp sensor[%d] status - %s. \n" % (i, tempStatusStr)
      else:
        print "Temp sensor[%d] status get - failed!. (result = %d)\n" % (i, result)

      OpEN.delete_OPEN_BOXS_TEMPSENSOR_STATE_tp(tempStatus_p)

  def tsmaxtemp(self,i):
      maxTemp_p = OpEN.new_uint32_tp()
      result = OpEN.openapiBoxsTempSensorMaxTempGet(self.clientHandle, i, maxTemp_p)
      if OpEN.OPEN_E_NONE == result :
        maxTemp = OpEN.uint32_tp_value(maxTemp_p)
        print "Temp sensor[%d] maxTemp - %d. \n" % (i, maxTemp)
      else:
        print "Temp sensor[%d] maxTemp get - failed!. (result = %d)\n" % (i, result)
      OpEN.delete_uint32_tp(maxTemp_p)

  def fcount(self):
      fc = 0
      nfans_p = OpEN.new_uint32_tp()
      result = OpEN.openapiBoxsNumOfFansGet(self.clientHandle, nfans_p)
      if OpEN.OPEN_E_NONE == result :
        fc = OpEN.uint32_tp_value(nfans_p)
        print "Fan count - %d. \n" % (fc)
      else:
        print "Fan count get - failed!. (result = %d)\n" % (result)
      OpEN.delete_uint32_tp(nfans_p)
      return fc

  def fspeed(self,i):
      fspeed_p = OpEN.new_uint32_tp()
      result = OpEN.openapiBoxsFanSpeedGet(self.clientHandle, i, fspeed_p)
      if OpEN.OPEN_E_NONE == result :
        fspeed = OpEN.uint32_tp_value(fspeed_p)
        print "Fan[%d] speed - %d. \n" % (i,fspeed)
      else:
        print "Fan[%d] speed get - failed!. (result = %d)\n" % (i, result)
      OpEN.delete_uint32_tp(fspeed_p)

  def fstate(self,i):
      fstate_p = OpEN.new_OPEN_BOXS_ITEM_STATE_tp()
      result = OpEN.openapiBoxsFanStateGet(self.clientHandle, i, fstate_p)
      if OpEN.OPEN_E_NONE == result :
        fstate = OpEN.OPEN_BOXS_ITEM_STATE_tp_value(fstate_p)
        if OpEN.OPEN_ITEMSTATE_NONE == fstate:
          fstateStr = "None"
        elif OpEN.OPEN_ITEMSTATE_NOT_PRESENT == fstate :
          fstateStr = "Not Present"
        elif OpEN.OPEN_ITEMSTATE_OPERATIONAL == fstate :
          fstateStr = "Operational"
        elif OpEN.OPEN_ITEMSTATE_FAILED == fstate :
          fstateStr = "Failed"
        else:
          fstateStr = "None"

        print "Fan[%d] state - %s. \n" % (i,fstateStr)
      else:
        print "Fan[%d] state get - failed!. (result = %d)\n" % (i,result)
      OpEN.delete_OPEN_BOXS_ITEM_STATE_tp(fstate_p)

  def ftype(self,i):
      ftype_p = OpEN.new_OPEN_BOXS_ITEM_TYPE_tp()
      result = OpEN.openapiBoxsFanTypeGet(self.clientHandle, i, ftype_p)
      if OpEN.OPEN_E_NONE == result :
        ftype = OpEN.OPEN_BOXS_ITEM_TYPE_tp_value(ftype_p)
        if OpEN.OPEN_TYPE_FIXED == ftype:
          ftypeStr = "Fixed"
        elif OpEN.OPEN_TYPE_REMOVABLE == ftype :
          ftypeStr = "Removable"
        else:
          ftypeStr = "None"

        print "Fan[%d] type - %s. \n" % (i,ftypeStr)
      else:
        print "Fan[%d] type get - failed!. (result = %d)\n" % (i,result)
      OpEN.delete_OPEN_BOXS_ITEM_TYPE_tp(ftype_p)

  def fduty(self,i):
      fduty_p = OpEN.new_uint32_tp()
      result = OpEN.openapiBoxsFanDutyCycleGet(self.clientHandle, i, fduty_p)
      if OpEN.OPEN_E_NONE == result :
        fduty = OpEN.uint32_tp_value(fduty_p)
        print "Fan[%d] duty-level - %d. \n" % (i, fduty)
      else:
        print "Fan[%d] duty-level get - failed!. (result = %d)\n" % (i, result)
      OpEN.delete_uint32_tp(fduty_p)

  def fdescsize(self):
      dsize = 0
      dsize_p = OpEN.new_uint32_tp()
      result = OpEN.openapiBoxsFanDescripSizeGet(self.clientHandle, dsize_p)
      if OpEN.OPEN_E_NONE == result :
        dsize = OpEN.uint32_tp_value(dsize_p)
        print "Fan Description size: %s. \n" % (dsize)
      else:
        print "Fan Description size get - failed!. (result = %d)\n" % (result)
      OpEN.delete_uint32_tp(dsize_p)
      return dsize

  def fdesc(self,i,dsize):
      descr = OpEN.open_buffdesc()
      descr.size = dsize
      descr_string = open_.getStringBuffer(dsize)
      descr.pstart = descr_string
      result = OpEN.openapiBoxsFanDescripGet(self.clientHandle, i, descr)
      if OpEN.OPEN_E_NONE == result :
        print "Fan[%d] Description: %s. \n" % (i, descr_string.cast())
      else:
        print "Fan[%d] Description get - failed!. (result = %d)\n" % (i, result)

  def pscount(self):
      nps = 0
      nps_p = OpEN.new_uint32_tp()
      result = OpEN.openapiBoxsNumOfPowSuppliesGet(self.clientHandle, nps_p)
      if OpEN.OPEN_E_NONE == result :
        nps = OpEN.uint32_tp_value(nps_p)
        print "Power Supply count - %d. \n" % (nps)
      else:
        print "Power Supply count get - failed!. (result = %d)\n" % (result)
      OpEN.delete_uint32_tp(nps_p)
      return nps

  def psstate(self,i):
      psstate_p = OpEN.new_OPEN_BOXS_ITEM_STATE_tp()
      result = OpEN.openapiBoxsPowSupplyStateGet(self.clientHandle, i, psstate_p)
      if OpEN.OPEN_E_NONE == result :
        psstate = OpEN.OPEN_BOXS_ITEM_STATE_tp_value(psstate_p)
        if OpEN.OPEN_ITEMSTATE_NONE == psstate:
          psstateStr = "None"
        elif OpEN.OPEN_ITEMSTATE_NOT_PRESENT == psstate :
          psstateStr = "Not Present"
        elif OpEN.OPEN_ITEMSTATE_OPERATIONAL == psstate :
          psstateStr = "Operational"
        elif OpEN.OPEN_ITEMSTATE_FAILED == psstate :
          psstateStr = "Failed"
        elif OpEN.OPEN_ITEMSTATE_POWERING == psstate :
          psstateStr = "Powering"
        elif OpEN.OPEN_ITEMSTATE_NOPOWER == psstate :
          psstateStr = "Not Powered"
        else:
          psstateStr = "-------"

        print "Power Supply[%d] state - %s. \n" % (i, psstateStr)
      else:
        print "Power Supply[%d] state get - failed!. (result = %d)\n" % (i, result)
      OpEN.delete_OPEN_BOXS_ITEM_STATE_tp(psstate_p)

  def pstype(self,i):
      pstype_p = OpEN.new_OPEN_BOXS_ITEM_TYPE_tp()
      result = OpEN.openapiBoxsPowSupplyTypeGet(self.clientHandle, i, pstype_p)
      if OpEN.OPEN_E_NONE == result :
        pstype = OpEN.OPEN_BOXS_ITEM_TYPE_tp_value(pstype_p)
        if OpEN.OPEN_TYPE_FIXED == pstype:
          pstypeStr = "Fixed"
        elif OpEN.OPEN_TYPE_REMOVABLE == pstype :
          pstypeStr = "Removable"
        else:
          pstypeStr = "None"

        print "Power Supply[%d] type - %s. \n" % (i, pstypeStr)
      else:
        print "Power Supply[%d] type get - failed!. (result = %d)\n" % (i, result)
      OpEN.delete_OPEN_BOXS_ITEM_TYPE_tp(pstype_p)

  def psdescsize(self):
      dsize = 0
      dsize_p = OpEN.new_uint32_tp()
      result = OpEN.openapiBoxsPowSupplyDescripSizeGet(self.clientHandle, dsize_p)
      if OpEN.OPEN_E_NONE == result :
        dsize = OpEN.uint32_tp_value(dsize_p)
        print "Power Supply Description size: %s. \n" % (dsize)
      else:
        print "Power Supply Description size get - failed!. (result = %d)\n" % (result)
      OpEN.delete_uint32_tp(dsize_p)
      return dsize

  def psdesc(self,i,dsize):
      descr = OpEN.open_buffdesc()
      descr.size = dsize
      descr_string = open_.getStringBuffer(dsize)
      descr.pstart = descr_string
      result = OpEN.openapiBoxsPowSupplyDescripGet(self.clientHandle, i, descr)
      if OpEN.OPEN_E_NONE == result :
        print "Power Supply[%d] Description: %s. \n" % (i, descr_string.cast())
      else:
        print "Power Supply[%d] Description get - failed!. (result = %d)\n" % (i, result)

def main():
  ret = open_.connect("bxs_example")
  if ret == OpEN.OPEN_E_NONE:
    open_.getNetworkOSVersion()
    open_.getAPIVersion()
    client = open_.get_client()

    # show environment
    bxsExample = BxsExample(client)

    print "-----------------------------------------------------\n"
    print "| Environment - General Information                 |\n" 
    print "-----------------------------------------------------\n"
    bxsExample.gtemp()
    bxsExample.gtemprange()
    bxsExample.gfspeed()
    bxsExample.gfduty()

    print "-----------------------------------------------------\n"
    print "| Environment - Temperature Sensors Information     | \n"
    print "-----------------------------------------------------\n"
    ds = bxsExample.tsdescsize()
    for i in xrange(0, bxsExample.tscount()):
      bxsExample.tsdesc(i,ds)
      bxsExample.tstemp(i)
      bxsExample.tsstatus(i)
      bxsExample.tsmaxtemp(i)

    print "-----------------------------------------------------\n"
    print "| Environment - Fans Information                    |\n"
    print "-----------------------------------------------------\n"
    ds = bxsExample.fdescsize()
    for i in xrange(0, bxsExample.fcount()):
      bxsExample.fspeed(i)
      bxsExample.fstate(i)
      bxsExample.ftype(i)
      bxsExample.fdesc(i,ds)

    print "-----------------------------------------------------\n"
    print "| Environment - Power Supply Information            |\n"
    print "-----------------------------------------------------\n"
    ds = bxsExample.psdescsize()
    for i in xrange(0, bxsExample.pscount()):
      bxsExample.pstype(i)
      bxsExample.psstate(i)
      bxsExample.psdesc(i,ds)

    open_.terminate()
  else:
    print "Unable to connect"

if __name__ == '__main__': main()
