#
# Chef Cookbook : netdev_icos
# File : libraries/default.rb
#
# Copyright 2016 Broadcom.
#
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#
require "OpEN"
require "OpENUtil"

def has_changed?(curres, newres)
  msg = "Checking: #{curres} is equal to #{newres}"
  log_msg('debug', msg)
  return curres != newres && !newres.nil?
end

def get_intf_num(provider, intf, type)
  found = false
  interface = -1
  open = OpENUtil.new()
  conn_ret = open.connect(provider)
  if conn_ret == OpEN::OPEN_E_NONE
    client = open.client

    # Get the internal interface number
    intf_num      = 0
    intf_num_p    = OpEN.new_uint32_tp()
    intf_type     = type
    buffdesc      = OpEN::Open_buffdesc.new

    ret = OpEN::openapiIfNextGet(client, intf_type, intf_num, intf_num_p)
    while ret == OpEN::OPEN_E_NONE
      intf_num = OpEN.uint32_tp_value(intf_num_p)

      # Get the interface name
      buffdesc.size   = 256
      name = open.getCharBuffer(buffdesc.size, nil)
      buffdesc.pstart = name
      OpEN::openapiIfNameGet(client, intf_num, buffdesc)
      intf_name = name.cast()
      if intf_name == intf
        found = true
        interface = intf_num
        break
      end
      ret = OpEN::openapiIfNextGet(client, intf_type, intf_num, intf_num_p)
   end
  else
    msg = "Failed to connect to '%s'" % provider
    log_msg("info", msg)
  end
  open.terminate()
  return found, interface
end

def log_msg(sev, msg)
  rIndex = caller[0].rindex("cookbooks", -1)
  trace = " in " + caller[0][rIndex..-1]
  case sev
    when 'info' then
      Chef::Log.info msg + trace
    when 'debug' then
      Chef::Log.debug msg + trace
    when 'warn' then
      Chef::Log.warn msg + trace
    when 'error' then
      Chef::Log.error msg + trace
    when 'fatal' then
      Chef::Log.fatal msg + trace
    else
      msg = "unknown severity '%s'" % sev
      Chef::Log.fatal msg + trace
  end
end
