#
#
# Copyright 2016-2018 Broadcom.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#

#
# Setup common include paths, libraries etc for an OpEN API
# application compile.  This file expects $(OPEN_ROOT) to be 
# configured to point to the root directory of the ADK 
# installation.
#

#
# GTO (e500v2), GTR (XLP), Keystone (MIPS32R2), Raptor (MIPS74K), PPC single
# core (e500v1), LY5 (e500mc) compiler settings, in that order:
#
# export CROSS_COMPILE=/projects/nwsoft-toolchains/brl/brl_3.8/e500v2/usr/bin/powerpc-broadcom-linux-gnuspe-
# export CROSS_COMPILE=/projects/nwsoft-toolchains/netlogic/sdk-2.2.7/toolchains_bin/mipscross/linux_plt/bin/mips64-nlm-linux-elf32btsmip-
# export CROSS_COMPILE=/projects/nwsoft-toolchains/brl/brl_2.0/brl_2.0.1/keystone/bin/mips-broadcom-linux-gnu-
# export CROSS_COMPILE=/projects/nwsoft-toolchains/brl/brl_2.0/brl_2.0.1/raptor/bin/mips-broadcom-linux-gnu-
# export CROSS_COMPILE=/projects/nwsoft-toolchains/brl/brl_2.0/brl_2.0.1/e500v1/bin/powerpc-broadcom-linux-gnu-
# export CROSS_COMPILE=/projects/nwsoft-toolchains/brl/brl_3.8/e500mc/usr/bin/powerpc-broadcom-linux-gnu-
#
# Or an example for native compiles
# export CROSS_COMPILE=/usr/bin/
#
# Check that environment variable specifying cross compiler is set.  
# This may need to change for different switches.
#

include $(OPEN_ROOT)/rpc/package.cfg

ifeq ($(CROSS_COMPILE),)
    $(error The 'CROSS_COMPILE' environment variable must be set to the fully-qualified path of the appropriate cross compiler executable.)
endif


export BLD_L7_CPU_64BIT                 := 0
ifneq (,$(findstring x86_64,$(shell $(CROSS_COMPILE)gcc -dumpmachine)))
  export BLD_L7_CPU_64BIT := 1
endif

ifneq (,$(filter $(L7_CPU),im_x86_64))
  export BLD_L7_CPU_64BIT := 0
  ARCH_CFLAGS= -m32
endif


#
# Append gcc to the macro CROSS_COMPILE 
# (This is actually done in the example files so keeping the gcc as is here
# leaving the comment intact incase this is revisited.
#
export CC=gcc $(ARCH_CFLAGS)

#
# Configure include and library paths.
#
OPEN_LIB     = $(OPEN_ROOT)/lib

#
# Bring in all of the include paths that we need.
#
INCL_PATH= \
	  -I$(OPEN_ROOT)/rpc \
	  -I$(OPEN_ROOT)/api/include \
          -I. \

#
# Need to link with the OpEN library
#
OPEN_LIBS = -L$(OPEN_LIB) -lpthread -ldl -lrt
ifeq ($(BLD_L7_CPU_64BIT),1)
    OPEN_LIBS += -lopenclt64 -lproc_libs64
else
    OPEN_LIBS += -lopenclt -lproc_libs
endif

#
# Pull it all together with FLAGS.
#
CFLAGS    = $(INCL_PATH) -g -Wall
LDFLAGS   = -Wl,-Bdynamic $(OPEN_LIBS)

ifeq ($(BLD_L7_CPU_64BIT),1)
    CFLAGS += -m64 -mtune=generic -march=x86-64
    LDFLAGS += -m64
endif

