import OpEN_py as OpEN
from OpENUtil import *

open_ = OpENUtil()


class Dot1adExample:

  def __init__(self, client):
    self.client = client
    
  def modeInterfaceSet(self, type, intf):
    intfNumStr = OpEN.open_buffdesc()
    try:
      str = open_.getStringBuffer(len(intf) + 1, intf)
    except OpENBufferSizeError:
      print("modeInterfaceSet: getStringBuffer raised OpENBufferSizeError")
      return
    except TypeError:
      print("modeInterfaceSet: getStringBuffer raised TypeError")
      return
    intfNumStr.pstart = str
    intfNumStr.size = len(intf) + 1
    intIfNum = OpEN.new_uint32_tp()
    portType_tp = OpEN.new_OPEN_DOT1AD_INTERFACE_TYPE_tp()

    if type == "nni":
      portType = OpEN.OPEN_DOT1AD_INTERFACE_TYPE_NNI
    elif type == "switchport":
      portType = OpEN.OPEN_DOT1AD_INTERFACE_TYPE_SWITCHPORT
    elif type == "uni":
      portType = OpEN.OPEN_DOT1AD_INTERFACE_TYPE_UNI
    elif type == "uni-s":
      portType = OpEN.OPEN_DOT1AD_INTERFACE_TYPE_UNI_S
    elif type == "uni-p":
      portType = OpEN.OPEN_DOT1AD_INTERFACE_TYPE_UNI_P

    OpEN.openapiIfNumGet(self.client, intfNumStr, intIfNum)

    print("interface is %d" %  OpEN.uint32_tp_value(intIfNum))
    
    result = OpEN.openapiDot1adInterfaceTypeSet(self.client, OpEN.uint32_tp_value(intIfNum), portType)
    if result != OpEN.OPEN_E_NONE:
      print "Bad return code trying to set mode on interface %s. (result = %d)" % (str.cast(), result)
    else:
      print "mode on interface %s was set successfully. (result = %d)" % (str.cast(), result)

    result = OpEN.openapiDot1adInterfaceTypeGet(self.client, OpEN.uint32_tp_value(intIfNum), portType_tp)
    if result != OpEN.OPEN_E_NONE:
      print "Bad return code trying to get mode on interface %s. (result = %d)" % (str.cast(), result)
    else:
      print "mode on interface %s was read successfully. (result = %d, value = %d)" % (str.cast(), result, OpEN.OPEN_DOT1AD_INTERFACE_TYPE_tp_value(portType_tp))

    return

  def dot1adServiceCreate(self, servName, _svid, service, ifNumber):
    servNameStr = OpEN.open_buffdesc()
    try:
      str = open_.getStringBuffer(len(servName) + 1, servName)
    except OpENBufferSizeError:
      print("dot1adServiceCreate: getStringBuffer raised OpENBufferSizeError")
      return
    except TypeError:
      print("dot1adServiceCreate: getStringBuffer raised TypeError")
      return
    servNameStr.pstart = str
    servNameStr.size = len(servName) + 1

    intfNumStr = OpEN.open_buffdesc()
    try:
      str1 = open_.getStringBuffer(len(ifNumber) + 1, ifNumber)
    except OpENBufferSizeError:
      print("dot1adServiceCreate: getStringBuffer raised OpENBufferSizeError")
      return
    except TypeError:
      print("dot1adServiceCreate: getStringBuffer raised TypeError")
      return
    intfNumStr.pstart = str1
    intfNumStr.size = len(ifNumber) + 1
    
    flag = OpEN.new_OPEN_BOOL_tp()

    tmp = OpEN.new_uint32_tp()
    svid = _svid 
    
    intIfNum = OpEN.new_uint32_tp()
    nniIntfList = OpEN.open_buffdesc()
    ifList = "0/3, 0/4, 0/5"
    try:
      ifListStr = open_.getStringBuffer(len(ifList) + 1, ifList)
    except OpENBufferSizeError:
      print("dot1adServiceCreate: getStringBuffer raised OpENBufferSizeError")
      return
    except TypeError:
      print("dot1adServiceCreate: getStringBuffer raised TypeError")
      return
    nniIntfList.pstart = ifListStr
    nniIntfList.size = len(ifList)

    if service == "e-lan":
      serviceType = OpEN.OPEN_DOT1AD_SVCTYPE_ELAN
    elif service == "e-line":
      serviceType = OpEN.OPEN_DOT1AD_SVCTYPE_ELINE
    elif service == "tls":
      serviceType = OpEN.OPEN_DOT1AD_SVCTYPE_TLS

    while (True):
      if OpEN.openapiIfNumGet(self.client, intfNumStr, intIfNum) != OpEN.OPEN_E_NONE:
        print "\nERROR: Invalid interface specified"
        break

      ''' Check if service name already exists '''
      if OpEN.openapiDot1adServiceNameToSvid(self.client, servNameStr, tmp) == OpEN.OPEN_E_NONE:
        print "\nERROR: Service with service name %s is already configured with svid %d" % (servName, OpEN.uint32_tp_value(tmp))

      ''' Check if service is already configured on specified service vlan id '''
      OpEN.openapiDot1adServiceVidIsConfigured(self.client, svid, flag)
      if OpEN.OPEN_BOOL_tp_value(flag) == OpEN.OPEN_TRUE:
        print "\nERROR: Service with service VLAN ID is already configured"

      ''' Check if service already configured on specified vlan isolate id '''
      OpEN.openapiDot1adServiceIsolateVidIsConfigured(self.client, svid, flag)
      if OpEN.OPEN_BOOL_tp_value(flag) == OpEN.OPEN_TRUE:
        print "\nERROR: Service VLAN ID is equal to Isolated VLAN ID of already configured service"

      rc = OpEN.openapiDot1adServiceCreate(self.client, svid)
      if rc != OpEN.OPEN_E_NONE:
        print "\nINFORMATION: Service with svid %d already exists" % (svid)

      else:
        rc = OpEN.openapiDot1adServiceNameAdd(self.client, svid, servNameStr)
        if rc != OpEN.OPEN_E_NONE:
          print "\nINFORMATION: Creating Service Failed"

        rc = OpEN.openapiDot1adServiceTypeSet(self.client, svid, serviceType)
        if rc != OpEN.OPEN_E_NONE:
          print "\nINFORMATION: Creating Service Failed"

        rc = OpEN.openapiDot1adNniIntfListSet(self.client, svid, nniIntfList)
        if rc != OpEN.OPEN_E_NONE:
          print "\nINFORMATION: Service configured successfully"

      rc = OpEN.openapiDot1adServiceDelete(self.client, svid)
      if rc != OpEN.OPEN_E_NONE:
        print "\nINFORMATION: failed to delete service %d: %d" % (svid, rc)
      
      break

    return

def main():
  ret = open_.connect("dot1ad_example")
  if ret == OpEN.OPEN_E_NONE :
    open_.getNetworkOSVersion()
    client = open_.get_client()
    example = Dot1adExample(client)
    OpEN.openapiVlanCreate(client, 2)
    example.modeInterfaceSet('switchport', '0/2')
    example.dot1adServiceCreate('serviceName_1', 2, 'e-lan', '0/2')

    open_.terminate()
  else :
    print "Unable to connect"

if __name__ == '__main__': main()
