"""issu_example.py: OpEN API In Service Software Upgrade(ISSU) example"""
import time
import OpEN_py as OpEN
from OpENUtil import *

open_ = OpENUtil()

#
# Copyright 2017 Broadcom.
#
#  Licensed under the Apache License, Version 2.0 (the "License")
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#

#
# Python 2.6.6
#

class IssuExample :
  """Simple ISSU class implementing ISSU client"""

  def __init__(self, client) :
    self.m_client = client
      
  def issu_client_register(self):
    """Register as ISSU client"""
    issuWarmRestart = 0
    issu_p = OpEN.new_uint32_tp()

    result = OpEN.openapiISSUClientRegister(self.m_client, issu_p)    
    if result == OpEN.OPEN_E_NONE:
      print "\nSuccessfuly registered as ISSU client\n"
    else:  
      print "\nFailed to register as ISSU client\n"
      return -1

    issuWarmRestart = OpEN.uint32_tp_value(issu_p)
    
    if issuWarmRestart == 1:
      print "\nCurrent reset reason is ISSU warm restart\n"
    else:
      print "\nCurrent reset reason is not ISSU warm restart\n"

    OpEN.delete_uint32_tp(issu_p)
    return issuWarmRestart      
    


  def issu_data_save(self):
    """Wait for ISSU save trigger event and perform simulated data saving"""

    event_mask = OpEN.openapiEventList_t()   
    purge_mask = OpEN.openapiEventList_t()   
    issu_start_p = OpEN.new_uint32_tp()

    OpEN.openapiEventListClear(event_mask)
    OpEN.openapiEventSet(event_mask, OpEN.OPEN_EVENT_ISSU_START);
    OpEN.openapiEventRegister(self.m_client, event_mask);
    result = OpEN.openapiEventRegister(self.m_client, event_mask)
    if result != OpEN.OPEN_E_NONE:
      print "Failed to register for OPEN_EVENT_ISSU_START event.\n"
      return
    else:
      print "Successfully registered for OPEN_EVENT_ISSU_START event.\n"

    print "\nWaiting for ISSU save trigger ...\n"
    
    OpEN.openapiEventWait(self.m_client, -1); 

    OpEN.openapiEventListClear(event_mask)
    OpEN.openapiEventListClear(purge_mask)
    OpEN. openapiPendingEventsGet(self.m_client, event_mask, purge_mask)
   
    if OpEN.openapiEventIsSet(event_mask, OpEN.OPEN_EVENT_ISSU_START) == 1 and \
      OpEN.openapiIssuStartGet(self.m_client, issu_start_p) == OpEN.OPEN_E_NONE:

      issuStart = OpEN.uint32_tp_value(issu_start_p)

      if issuStart == 1:
        print "\nReceived ISSU save trigger.\n"
        """Sleep for 3 sec to simulate data saving"""
        time.sleep(3)
        if OpEN.openapiISSUClientStateSaved(self.m_client) != OpEN.OPEN_E_NONE:
          print "\nFailed to notify that ISSU save is finished.\n"
        else:
          print "\nNotified that ISSU save is done.\n"
     
    OpEN.delete_uint32_tp(issu_start_p)
    return 0  
      
  def issu_data_restore(self, issu_id, rule_id, match, conditions):
    """Add a match-condition to the supplied issu and rule"""
    return 
  def issu_client_deregister(self):
    """Parse through the issus list and call issu functions based on keys"""
    result = OpEN.openapiISSUClientDeRegister(self.m_client)
    if result == OpEN.OPEN_E_NONE:
      print "\nSuccessfuly de-registered as ISSU client\n"
    else: 
      print "\nFailed to de-register as ISSU client\n"



def main():
  """Demonstrate OpEN usage for ISSU APIs"""
  warmRestart = 0


  ret = open_.connect("issu_example")
  if ret == OpEN.OPEN_E_NONE :
    open_.getNetworkOSVersion()
    client = open_.get_client()
    example = IssuExample(client)
    warmRestart = example.issu_client_register()

    if warmRestart >= 0:
      """ Check first if it is ISSU warm restart, then restore data"""
      if warmRestart == 1:
        example.issu_data_restore()

      """Wait for ISSU save trigger and handle it"""
      example.issu_data_save()

      example.issu_client_deregister()

    open_.terminate()
  else :
    print "Unable to connect"

if __name__ == '__main__': main()

