#
# Copyright 2016 Broadcom.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#


#
# Python 2.6.6
#

import sys
import time
import OpEN_py as OpEN
from OpENUtil import *

open_ = OpENUtil()

class mplsRouter:
  def __init__(self, client):
    self.m_client = client
    self.proto_id = 0
    self.mpls_route_type = 0

  # Register with OpenAPI as a routing protocol.
  #
  def routerRegister(self):
    protocolName = "OLY"
    try:
      proto_array = open_.getStringBuffer(len(protocolName) + 1, protocolName)
    except OpENBufferSizeError:
      print("routerRegister: getStringBuffer raised OpENBufferSizeError")
      return
    except TypeError:
      print("routerRegister: getStringBuffer raised TypeError")
      return
    proto_name = OpEN.open_buffdesc()
    proto_name.pstart = proto_array
    proto_name.size = len(protocolName) + 1

    protocolCode = "O"
    try:
      proto_array = open_.getStringBuffer(len(protocolCode) + 1, protocolCode)
    except OpENBufferSizeError:
      print("routerRegister: getStringBuffer raised OpENBufferSizeError")
      return
    except TypeError:
      print("routerRegister: getStringBuffer raised TypeError")
      return
    proto_code = OpEN.open_buffdesc()
    proto_code.pstart = proto_array
    proto_code.size = len(protocolCode) + 1


    routeTypeName = "OLY MPLS"
    try:
      route_type_name_array = open_.getStringBuffer(len(routeTypeName) + 1, routeTypeName)
    except OpENBufferSizeError:
      print("routerRegister: getStringBuffer raised OpENBufferSizeError")
      return
    except TypeError:
      print("routerRegister: getStringBuffer raised TypeError")
      return
    route_type_name = OpEN.open_buffdesc()
    route_type_name.pstart = route_type_name_array
    route_type_name.size = len(routeTypeName) + 1

    routeTypeCode = "OM"
    try:
      route_type_code_array = open_.getStringBuffer(len(routeTypeCode) + 1, routeTypeCode)
    except OpENBufferSizeError:
      print("routerRegister: getStringBuffer raised OpENBufferSizeError")
      return
    except TypeError:
      print("routerRegister: getStringBuffer raised TypeError")
      return
    route_type_code = OpEN.open_buffdesc()
    route_type_code.pstart = route_type_code_array
    route_type_code.size = len(routeTypeCode) + 1

    out_parm_p = OpEN.new_uint32_tp()

    result = OpEN.openapiRoutingProtocolRegister (self.m_client, 0, OpEN.OPEN_AF_INET,
						proto_name, proto_code, out_parm_p)
    self.proto_id = OpEN.uint32_tp_value(out_parm_p)
    print "Routing Protocol Registration Result:%d  Proto ID:%d" % (result, self.proto_id)

    result = OpEN.openapiRouteTypeRegister (self.m_client, OpEN.OPEN_AF_INET, self.proto_id,
					route_type_name, route_type_code, out_parm_p)	 
    self.mpls_route_type = OpEN.uint32_tp_value(out_parm_p)
    print "Route Type Registration Result:%d  Route Type:%d" % (result, self.mpls_route_type)

    OpEN.delete_uint32_tp(out_parm_p) 

  # Router main loop. Runs forever.
  #
  def routerStart(self):
    ip_prefix      = OpEN.open_inet_addr_t()
    ip_nhop        = OpEN.open_inet_addr_t()
    labels         = OpEN.OPEN_MPLS_LABELS_t()
    out_parm_p     = OpEN.new_uint32_tp()
    route 	   = OpEN.openRoute_t()
    next_hop       = OpEN.openNextHop_t()


    
    # Create 3000 routes to 1000 ToR switches via 22.23.0.5
    #
    total_routes = 0
    print "Adding routes to 61.0.0.0/24 via 22.23.0.5"
    OpEN.openapiSystemUpTimeMsecGet(self.m_client, out_parm_p)
    start_time = OpEN.uint32_tp_value(out_parm_p)

    for tor in range(0, 1000):
      for rt_per_tor in range(0, 3):
    	ip_prefix.family = OpEN.OPEN_AF_INET
    	ip_prefix.addr.ipv4 = 0x3d000000 + (tor << 16) + (rt_per_tor << 8)  # IP 61.0.0.0

    	ip_nhop.family = OpEN.OPEN_AF_INET
    	ip_nhop.addr.ipv4 = 0x16170005   # Next Hop 22.23.0.5 

	route.destPfx = ip_prefix
 	route.pfxLen = 24
	route.routeType = self.mpls_route_type
	route.protoId = self.proto_id
	route.pref = 19
	route.metric = 1
	route.numNextHops = 1
	
	next_hop.ifNum = 76 # Port-based routing interface 0/76
	next_hop.nhAddr = ip_nhop

    	# One label in the MPLS stack.
    	OpEN.uint32_tArray_setitem(next_hop.label,0,1000 + tor)

    	nhop_buff = OpEN.open_buffdesc()
    	nhop_buff.pstart = next_hop
    	nhop_buff.size = sys.getsizeof(next_hop) + 1

	result = OpEN.openapiRouteAddVr(self.m_client, 0, route, nhop_buff)
	total_routes = total_routes + 1

    OpEN.openapiSystemUpTimeMsecGet(self.m_client, out_parm_p)
    end_time = OpEN.uint32_tp_value(out_parm_p)
    delta_time = end_time - start_time
    print "Added %d routes in %d ms" % (total_routes, delta_time)

    time.sleep (3)
    # Modify 3000 routes to 1000 ToR switches via 55.0.0.5 at lower priorority.
    #
    total_routes = 0
    print "Modifying routes to 61.0.0.0/24 via 55.0.0.5"
    OpEN.openapiSystemUpTimeMsecGet(self.m_client, out_parm_p)
    start_time = OpEN.uint32_tp_value(out_parm_p)


    for tor in range(0, 1000):
      for rt_per_tor in range(0, 3):
    	ip_prefix.family = OpEN.OPEN_AF_INET
    	ip_prefix.addr.ipv4 = 0x3d000000 + (tor << 16) + (rt_per_tor << 8)  # IP 61.0.0.0

    	ip_nhop.family = OpEN.OPEN_AF_INET
    	ip_nhop.addr.ipv4 = 0x37000005   # Next Hop 55.0.0.5

	route.destPfx = ip_prefix
 	route.pfxLen = 24
	route.routeType = self.mpls_route_type
	route.protoId = self.proto_id
	route.pref = 19
	route.metric = 1
	route.numNextHops = 1
	
	next_hop.ifNum = 1 # Port-based routing interface 0/1
	next_hop.nhAddr = ip_nhop

    	# One label in the MPLS stack.
    	OpEN.uint32_tArray_setitem(next_hop.label,0,1000 + tor)

    	nhop_buff = OpEN.open_buffdesc()
    	nhop_buff.pstart = next_hop
    	nhop_buff.size = sys.getsizeof(next_hop) + 1

	result = OpEN.openapiRouteModVr(self.m_client, 0, route, nhop_buff)
	total_routes = total_routes + 1



    OpEN.openapiSystemUpTimeMsecGet(self.m_client, out_parm_p)
    end_time = OpEN.uint32_tp_value(out_parm_p)
    delta_time = end_time - start_time
    print "Modified %d routes in %d ms" % (total_routes, delta_time)

    time.sleep (3)


    # Delete 3000 routes to 1000 ToR switches via 55.0.0.5 at lower priorority.
    #
    total_routes = 0
    print "Deleting routes to 61.0.0.0/24 via 55.0.0.5"
    OpEN.openapiSystemUpTimeMsecGet(self.m_client, out_parm_p)
    start_time = OpEN.uint32_tp_value(out_parm_p)

    for tor in range(0, 1000):
      for rt_per_tor in range(0, 3):
    	ip_prefix.family = OpEN.OPEN_AF_INET
    	ip_prefix.addr.ipv4 = 0x3d000000 + (tor << 16) + (rt_per_tor << 8)  # IP 61.0.0.0

    	ip_nhop.family = OpEN.OPEN_AF_INET
    	ip_nhop.addr.ipv4 = 0x37000005   # Next Hop 55.0.0.5

	route.destPfx = ip_prefix
 	route.pfxLen = 24
	route.routeType = self.mpls_route_type
	route.protoId = self.proto_id
	route.pref = 19
	route.metric = 1
	route.numNextHops = 1
	
	next_hop.ifNum = 1 # Port-based routing interface 0/1
	next_hop.nhAddr = ip_nhop

    	# One label in the MPLS stack.
    	OpEN.uint32_tArray_setitem(next_hop.label,0,1000 + tor)

    	nhop_buff = OpEN.open_buffdesc()
    	nhop_buff.pstart = next_hop
    	nhop_buff.size = sys.getsizeof(next_hop) + 1

	result = OpEN.openapiRouteDelVr(self.m_client, 0, route, nhop_buff)
	total_routes = total_routes + 1



    OpEN.openapiSystemUpTimeMsecGet(self.m_client, out_parm_p)
    end_time = OpEN.uint32_tp_value(out_parm_p)
    delta_time = end_time - start_time
    print "Deleted %d routes in %d ms" % (total_routes, delta_time)

    time.sleep (3)


def main():
  """Demonstrate RPPI with MPLS-tagged routes"""

  open = OpENUtil()
  ret = open.connect("mpls_router")
  if ret == OpEN.OPEN_E_NONE :
    open.getNetworkOSVersion()
    open.getAPIVersion()
    client = open.get_client()
    mplsExample = mplsRouter(client)
    mplsExample.routerRegister()
    mplsExample.routerStart()
    open.terminate()
  else :
    print "Unable to connect"

if __name__ == '__main__': main()
