#!/mnt/fastpath/usr/bin/python

"""tx_pkt_example.py: OpEN API Packet Transmit example"""

import OpEN_py as OpEN
from OpENUtil import *
import sys

open_ = OpENUtil()

#
# Copyright 2016 Broadcom.
#
#  Licensed under the Apache License, Version 2.0 (the "License")
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#

#
# Python 2.6.6
#

PKT_LEN = 128
       
def print_sanity_results(result, test, msg, feat) :
  """Print overall comparison results"""

  if result == OpEN.OPEN_E_UNAVAIL:
    print "Sanity test skipped."
  elif result == OpEN.OPEN_E_EXISTS:
    print "Sanity Skipped (already exists) - %s - %s." % (msg, feat)
  elif result == OpEN.OPEN_E_NONE and test == True:
    print "Sanity Success - %s - %s." % (msg, feat)
  else:
    print "Sanity Failure - %s - %s." % (msg, feat)

def print_bad_result(result, msg) :
  """Print some general error messages if the result is bad"""
   
  if result == OpEN.OPEN_E_UNAVAIL:
    print "Feature not supported - %s (err %d)." % (msg, result)
  elif result == OpEN.OPEN_E_NOT_FOUND:
      print "Test Skipped (not found) - ", msg
  elif result != OpEN.OPEN_E_NONE:
    print "Test Failure - %s (err %d)." % (msg, result)  

class TxPktExample :
  """Packet transmission """

  def __init__(self, client) :
    self.m_client = client
      
  def test_tx_pkt(self, intf) :
    """Send a packet using Unicast transmission"""

    intf_max_p = OpEN.new_uint32_tp()

    result = OpEN.openapiMaxInterfaceCountGet(self.m_client, intf_max_p)
    if result == OpEN.OPEN_E_NONE:
      max_intf = OpEN.uint32_tp_value(intf_max_p)
      if intf < 1 or intf > max_intf:
        print "Invalid interface. The available range is 1 to %d." % max_intf
        OpEN.delete_uint32_tp(intf_max_p)
        return
    else:
      OpEN.delete_uint32_tp(intf_max_p)
      return

    # Build a dummy ethernet packet
    pkt_data = "\x00\x01\x02\x03\x04\x05"
    pkt_data += "\x06\x07\x08\x09\x0a\x0b"
    pkt_data += "\xcc" * (PKT_LEN-len(pkt_data))

    try:
      pkt_string = open_.getByteBuffer(PKT_LEN, pkt_data)
    except OpENBufferSizeError:
      print("test_tx_pkt: getByteBuffer raised OpENBufferSizeError")
      return
    except TypeError:
      print("test_tx_pkt: getByteBuffer raised TypeError")
      return
    pkt_buff = OpEN.open_buffdesc()
    pkt_buff.pstart = pkt_string
    pkt_buff.size = PKT_LEN

    print "Send Packet..."
    result = OpEN.openapiExtPktTransmit(self.m_client, pkt_buff, OpEN.OPEN_EXT_PKT_TX_L2RAW_UNICAST, intf, 0, 0) 
    print_bad_result(result, 'openapiExtPktTransmit')
    print_sanity_results(result, (1 == 1), 'openapiExtPktTransmit', 'ifnum %d' % intf)
    OpEN.delete_uint32_tp(intf_max_p)

def main(argv) :
  """Demonstrate OpEN usage for Packet API"""

  if len(argv) == 1:
    try:
      intf = int(argv[0])
    except:
      print 'Invalid interface, <ifnum> must be numeric.'
      sys.exit()
  else:
    print 'tx_pkt_example.py <ifnum>'
    sys.exit()

  ret = open_.connect("tx_pkt_example")
  if ret == OpEN.OPEN_E_NONE :
    open_.getNetworkOSVersion()
    client = open_.get_client()
    example = TxPktExample(client)
    example.test_tx_pkt(intf)
    open_.terminate()
  else :
    print "Unable to connect"

if __name__ == '__main__':
  main(sys.argv[1:])


