#
# Copyright 2016 Broadcom.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#


#
# Python 2.6.6
#

import OpEN_py as OpEN
from OpENUtil import *


class StormControl:
  def __init__(self, client):
    self.m_client = client

  def stormControlModeSet(self, ctrlMode, state):
    result = OpEN.openapiStormControlModeSet(self.m_client, ctrlMode, state)
    if result == OpEN.OPEN_E_NONE:
      print "Storm control mode %d is set successfully state: %d. (result = %d) \n" % (ctrlMode, state, result)
    else:
      print "Bad return code trying to set global storm control mode. (result = %d) \n" % (result)


  def stormControlModeGet(self, ctrlMode):
    state_p = OpEN.new_OPEN_CONTROL_tp()

    result = OpEN.openapiStormControlModeGet(self.m_client, ctrlMode, state_p)
    if result == OpEN.OPEN_E_NONE:
      print "Get storm control mode %d state: %d successfully (result = %d) \n" % (ctrlMode, OpEN.OPEN_CONTROL_tp_value(state_p), result)
    else:
      print "Bad return code trying to get global storm control mode. (result = %d) \n" % (result)

    OpEN.delete_OPEN_CONTROL_tp(state_p)


  def stormControlThresholdSet(self, ctrlMode, rateUnit, threshold):
    minVal_p = OpEN.new_uint32_tp()
    maxVal_p = OpEN.new_uint32_tp()
    result = OpEN.openapiStormControlThresholdMinMaxGet(self.m_client, rateUnit, minVal_p, maxVal_p)

    minVal = OpEN.uint32_tp_value(minVal_p)
    maxVal = OpEN.uint32_tp_value(maxVal_p)

    if result == OpEN.OPEN_E_NONE:
      if (threshold < minVal) or (threshold > maxVal):
        print "Invalid Threshold value. The allowable range is %d - %d.\n"  % (minVal, maxVal)
        result = OpEN.OPEN_E_PARAM

    if result == OpEN.OPEN_E_NONE:
      result = OpEN.openapiStormControlThresholdSet(self.m_client, ctrlMode, rateUnit, threshold)
      if result == OpEN.OPEN_E_NONE:
        print "Storm control rate unit (%d) and threshold (%d) for mode %d is set successfully. (result = %d) \n" % (rateUnit, threshold, ctrlMode, result)
      else:
        print "Bad return code trying to set global storm control rate unit and threshold. (result = %d) \n" % (result)

    OpEN.delete_uint32_tp(minVal_p)
    OpEN.delete_uint32_tp(maxVal_p)


  def stormControlThresholdDefaultSet(self, ctrlMode):
    result = OpEN.openapiStormControlThresholdDefaultSet(self.m_client, ctrlMode)
    if result == OpEN.OPEN_E_NONE:
      print "Storm control rate unit and threshold for mode %d is set to default successfully. (result = %d) \n" % (ctrlMode, result)
    else:
      print "Bad return code trying to set global storm control rate unit and threshold to default. (result = %d) \n" % (result)


  def stormControlThresholdGet(self, ctrlMode):
    rateUnit_p = OpEN.new_OPEN_RATE_UNIT_tp()
    threshold_p = OpEN.new_uint32_tp()

    result = OpEN.openapiStormControlThresholdGet(self.m_client, ctrlMode, rateUnit_p, threshold_p)
    if result == OpEN.OPEN_E_NONE:
      print "Get storm control mode %d threshold: %d, rateUnit: %d (result = %d) \n" % (ctrlMode, OpEN.uint32_tp_value(threshold_p), OpEN.OPEN_RATE_UNIT_tp_value(rateUnit_p), result)
    else:
      print "Bad return code trying to get global storm control rate unit and threshold for mode. (result = %d) \n" % (result)

    OpEN.delete_OPEN_RATE_UNIT_tp(rateUnit_p)
    OpEN.delete_uint32_tp(threshold_p)


  def stormControlIntfModeSet(self, ctrlMode, intf, state):
    result = OpEN.openapiStormControlIntfModeSet(self.m_client, ctrlMode, intf, state)
    if result == OpEN.OPEN_E_NONE:
      print "Storm Control mode %d is set successfully on interface %d. (result = %d) \n" % (ctrlMode, intf, result)
    else:
      print "Bad return code trying to set storm control mode on an interface. (result = %d) \n" % (result)


  def stormControlIntfModeGet(self, ctrlMode, intf):
    state_p = OpEN.new_OPEN_CONTROL_tp()

    result = OpEN.openapiStormControlIntfModeGet(self.m_client, ctrlMode, intf, state_p)
    if result == OpEN.OPEN_E_NONE:
      print "State of Storm Control mode %d on interface %d: %d. (result = %d) \n" % (ctrlMode, intf, OpEN.OPEN_CONTROL_tp_value(state_p), result)
    else:
      print "Bad return code trying to get storm control mode on an interface. (result = %d) \n" % (result)

    OpEN.delete_OPEN_CONTROL_tp(state_p)


  def stormControlIntfThresholdSet(self, ctrlMode, intf, rateUnit, threshold):
    minVal_p = OpEN.new_uint32_tp()
    maxVal_p = OpEN.new_uint32_tp()
    result = OpEN.openapiStormControlThresholdMinMaxGet(self.m_client, rateUnit, minVal_p, maxVal_p)

    minVal = OpEN.uint32_tp_value(minVal_p)
    maxVal = OpEN.uint32_tp_value(maxVal_p)

    if result == OpEN.OPEN_E_NONE:
      if (threshold < minVal) or (threshold > maxVal):
        print "Invalid Threshold value. The allowable range is %d - %d.\n"  % (minVal, maxVal)
        result = OpEN.OPEN_E_PARAM

    if result == OpEN.OPEN_E_NONE:
      result = OpEN.openapiStormControlIntfThresholdSet(self.m_client, ctrlMode, intf, rateUnit, threshold)
      if result == OpEN.OPEN_E_NONE:
        print "Storm Control rate unit and threshold for mode %d on interface %d is set successfully. (result = %d) \n" % (ctrlMode, intf, result)
      else:
        print "Bad return code trying to set storm control rate unit and threshold on an interface. (result = %d) \n" % (result)

    OpEN.delete_uint32_tp(minVal_p)
    OpEN.delete_uint32_tp(maxVal_p)


  def stormControlIntfThresholdDefaultSet(self, ctrlMode, intf):
    result = OpEN.openapiStormControlIntfThresholdDefaultSet(self.m_client, ctrlMode, intf)
    if result == OpEN.OPEN_E_NONE:
      print "Storm Control rate unit and threshold for mode %d on interface %d is set to default successfully. (result = %d) \n" % (ctrlMode, intf, result)
    else:
      print "Bad return code trying to set storm control rate unit and threshold to default on an interface. (result = %d) \n" % (result)


  def stormControlIntfThresholdGet(self, ctrlMode, intf):
    rateUnit_p = OpEN.new_OPEN_RATE_UNIT_tp()
    threshold_p = OpEN.new_uint32_tp()

    result = OpEN.openapiStormControlIntfThresholdGet(self.m_client, ctrlMode, intf, rateUnit_p, threshold_p)
    if result == OpEN.OPEN_E_NONE:
      print "Storm Control rate unit (%d) and threshold (%d) for mode %d on interface %d get successfully. (result = %d) \n" % (OpEN.OPEN_RATE_UNIT_tp_value(rateUnit_p), OpEN.uint32_tp_value(threshold_p), ctrlMode, intf, result)
    else:
      print "Bad return code trying to get storm control rate unit and threshold on an interface for mode %d. (result = %d) \n" % (ctrlMode, result)

    OpEN.delete_OPEN_RATE_UNIT_tp(rateUnit_p)
    OpEN.delete_uint32_tp(threshold_p)


def main():
  """Demonstrate OpEN usage for Storm Control APIs"""

  open = OpENUtil()
  ret = open.connect("storm_control_example")
  if ret == OpEN.OPEN_E_NONE :
    open.getNetworkOSVersion()
    open.getAPIVersion()
    client = open.get_client()
    stormCtrlExample = StormControl(client)
    stormCtrlExample.stormControlModeSet(OpEN.OPEN_STORM_CTRL_MODE_MULTICAST, OpEN.OPEN_ENABLE)
    stormCtrlExample.stormControlModeGet(OpEN.OPEN_STORM_CTRL_MODE_MULTICAST)
    stormCtrlExample.stormControlThresholdDefaultSet(OpEN.OPEN_STORM_CTRL_MODE_MULTICAST)
    stormCtrlExample.stormControlThresholdSet(OpEN.OPEN_STORM_CTRL_MODE_MULTICAST, OpEN.OPEN_RATE_UNIT_PERCENT, 50)
    stormCtrlExample.stormControlThresholdGet(OpEN.OPEN_STORM_CTRL_MODE_MULTICAST)
    intfId = 2
    stormCtrlExample.stormControlIntfModeSet(OpEN.OPEN_STORM_CTRL_MODE_MULTICAST, intfId, OpEN.OPEN_ENABLE)
    stormCtrlExample.stormControlIntfModeGet(OpEN.OPEN_STORM_CTRL_MODE_MULTICAST, intfId)
    stormCtrlExample.stormControlIntfThresholdDefaultSet(OpEN.OPEN_STORM_CTRL_MODE_MULTICAST, intfId)
    stormCtrlExample.stormControlIntfThresholdSet(OpEN.OPEN_STORM_CTRL_MODE_MULTICAST, intfId, OpEN.OPEN_RATE_UNIT_PERCENT, 50)
    stormCtrlExample.stormControlIntfThresholdGet(OpEN.OPEN_STORM_CTRL_MODE_MULTICAST, intfId)
    open.terminate()
  else :
    print "Unable to connect"

if __name__ == '__main__': main()
