#
# Cookbook Name:: boa
# File:: resources/logging.rb
#
# Copyright 2016 Broadcom.
#
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#
actions :create, :delete, :enable
default_action :create

attribute :host,       :kind_of => String, :name_attribute => true
attribute :port,       :kind_of => Integer, :required => true, :regex => /^([1-9][0-9]{0,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])$/
attribute :severity,   :equal_to => ['emergency','alert','critical','error','warning','notice','info','debug'], :default => 'info'
attribute :active,     :kind_of => [TrueClass, FalseClass], :default => true

attr_accessor :exists

