/*********************************************************************
*
* (C) Copyright Broadcom Corporation 2012-2018
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*************************************************************************
*
* @filename  instru_bhd_example.c
*
* @purpose   Instrumentation - Blackhole detection (BHD) Example.
*
* @component OPEN
*
* @comments
*
* @create    26/7/2016
*
* @end
*
***************************************************************************/
#include <stdlib.h>
#include <stdbool.h>
#include <unistd.h>

#include "rpcclt_openapi.h"
#include "proc_util.h"
#include "openapi_common.h"
#include "openapi_instru_bhd.h"
#include "openapi_instru_packet_trace.h"

/*******************************************************************
*
* @brief  This is the main function that will demonstrate 
*         Packet Trace OpEN APIs.
*
* @returns  0: Success
* @returns  1: Failure
*
********************************************************************/
int main(int argc, char **argv)
{
  openapiClientHandle_t clientHandle;
  open_error_t result = OPEN_E_FAIL;
  open_buffdesc switch_os_revision;
  char switch_os_revision_string[100];
  
  OPEN_BHD_PORT_SFLOW_SAMPLING_STATUS_t  status;
  OPEN_BLACK_HOLE_CONFIG_t  config;
  uint32_t asic = 0;
  uint32_t port = 0;
  int      sampling_capabilities;
  open_buffdesc  port_list;

  l7proc_crashlog_register();

  /* Register with OpEN */
  if ((result = openapiClientRegister("instru_bhd_example", &clientHandle)) != OPEN_E_NONE)
  {
    printf("\nFailed to initialize RPC to OpEN. Exiting result = %d\n", result);
    exit(2);
  }

  /* RPC call can fail until server starts. Keep trying */
  while (openapiConnectivityCheck(&clientHandle) != OPEN_E_NONE)
  {
    sleep(1);
  }
  printf("\n");
  switch_os_revision.pstart = switch_os_revision_string;
  switch_os_revision.size = sizeof(switch_os_revision_string);
  if (openapiNetworkOSVersionGet(&clientHandle, &switch_os_revision) == OPEN_E_NONE)
  {
    printf("Network OS version = %s\n", switch_os_revision_string);
  }
  else
  {
    printf("Network OS version retrieve error\n");
  }
  printf("\n");

  strcpy((char *) config.black_hole_port_list_str, "0/1,0/2,0/5");
  config.sampling_config.sampling_method =  OPEN_BHD_AGENT_SAMPLING;
  config.sampling_config.sampling_params.agent_sampling_params.water_mark = 10;
  config.sampling_config.sampling_params.agent_sampling_params.sample_periodicity = 10;
  config.sampling_config.sampling_params.agent_sampling_params.sample_count = 10;

  if ((result = openapiBhdBlackHoleConfigure(&clientHandle, asic, &config)) != OPEN_E_NONE)
  {
    printf("Bad return code trying to configure BHD. result = %d\n", result);
    return 1;
  }
  else
  {
    printf("Success to configure BHD\n");
  }

  if ((result = openapiBhdAsicCapabilitiesGet(&clientHandle, asic, &sampling_capabilities)) != OPEN_E_NONE)
  {
    printf("Bad return code trying to BHD Asic capabilities get. result = %d\n", result);
    return 1;
  }
  else
  {
    printf("Success to BHD Asic Capabilities Get %d\n",sampling_capabilities);
  }

  port_list.pstart = config.black_hole_port_list_str;
  port_list.size =  sizeof(config.black_hole_port_list_str);
  if ((result = openapiBhdSflowSamplingStatusGet(&clientHandle, asic, port, &port_list, &status)) != OPEN_E_NONE)
  {
    printf("Bad return code trying to BHD SamplingStatus Get result = %d\n", result);
    return 1;
  }
  else
  {
    printf("Success to BHD Sampling Status Get \n");
  }

  /* Log goodbye message with OPEN */
  L7PROC_LOGF(L7PROC_LOG_SEVERITY_INFO, 0, "Stopping Blackhole detection  API example application");
  return 0;
}

