/*********************************************************************
*
* Copyright 2016-2018 Broadcom.
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*************************************************************************
*
* @filename  instru_nos_example.c
*
* @purpose   System Information Example.
*
* @component OPEN
*
* @comments
*
* @create    1/27/2016
*
* @end
*
***************************************************************************/
#include <stdlib.h>
#include <stdbool.h>
#include <unistd.h>
#include "zlib.h"

#include "rpcclt_openapi.h"
#include "proc_util.h"
#include "openapi_common.h"
#include "openapi_instru_nos.h"

/* RPC parameter data area maximum */
#define BST_RPC_PARM_DATA_AREA_MAX             (256 * 1024)
/* Max size of all RPC parameter data. Instrumentaion app requires more RPC data size. */
#define BST_RPC_DEVMSG_DATA_MAX                (BST_RPC_PARM_DATA_AREA_MAX * 2)
#define BST_MAX_COMPRESSED_LEN                 (BST_RPC_DEVMSG_DATA_MAX - 1024) 

/*****************************************************************************
* @purpose  Test compressed max snapshot get. 
*
* @param    clientHandle   @b{(input)}  client handle from registration API
* @param    asicId         @b{(input)}  ASIC number in the system.
* 
* @returns  none
* 
* @notes    none
*           
* @end
******************************************************************************/
open_error_t testBstMaxSnapshotCompressedGet(openapiClientHandle_t *clientHandle, int asicId)
{
  OPEN_BST_ASIC_SNAPSHOT_DATA_COMPRESSED_t snapshot;
  unsigned char                            compData[BST_MAX_COMPRESSED_LEN];
  open_error_t                             result = OPEN_E_NONE;
  open_buffdesc                            compSnapshot;
  time_t                                   time;
  uLongf                                   uncompressedLength = 0;
  int                                      retCode;

  memset(&snapshot, 0, sizeof(snapshot));
  memset(&compData, 0, sizeof(compData));

  compSnapshot.pstart = compData;
  compSnapshot.size = sizeof(compData);

  result = openapiBstMaxSnapshotCompressedGet(clientHandle, asicId, &compSnapshot, &time);
  if (result == OPEN_E_NONE)
  {
    printf("Reading of compressed max snapshot of all buffers succeeded\n");
    uncompressedLength = sizeof(snapshot);
    retCode = uncompress((unsigned char *)&snapshot, &uncompressedLength,
                         (unsigned char *)compSnapshot.pstart, compSnapshot.size);

    if (retCode == Z_OK)
    {
      printf("Successfully decompressed data\n");
    }
    else
    {
      printf("Unable to decompress data\n");
      result = OPEN_E_ERROR;
    }
  }
  else
  {
    printf("Reading of compressed max snapshot of all buffers failed\n");
  }

  return result;
}

/*******************************************************************
*
* @brief  This is the main function that will demonstrate 
*         System Information OpEN APIs.
*
* @returns  0: Success
* @returns  1: Failure
*
********************************************************************/
int main(int argc, char **argv)
{
  openapiClientHandle_t clientHandle;
  open_error_t result = OPEN_E_FAIL;
  open_buffdesc switch_os_revision,mac,familyName;
  char switch_os_revision_string[100];
  int second,nanosecond,maxPhysPorts,maxHiGigPorts;
  l7proc_crashlog_register();
  char macAdd[100] = "\0";
  char family[100] = "\0";
  OPEN_ASIC_CAPABILITIES_ALL_t asicCap;
  int asic = 0;

  /* Register with OpEN */
  if ((result = openapiClientRegister("instru_nos_example", &clientHandle)) != OPEN_E_NONE)
  {
    printf("\nFailed to initialize RPC to OpEN. Exiting result = %d\n", result);
    exit(2);
  }

  /* RPC call can fail until server starts. Keep trying */
  while (openapiConnectivityCheck(&clientHandle) != OPEN_E_NONE)
  {
    sleep(1);
  }
  printf("\n");
  switch_os_revision.pstart = switch_os_revision_string;
  switch_os_revision.size = sizeof(switch_os_revision_string);
  if (openapiNetworkOSVersionGet(&clientHandle, &switch_os_revision) == OPEN_E_NONE)
  {
    printf("Network OS version = %s\n", switch_os_revision_string);
  }
  else
  {
    printf("Network OS version retrieve error\n");
  }
  printf("\n");

  mac.size = OPEN_MAC_ADDR_LEN;
  mac.pstart = macAdd;

  if (0 == openapiMacAddrGet(&clientHandle, &mac))
  {
      printf("Success to get System MAC Address: %.02X:%.02X:%.02X:%.02X:%.02X:%.02X\n",macAdd[0]&0xFF,
              macAdd[1]&0xFF, macAdd[2]&0xFF, macAdd[3]&0xFF, macAdd[4]&0xFF, macAdd[5]&0xFF);
  }
  else
  {
    printf("Failure to get System MAC Address\n");
  }

  if (0 == openapiTimeGet(&clientHandle, &second, &nanosecond))
  {
    printf("Success to get System Time: %d seconds %d nanoseconds\n",second,nanosecond );
  }
  else
  {
    printf("Failure to get System Time\n" );
  }

  familyName.size = 100;
  familyName.pstart = family;

  if (0 == openapiChipFamilyNameGet(&clientHandle, &familyName))
  {
    printf("Success to get Chip Family Name: %s\n", (char *) familyName.pstart);
  }
  else
  {
    printf("Failure to get Chip Family Name\n");
  }

  if (0 == openapiHwMaxPortsGet(&clientHandle, &maxPhysPorts, &maxHiGigPorts))
  {
    printf("Success to get Chip Max Ports: MAX Physical ports: %d, and  MAX Hi Gig Ports: %d\n",maxPhysPorts,maxHiGigPorts );
  }
  else
  {
    printf("Failure to get Chip Max Ports\n" );
  }

  if (0 == openapiAsicCapabilityGet(&clientHandle, asic, &asicCap))
  {
    printf("successfully retrieved asic capability\n");
  }
  else
  {
    printf("Unable to get asic capability.\n");
  }

  /* Testing of compressed BST snapshot get */
  testBstMaxSnapshotCompressedGet(&clientHandle, asic);

  /* Log goodbye message with OPEN */
  L7PROC_LOGF(L7PROC_LOG_SEVERITY_INFO, 0, "Stopping System Information example application");

  (void) openapiClientTearDown(&clientHandle);
  return 0;
}

