#
# Copyright 2016 Broadcom.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#


#
# Python 2.6.6
#

import OpEN_py as OpEN
from OpENUtil import *
import sys

open_ = OpENUtil()

class IpExample:
  def __init__(self, client):
    self.m_client = client

  def ipExampleUsage(self):
    ipAddr         = "1.2.3.4"
    sz = len(ipAddr) + 1
    try:
      ip_array       = open_.getStringBuffer(sz, ipAddr)
    except OpENBufferSizeError:
      print("received an OpENBufferSizeError exception")
      sys.exit(1)
    except TypeError:
      print("received a TypeError exception")
      sys.exit(1)

    ip_buff        = OpEN.open_buffdesc()
    ip_buff.pstart = ip_array
    ip_buff.size   = sz 
    ip_int_p       = OpEN.new_uint32_tp()
    if_num_p       = OpEN.new_uint32_tp()
    outParameter_p = OpEN.new_uint32_tp()

    result = OpEN.openapiInetAton(self.m_client, ip_buff, ip_int_p)
    ip_value = OpEN.uint32_tp_value(ip_int_p)

    if result == OpEN.OPEN_E_NONE:
      print "IP address is: string - '%s' integer - '%d'" % (ipAddr, ip_value)
    else:
      print "Bad return code trying to convert internet address string to a 32 bit integer. result = %d" % (result)

    result = OpEN.openapiIfFirstGet(self.m_client, OpEN.OPEN_INTF_TYPE_PHY, if_num_p)
    if result != OpEN.OPEN_E_NONE:
      print "Bad return code trying to get first physical interface. result = %d" % (result)
      return 0

    if_value = OpEN.uint32_tp_value(if_num_p)
    result = OpEN.openapiIpAdEntAddrGet(self.m_client, ip_value, if_value)
    if result == OpEN.OPEN_E_NONE:
      print "Specified address entry exists."
    else:
      print "The specified address entry does not exist. result = %d" % (result)

    result = OpEN.openapiIpAdEntAddrGetNext(self.m_client, ip_int_p, if_num_p)
    ip_value = OpEN.uint32_tp_value(ip_int_p)
    if result == OpEN.OPEN_E_NONE:
      print "The first interface (%d) contains address entry %d." % (if_value, ip_value)
    else:
      print "The first interface (%d) does not contain an address entry. result = %d" % (if_value, result)

    result = OpEN.openapiIpAdEntAddrGetNext(self.m_client, ip_int_p, if_num_p)
    ip_value = OpEN.uint32_tp_value(ip_int_p)
    if result == OpEN.OPEN_E_NONE:
      print "The second interface (%d) contains address entry %d." % (if_value, ip_value)
    else:
      print "The second interface (%d) does not contain an address entry. result = %d" % (if_value, result)

    result = OpEN.openapiIpEntIfIndexGet(self.m_client, ip_value, outParameter_p)
    if result == OpEN.OPEN_E_NONE:
      print "The last interface index value is: %d" % (OpEN.uint32_tp_value(outParameter_p))
    else:
      print "The last interface index value does not exist. result = %d" % (result)

    OpEN.uint32_tp_assign(outParameter_p, 0)
    result = OpEN.openapiIpAdEntNetMaskGet(self.m_client, ip_value, outParameter_p)
    if result == OpEN.OPEN_E_NONE:
      print "IP Address  (digital value) is: %d" % (ip_value)
      print "Subnet mask (digital value) is: %d" % (OpEN.uint32_tp_value(outParameter_p))
    else:
      print "Bad return code trying to get the subnet mask. result = %d" % (result)

    OpEN.uint32_tp_assign(outParameter_p, 0)
    result = OpEN.openapiIpAdEntBCastGet(self.m_client, ip_value, outParameter_p)
    if result == OpEN.OPEN_E_NONE:
      print "Value of the least-significant bit in the IP broadcast address is: %d" % (OpEN.uint32_tp_value(outParameter_p))
    else:
      print "Bad return code trying to get the value of the least-significant bit in the IP broadcast address. result = %d" % (result)

    OpEN.uint32_tp_assign(outParameter_p, 0)
    result = OpEN.openapiIpAdEntReasmMaxSizeGet(self.m_client, ip_value, outParameter_p)
    if result == OpEN.OPEN_E_NONE:
      print "Size of the largest IP datagram is: %d" % (OpEN.uint32_tp_value(outParameter_p))
    else:
      print "Bad return code trying to get the size of the largest IP datagram. result = %d" % (result)

    OpEN.delete_uint32_tp(ip_int_p)
    OpEN.delete_uint32_tp(if_num_p)
    OpEN.delete_uint32_tp(outParameter_p)

def main():
  """Demonstrate OpEN usage for IP APIs"""

  open = OpENUtil()
  ret = open.connect("ip_example")
  if ret == OpEN.OPEN_E_NONE :
    open.getNetworkOSVersion()
    open.getAPIVersion()
    client = open.get_client()
    ipExample = IpExample(client)
    ipExample.ipExampleUsage()
    open.terminate()
  else :
    print "Unable to connect"

if __name__ == '__main__': main()
