import OpEN_py as OpEN
from OpENUtil import *
open_ = OpENUtil()


#
# Copyright 2016 Broadcom.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#


#
# Python 2.6.6
#

class LagExample :
  def __init__(self, client) :
    self.m_client = client
   

  def show_max_member(self):
    temMaxMem = OpEN.new_uint32_tp()
    maxMem = 0
    result = OpEN.openapiLagMaxMemberCountGet(self.m_client, temMaxMem)
    if (result != OpEN.OPEN_E_NONE) :
      print "Failed to get the maximum number of member ports."
    else:
      maxMem = OpEN.uint32_tp_value(temMaxMem)
      print "Maximum of [ %s ] member ports supported on this platform" % (temMaxMem)
    OpEN.delete_uint32_tp(temMaxMem)
    return maxMem
  
  def if_first_get (self):
      lagIfNumTemp = OpEN.new_uint32_tp()
      lagIfNum = -1
      result = OpEN.openapiIfFirstGet(self.m_client, OpEN.OPEN_INTF_TYPE_LAG, lagIfNumTemp)
      if (result != OpEN.OPEN_E_NONE) :
        print "Bad return code trying to get first LAG interface."
      else:
        lagIfNum = OpEN.uint32_tp_value(lagIfNumTemp)
      OpEN.delete_uint32_tp(lagIfNumTemp)
      return lagIfNum

  def lag_port_add (self, lagIfNum, ifNum):
      result = OpEN.openapiLagPortAdd(self.m_client, lagIfNum, ifNum)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else:
       return 0

  def lag_member_list_get (self, lagIfNum, count, portChannelMembersList):
      result = OpEN.openapiLagMembersListGet(self.m_client, lagIfNum, count, portChannelMembersList)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else:
       return 0
  def lag_port_delete (self, lagIfNum, ifNum):
      result = OpEN.openapiLagPortDelete(self.m_client, lagIfNum, ifNum)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else:
       return 0

  def lag_static_mode_get (self, lagIfNum, mode):
      result = OpEN.openapiLagStaticModeGet(self.m_client, lagIfNum, mode)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else:
       return 0

def main():
    """Demonstrate OpEN usage for LAG APIs"""

    ret = open_.connect("lag_example")
    if ret == OpEN.OPEN_E_NONE :
      open_.getNetworkOSVersion()
      client = open_.get_client()
      
      example = LagExample(client)
      
      lagIfFirstGet = example.if_first_get()
      if (lagIfFirstGet != -1):
       lagMaxMem = example.show_max_member()
       print "Using the first LAG interface %s" % (lagIfFirstGet)
       print "Adding ports from 1 to %s to LAG interface %s" % (lagMaxMem, lagIfFirstGet)
       for interface in range(1, lagMaxMem + 1):
         if (example.lag_port_add(lagIfFirstGet, interface) != 0): 
          print "Failed to add interface %s to LAG interface %s " % (lagIfFirstGet, interface)
          break

       count = OpEN.new_uint32_tp()
       OpEN.uint32_tp_assign(count, lagMaxMem)
       max_len = OPEN_LAG_MEMBER_BUFFER_SIZE
       try:
        name_string  = open_.getStringBuffer(max_len) 
       except OpENBufferSizeError:
        print("main: getStringBuffer raised OpENBufferSizeError")
        return
       except TypeError:
        print("main: getStringBuffer raised TypeError")
        return 
       portChannelMembersList = OpEN.open_buffdesc()
       portChannelMembersList.pstart = name_string
       portChannelMembersList.size = max_len
       if (example.lag_member_list_get(lagIfFirstGet, count, portChannelMembersList) == 0):
        countTemp = OpEN.uint32_tp_value(count)
        print "Comma delimited list of member ports for LAG interface %s (%s) (%s)" % (lagIfFirstGet, countTemp, name_string.cast())
       else:
        print "Failed to get the member ports for the LAG interface %s" % (lagIfFirstGet)
       OpEN.delete_uint32_tp(count)

       print "Deleting port 1 to %s from LAG interface %s" % (lagMaxMem, lagIfFirstGet)
       for interface in range(1, lagMaxMem + 1):
        if (example.lag_port_add(lagIfFirstGet, interface) != 0): 
         print "Failed to delete interface %s from LAG interface %s " % (lagIfFirstGet, interface)
         break
       print "Getting the current LAG interface %s static mode" % (lagIfFirstGet)
       tempMode = OpEN.new_OPEN_CONTROL_tp()

       if (example.lag_static_mode_get(lagIfFirstGet, tempMode) != 0):
        print "Failed to get the static mode for the LAG interface: %s" % (lagIfFirstGet)
       else:
        mode = OpEN.OPEN_CONTROL_tp_value(tempMode)
        if (mode == 1):
         print "LAG interface mode is static"
        else:
         print "LAG interface mode is dynamic"
    else :
      print "Unable to connect"
    open_.terminate()
if __name__ == '__main__': main()
