
/*********************************************************************
*
* Copyright 2016-2018 Broadcom.
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
**********************************************************************
*
* @filename  tx_pkt_example.c
*
* @purpose   Transmit Packet APIs Example.
*
* @component OPEN
*
* @comments
*
* @create    11/12/2012
*
* @end
*
**********************************************************************/
#include <stdlib.h>
#include <unistd.h>

#include "rpcclt_openapi.h"
#include "proc_util.h"
#include "openapi_common.h"
#include "openapi_pkt.h"


#define PKT_LEN           (128)
/*******************************************************************
*
* @brief  This is the main function that will demonstrate 
*         Packet OpEN APIs.
*
* @returns  0: Success
* @returns  1: Failure
*
*********************************************************************/
int
main (int argc, char **argv)
{
  openapiClientHandle_t clientHandle;
  uint32_t ifNum, maxIfNum;
  open_error_t result;
  open_buffdesc switch_os_revision;
  char switch_os_revision_string[100];
  char    destMac[] = {0x0, 0x1, 0x2, 0x3, 0x4, 0x5};
  char    srcMac[]  = {0x6, 0x7, 0x8, 0x9, 0xa, 0xb};
  char *data, *pkt;
  open_buffdesc buffDesc;
  
  if (argc != 2)
    {
      printf("Usage: %s <ifnum> \n", argv[0]);
      exit (1);
    }

  ifNum = atoi(argv[1]);

  l7proc_crashlog_register ();

  /* Register with OpEN */
  if ((result = openapiClientRegister ("tx_pkt_example", &clientHandle)) != OPEN_E_NONE)
    {
      printf ("\nFailed to initialize RPC to OpEN. Exiting (result = %d)\n", result);
      exit (2);
    }

  /* RPC call can fail until server starts. Keep trying */
  while (openapiConnectivityCheck (&clientHandle) != OPEN_E_NONE)
  {
    sleep (1);
  }

  L7PROC_LOGF (L7PROC_LOG_SEVERITY_INFO, 0,
	       "Starting packet transmit API example application");

  /* Validate interface */
  if (OPEN_E_NONE != openapiMaxInterfaceCountGet(&clientHandle, &maxIfNum))
  {
    printf ("Can't get Interface Count.\n");
    exit (2);
  }
  else if (ifNum > maxIfNum)
  {
    printf ("Invalid interface. Interface can not exceed %d.\n", maxIfNum);
    exit (2);
  }

  printf ("\n");
  switch_os_revision.pstart = switch_os_revision_string;
  switch_os_revision.size = sizeof (switch_os_revision_string);
  if (openapiNetworkOSVersionGet (&clientHandle, &switch_os_revision) == OPEN_E_NONE)
  {
    printf ("Network OS version = %s\n", switch_os_revision_string);
  }
  else
  {
    printf ("Network OS version retrieve error\n");
  }

  printf ("\n");

  data = (char *) malloc(PKT_LEN);
  if (data  == ((void *)0))
  {
    printf("Failed to allocate memory\n");
    return 1;
  }

  memset(data, 0, PKT_LEN);
  pkt = data;

  memcpy (pkt, destMac, sizeof(destMac));
  pkt += sizeof(destMac);

  memcpy(pkt, srcMac, sizeof(srcMac));
  pkt += sizeof(srcMac);

  memset(pkt, 0xcc, PKT_LEN - 12);
  buffDesc.size = PKT_LEN;
  buffDesc.pstart = (char *) data;
  if ((result = openapiExtPktTransmit(&clientHandle, &buffDesc,OPEN_EXT_PKT_TX_NORMAL_UNICAST, ifNum, 0, 0)) != OPEN_E_NONE)
  {
    printf("  Bad return code trying transmit the packet on interface %d. (result = %d)\n",ifNum,result);
    return 1;
  }
  else
  {
    printf("packet transmitted on interface : %d\n",ifNum);
  }
  /* Log goodbye message with OPEN */
  L7PROC_LOGF (L7PROC_LOG_SEVERITY_INFO, 0,
	       "Stopping transmit packet API example application");

  (void) openapiClientTearDown(&clientHandle);
  return 0;
}
